/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.scripting.internal.executor;

import com.liferay.object.scripting.executor.ObjectScriptingExecutor;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.lang.ThreadContextClassLoaderUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.scripting.ScriptingExecutor;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.scripting.ScriptingExecutorRegistry;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"scripting.language=groovy"}, service={ObjectScriptingExecutor.class})
public class GroovyObjectScriptingExecutor
implements ObjectScriptingExecutor {
    private static final Log _log = LogFactoryUtil.getLog(GroovyObjectScriptingExecutor.class);
    @Reference
    private ScriptingExecutorRegistry _scriptingExecutorRegistry;

    public Map<String, Object> execute(Map<String, Object> inputObjects, Set<String> outputNames, String script) {
        ScriptingExecutor scriptingExecutor = this._scriptingExecutorRegistry.getScriptingExecutor("groovy");
        if (scriptingExecutor == null) {
            return Collections.emptyMap();
        }
        Map<String, Object> results = new HashMap<String, Boolean>();
        try (SafeCloseable safeCloseable = ThreadContextClassLoaderUtil.swap((ClassLoader)GroovyObjectScriptingExecutor.class.getClassLoader());){
            results = scriptingExecutor.eval(null, inputObjects, outputNames, script);
            results.put("invalidScript", false);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            results.put("invalidScript", true);
        }
        results.putIfAbsent("validationCriteriaMet", !GetterUtil.getBoolean(results.get("invalidFields")));
        return results;
    }
}

