/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.rest.internal.vulcan.openapi.contributor.util;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.rest.openapi.v1_0.ObjectEntryOpenAPIResource;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.vulcan.resource.OpenAPIResource;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class OpenAPIContributorUtil {
    public static void copySchemas(String schemaName, OpenAPI sourceOpenAPI, boolean system, OpenAPI targetOpenAPI) {
        if (system) {
            Components sourceComponents = sourceOpenAPI.getComponents();
            Map sourceSchemas = sourceComponents.getSchemas();
            for (String sourceSchemaName : sourceSchemas.keySet()) {
                OpenAPIContributorUtil._copySchema(false, sourceSchemaName, sourceOpenAPI, targetOpenAPI);
            }
        } else {
            OpenAPIContributorUtil._copySchema(true, schemaName, sourceOpenAPI, targetOpenAPI);
            OpenAPIContributorUtil._copySchema(true, OpenAPIContributorUtil.getPageSchemaName(schemaName), sourceOpenAPI, targetOpenAPI);
        }
    }

    public static OpenAPI getObjectEntryOpenAPI(ObjectDefinition objectDefinition, ObjectEntryOpenAPIResource objectEntryOpenAPIResource) throws Exception {
        Response response = objectEntryOpenAPIResource.getOpenAPI(objectDefinition, "json", null);
        return (OpenAPI)response.getEntity();
    }

    public static String getPageSchemaName(String schemaName) {
        return "Page" + schemaName;
    }

    public static OpenAPI getSystemObjectOpenAPI(BundleContext bundleContext, String externalDTOClassName, OpenAPIResource openAPIResource) throws Exception {
        Object[] serviceReferences = bundleContext.getServiceReferences((String)null, "(&(entity.class.name=" + externalDTOClassName + ")(osgi.jaxrs.resource=true))");
        if (ArrayUtil.isEmpty((Object[])serviceReferences)) {
            throw new IllegalStateException();
        }
        Object object = bundleContext.getService((ServiceReference)serviceReferences[0]);
        Response response = openAPIResource.getOpenAPI(null, SetUtil.fromArray((Object[])new Class[]{object.getClass()}), "json", null);
        return (OpenAPI)response.getEntity();
    }

    private static void _copySchema(boolean force, String schemaName, OpenAPI sourceOpenAPI, OpenAPI targetOpenAPI) {
        Components targetComponents = targetOpenAPI.getComponents();
        Map targetSchemas = targetComponents.getSchemas();
        if (!force && targetSchemas.containsKey(schemaName)) {
            return;
        }
        Components components = sourceOpenAPI.getComponents();
        Map schemas = components.getSchemas();
        targetSchemas.put(schemaName, schemas.get(schemaName));
    }
}

