/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.rest.internal.vulcan.openapi.contributor;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.rest.internal.vulcan.openapi.contributor.BaseOpenAPIContributor;
import com.liferay.object.rest.internal.vulcan.openapi.contributor.util.OpenAPIContributorUtil;
import com.liferay.object.rest.openapi.v1_0.ObjectEntryOpenAPIResource;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.object.system.JaxRsApplicationDescriptor;
import com.liferay.object.system.SystemObjectDefinitionMetadata;
import com.liferay.object.system.SystemObjectDefinitionMetadataRegistry;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.openapi.contributor.OpenAPIContributor;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={OpenAPIContributor.class})
public class RelatedObjectEntryOpenAPIContributor
extends BaseOpenAPIContributor {
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryOpenAPIResource _objectEntryOpenAPIResource;
    @Reference
    private ObjectRelationshipLocalService _objectRelationshipLocalService;
    @Reference
    private SystemObjectDefinitionMetadataRegistry _systemObjectDefinitionMetadataRegistry;

    public void contribute(OpenAPI openAPI, UriInfo uriInfo) throws Exception {
        if (!GetterUtil.getBoolean((String)PropsUtil.get((String)"feature.flag.LPS-153324")) || uriInfo == null) {
            return;
        }
        HashMap<ObjectDefinition, SystemObjectDefinitionMetadata> systemObjectDefinitionMetadataMap = new HashMap<ObjectDefinition, SystemObjectDefinitionMetadata>();
        for (ObjectDefinition objectDefinition : this._objectDefinitionLocalService.getSystemObjectDefinitions()) {
            JaxRsApplicationDescriptor jaxRsApplicationDescriptor;
            URI uri;
            String path;
            SystemObjectDefinitionMetadata systemObjectDefinitionMetadata = this._systemObjectDefinitionMetadataRegistry.getSystemObjectDefinitionMetadata(objectDefinition.getName());
            if (systemObjectDefinitionMetadata == null || !(path = (uri = uriInfo.getBaseUri()).getPath()).contains((jaxRsApplicationDescriptor = systemObjectDefinitionMetadata.getJaxRsApplicationDescriptor()).getApplicationPath())) continue;
            systemObjectDefinitionMetadataMap.put(objectDefinition, systemObjectDefinitionMetadata);
        }
        for (Map.Entry entry : systemObjectDefinitionMetadataMap.entrySet()) {
            ObjectDefinition systemObjectDefinition = (ObjectDefinition)entry.getKey();
            for (ObjectRelationship systemObjectRelationship : this._objectRelationshipLocalService.getObjectRelationships(systemObjectDefinition.getObjectDefinitionId())) {
                this._contribute(openAPI, systemObjectDefinition, (SystemObjectDefinitionMetadata)entry.getValue(), systemObjectRelationship, uriInfo);
            }
        }
    }

    @Activate
    protected void activate() {
        this.init(this._dtoConverterRegistry, this._systemObjectDefinitionMetadataRegistry);
    }

    private void _contribute(OpenAPI openAPI, ObjectDefinition systemObjectDefinition, SystemObjectDefinitionMetadata systemObjectDefinitionMetadata, final ObjectRelationship systemObjectRelationship, UriInfo uriInfo) throws Exception {
        Paths paths = openAPI.getPaths();
        ObjectDefinition relatedObjectDefinition = this._getRelatedObjectDefinition(systemObjectDefinition, systemObjectRelationship);
        final String relatedSchemaName = this.getSchemaName(relatedObjectDefinition);
        OpenAPI relatedOpenAPI = OpenAPIContributorUtil.getObjectEntryOpenAPI(relatedObjectDefinition, this._objectEntryOpenAPIResource);
        OpenAPIContributorUtil.copySchemas(relatedSchemaName, relatedOpenAPI, relatedObjectDefinition.isSystem(), openAPI);
        JaxRsApplicationDescriptor jaxRsApplicationDescriptor = systemObjectDefinitionMetadata.getJaxRsApplicationDescriptor();
        final String schemaName = this.getSchemaName(systemObjectDefinition);
        String name = StringBundler.concat((String[])new String[]{"/", this._getJaxRsVersion(uriInfo), "/", jaxRsApplicationDescriptor.getPath(), "/", this._getIdParameterTemplate(schemaName), "/", systemObjectRelationship.getName()});
        paths.addPathItem(name, new PathItem(){
            {
                this.get(RelatedObjectEntryOpenAPIContributor.this._getGetOperation(systemObjectRelationship, relatedSchemaName, schemaName));
            }
        });
        paths.addPathItem(StringBundler.concat((String[])new String[]{name, "/", this._getIdParameterTemplate(relatedObjectDefinition.getShortName())}), new PathItem(){
            {
                this.delete(RelatedObjectEntryOpenAPIContributor.this._getDeleteOperation(systemObjectRelationship, relatedSchemaName, schemaName));
                this.put(RelatedObjectEntryOpenAPIContributor.this._getPutOperation(systemObjectRelationship, relatedSchemaName, schemaName));
            }
        });
    }

    private Content _getContent(String schemaName) {
        Content content = new Content();
        MediaType mediaType = new MediaType();
        if (schemaName != null) {
            Schema schema = new Schema();
            schema.set$ref(schemaName);
            mediaType.setSchema(schema);
        }
        content.addMediaType("application/json", mediaType);
        content.addMediaType("application/xml", mediaType);
        return content;
    }

    private Operation _getDeleteOperation(final ObjectRelationship objectRelationship, final String relatedSchemaName, final String schemaName) {
        return new Operation(){
            {
                this.operationId(RelatedObjectEntryOpenAPIContributor.this._getOperationId("delete", objectRelationship.getName(), schemaName));
                this.parameters(Arrays.asList(new Parameter(){
                    {
                        this.in("path");
                        this.name(RelatedObjectEntryOpenAPIContributor.this._getIdParameterName(schemaName));
                        this.required(true);
                    }
                }, new Parameter(){
                    {
                        this.in("path");
                        this.name(RelatedObjectEntryOpenAPIContributor.this._getIdParameterName(relatedSchemaName));
                        this.required(true);
                    }
                }));
                this.responses(new ApiResponses(){
                    {
                        this.setDefault(new ApiResponse(){
                            {
                                this.setContent(RelatedObjectEntryOpenAPIContributor.this._getContent(null));
                            }
                        });
                    }
                });
                this.tags(Collections.singletonList(schemaName));
            }
        };
    }

    private Operation _getGetOperation(final ObjectRelationship objectRelationship, final String relatedSchemaName, final String schemaName) {
        final String parameterName = this._getIdParameterName(schemaName);
        return new Operation(){
            {
                this.operationId(RelatedObjectEntryOpenAPIContributor.this._getOperationId("get", objectRelationship.getName(), schemaName));
                this.parameters(Collections.singletonList(new Parameter(){
                    {
                        this.in("path");
                        this.name(parameterName);
                        this.required(true);
                    }
                }));
                this.responses(new ApiResponses(){
                    {
                        this.setDefault(new ApiResponse(){
                            {
                                this.setContent(RelatedObjectEntryOpenAPIContributor.this._getContent(OpenAPIContributorUtil.getPageSchemaName(relatedSchemaName)));
                            }
                        });
                    }
                });
                this.tags(Collections.singletonList(schemaName));
            }
        };
    }

    private String _getIdParameterName(String name) {
        return StringUtil.lowerCaseFirstLetter((String)name) + "Id";
    }

    private String _getIdParameterTemplate(String name) {
        return "{" + this._getIdParameterName(name) + "}";
    }

    private String _getJaxRsVersion(UriInfo uriInfo) {
        return StringUtil.extractFirst((String)uriInfo.getPath(), (String)"/");
    }

    private String _getOperationId(String method, String objectRelationshipName, String systemObjectDefinitionName) {
        String sufix = "";
        if (StringUtil.equals((String)method, (String)"get")) {
            sufix = "Page";
        }
        return StringBundler.concat((String[])new String[]{method, systemObjectDefinitionName, StringUtil.upperCaseFirstLetter((String)objectRelationshipName), sufix});
    }

    private Operation _getPutOperation(final ObjectRelationship objectRelationship, final String relatedSchemaName, final String schemaName) {
        return new Operation(){
            {
                this.operationId(RelatedObjectEntryOpenAPIContributor.this._getOperationId("put", objectRelationship.getName(), schemaName));
                this.parameters(Arrays.asList(new Parameter(){
                    {
                        this.in("path");
                        this.name(RelatedObjectEntryOpenAPIContributor.this._getIdParameterName(schemaName));
                        this.required(true);
                    }
                }, new Parameter(){
                    {
                        this.in("path");
                        this.name(RelatedObjectEntryOpenAPIContributor.this._getIdParameterName(relatedSchemaName));
                        this.required(true);
                    }
                }));
                this.responses(new ApiResponses(){
                    {
                        this.setDefault(new ApiResponse(){
                            {
                                this.setContent(RelatedObjectEntryOpenAPIContributor.this._getContent(relatedSchemaName));
                            }
                        });
                    }
                });
                this.tags(Collections.singletonList(schemaName));
            }
        };
    }

    private ObjectDefinition _getRelatedObjectDefinition(ObjectDefinition systemObjectDefinition, ObjectRelationship systemObjectRelationship) throws Exception {
        long objectDefinitionId1 = systemObjectRelationship.getObjectDefinitionId1();
        if (objectDefinitionId1 != systemObjectDefinition.getObjectDefinitionId()) {
            return this._objectDefinitionLocalService.getObjectDefinition(systemObjectRelationship.getObjectDefinitionId1());
        }
        return this._objectDefinitionLocalService.getObjectDefinition(systemObjectRelationship.getObjectDefinitionId2());
    }
}

