/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.rest.internal.vulcan.extension.v1_0;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.rest.dto.v1_0.ObjectEntry;
import com.liferay.object.rest.internal.vulcan.extension.v1_0.BaseObjectExtensionProvider;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManager;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManagerRegistry;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.extension.ExtensionProvider;
import com.liferay.portal.vulcan.extension.PropertyDefinition;
import com.liferay.portal.vulcan.extension.validation.PropertyValidator;
import com.liferay.portal.vulcan.fields.NestedFieldsContext;
import com.liferay.portal.vulcan.fields.NestedFieldsContextThreadLocal;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ExtensionProvider.class})
public class ObjectRelationshipExtensionProvider
extends BaseObjectExtensionProvider {
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    @Reference
    private ObjectEntryManagerRegistry _objectEntryManagerRegistry;
    @Reference
    private ObjectRelationshipLocalService _objectRelationshipLocalService;

    public Map<String, Serializable> getExtendedProperties(long companyId, String className, Object entity) throws Exception {
        NestedFieldsContext nestedFieldsContext = NestedFieldsContextThreadLocal.getNestedFieldsContext();
        if (nestedFieldsContext == null) {
            return Collections.emptyMap();
        }
        ObjectDefinition objectDefinition = this.getObjectDefinition(companyId, className);
        List<ObjectRelationship> objectRelationships = this._getObjectRelationships(nestedFieldsContext.getFieldNames(), objectDefinition);
        if (objectRelationships.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Serializable> extendedProperties = new HashMap<String, Serializable>();
        ObjectEntryManager objectEntryManager = this._objectEntryManagerRegistry.getObjectEntryManager(objectDefinition.getStorageType());
        long primaryKey = this.getPrimaryKey(entity);
        for (ObjectRelationship objectRelationship : objectRelationships) {
            Page relatedObjectEntriesPage = objectEntryManager.getObjectEntryRelatedObjectEntries((DTOConverterContext)this._getDefaultDTOConverterContext(objectDefinition, primaryKey, null), objectDefinition, Long.valueOf(primaryKey), objectRelationship.getName(), Pagination.of((int)-1, (int)-1));
            extendedProperties.put(objectRelationship.getName(), (Serializable)((Object)relatedObjectEntriesPage.getItems()));
        }
        return extendedProperties;
    }

    public Map<String, PropertyDefinition> getExtendedPropertyDefinitions(long companyId, String className) throws Exception {
        HashMap<String, PropertyDefinition> extendedPropertyDefinitions = new HashMap<String, PropertyDefinition>();
        ObjectDefinition objectDefinition = this.getObjectDefinition(companyId, className);
        for (ObjectRelationship objectRelationship : this._objectRelationshipLocalService.getObjectRelationships(objectDefinition.getObjectDefinitionId())) {
            ObjectDefinition relatedObjectDefinition;
            if (!Objects.equals(objectRelationship.getType(), "manyToMany") && !Objects.equals(objectRelationship.getType(), "oneToMany") || (relatedObjectDefinition = this._getRelatedObjectDefinition(objectDefinition, objectRelationship)).isSystem()) continue;
            extendedPropertyDefinitions.put(objectRelationship.getName(), new PropertyDefinition(Collections.singleton(ObjectEntry.class), null, StringUtil.removeFirst((String)relatedObjectDefinition.getName(), (String)"C_"), StringBundler.concat((String[])new String[]{"Information about the object relationship ", objectRelationship.getName(), " can be embedded with \"nestedFields\"."}), objectRelationship.getName(), PropertyDefinition.PropertyType.MULTIPLE_ELEMENT, (PropertyValidator)new UnsupportedOperationPropertyValidator(), false));
        }
        return extendedPropertyDefinitions;
    }

    @Override
    public boolean isApplicableExtension(long companyId, String className) {
        if (!GetterUtil.getBoolean((String)PropsUtil.get((String)"feature.flag.LPS-162964"))) {
            return false;
        }
        return super.isApplicableExtension(companyId, className);
    }

    public void setExtendedProperties(long companyId, long userId, String className, Object entity, Map<String, Serializable> extendedProperties) {
    }

    private DefaultDTOConverterContext _getDefaultDTOConverterContext(ObjectDefinition objectDefinition, Long objectEntryId, UriInfo uriInfo) {
        DefaultDTOConverterContext defaultDTOConverterContext = new DefaultDTOConverterContext(false, null, this._dtoConverterRegistry, (Object)objectEntryId, LocaleUtil.fromLanguageId((String)objectDefinition.getDefaultLanguageId(), (boolean)true, (boolean)false), uriInfo, null);
        defaultDTOConverterContext.setAttribute("addActions", (Object)Boolean.FALSE);
        return defaultDTOConverterContext;
    }

    private List<ObjectRelationship> _getObjectRelationships(List<String> fieldNames, ObjectDefinition objectDefinition) throws Exception {
        ArrayList<ObjectRelationship> objectRelationships = new ArrayList<ObjectRelationship>();
        for (String fieldName : fieldNames) {
            ObjectDefinition relatedObjectDefinition;
            ObjectRelationship objectRelationship = this._objectRelationshipLocalService.fetchObjectRelationshipByObjectDefinitionId(objectDefinition.getObjectDefinitionId(), fieldName);
            if (objectRelationship == null || !Objects.equals(objectRelationship.getType(), "manyToMany") && !Objects.equals(objectRelationship.getType(), "oneToMany") || (relatedObjectDefinition = this._getRelatedObjectDefinition(objectDefinition, objectRelationship)).isSystem()) continue;
            objectRelationships.add(objectRelationship);
        }
        return objectRelationships;
    }

    private ObjectDefinition _getRelatedObjectDefinition(ObjectDefinition objectDefinition, ObjectRelationship objectRelationship) throws Exception {
        long objectDefinitionId1 = objectRelationship.getObjectDefinitionId1();
        if (objectDefinitionId1 != objectDefinition.getObjectDefinitionId()) {
            return this._objectDefinitionLocalService.getObjectDefinition(objectRelationship.getObjectDefinitionId1());
        }
        return this._objectDefinitionLocalService.getObjectDefinition(objectRelationship.getObjectDefinitionId2());
    }

    private class UnsupportedOperationPropertyValidator
    implements PropertyValidator {
        private UnsupportedOperationPropertyValidator() {
        }

        public void validate(PropertyDefinition propertyDefinition, Object propertyValue) {
            throw new UnsupportedOperationException("The property " + propertyDefinition.getPropertyName() + " cannot be set");
        }
    }
}

