/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.rest.internal.resource.v1_0;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.rest.dto.v1_0.ObjectEntry;
import com.liferay.object.rest.internal.resource.v1_0.BaseObjectEntryRelatedObjectsResourceImpl;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManager;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManagerRegistry;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectRelationshipService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.Map;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Context;

public class ObjectEntryRelatedObjectsResourceImpl
extends BaseObjectEntryRelatedObjectsResourceImpl {
    @Context
    private ObjectDefinition _objectDefinition;
    private final ObjectDefinitionLocalService _objectDefinitionLocalService;
    private final ObjectEntryManagerRegistry _objectEntryManagerRegistry;
    private final ObjectRelationshipService _objectRelationshipService;

    public ObjectEntryRelatedObjectsResourceImpl(ObjectDefinitionLocalService objectDefinitionLocalService, ObjectEntryManagerRegistry objectEntryManagerRegistry, ObjectRelationshipService objectRelationshipService) {
        this._objectDefinitionLocalService = objectDefinitionLocalService;
        this._objectEntryManagerRegistry = objectEntryManagerRegistry;
        this._objectRelationshipService = objectRelationshipService;
    }

    @Override
    public Page<Object> getCurrentObjectEntriesObjectRelationshipNamePage(Long currentObjectEntryId, String objectRelationshipName, Pagination pagination) throws Exception {
        ObjectEntryManager objectEntryManager = this._objectEntryManagerRegistry.getObjectEntryManager(this._objectDefinition.getStorageType());
        ObjectRelationship objectRelationship = this._objectRelationshipService.getObjectRelationship(this._objectDefinition.getObjectDefinitionId(), objectRelationshipName);
        ObjectDefinition relatedObjectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectRelationship.getObjectDefinitionId2());
        if (relatedObjectDefinition.isSystem()) {
            if (!GetterUtil.getBoolean((String)PropsUtil.get((String)"feature.flag.LPS-162966"))) {
                throw new NotFoundException();
            }
            return objectEntryManager.getRelatedSystemObjectEntries(this._objectDefinition, currentObjectEntryId, objectRelationshipName, pagination);
        }
        Page page = objectEntryManager.getObjectEntryRelatedObjectEntries((DTOConverterContext)this._getDTOConverterContext(currentObjectEntryId), this._objectDefinition, currentObjectEntryId, objectRelationshipName, pagination);
        return Page.of((Map)page.getActions(), this.transform(page.getItems(), objectEntry -> this._getRelatedObjectEntry(relatedObjectDefinition, (ObjectEntry)objectEntry)));
    }

    @Override
    public Object putCurrentObjectEntry(Long currentObjectEntryId, String objectRelationshipName, Long relatedObjectEntryId) throws Exception {
        ObjectEntryManager objectEntryManager = this._objectEntryManagerRegistry.getObjectEntryManager(this._objectDefinition.getStorageType());
        ObjectRelationship objectRelationship = this._objectRelationshipService.getObjectRelationship(this._objectDefinition.getObjectDefinitionId(), objectRelationshipName);
        ObjectDefinition relatedObjectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectRelationship.getObjectDefinitionId2());
        if (relatedObjectDefinition.isSystem()) {
            if (!GetterUtil.getBoolean((String)PropsUtil.get((String)"feature.flag.LPS-162966"))) {
                throw new NotFoundException();
            }
            return objectEntryManager.addSystemObjectRelationshipMappingTableValues(relatedObjectDefinition, objectRelationship, currentObjectEntryId.longValue(), relatedObjectEntryId.longValue());
        }
        return this._getRelatedObjectEntry(relatedObjectDefinition, objectEntryManager.addObjectRelationshipMappingTableValues((DTOConverterContext)this._getDTOConverterContext(currentObjectEntryId), objectRelationship, currentObjectEntryId.longValue(), relatedObjectEntryId.longValue()));
    }

    private DefaultDTOConverterContext _getDTOConverterContext(Long objectEntryId) {
        return new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), null, null, this.contextHttpServletRequest, (Object)objectEntryId, this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser);
    }

    private ObjectEntry _getRelatedObjectEntry(ObjectDefinition objectDefinition, ObjectEntry objectEntry) {
        Map actions = objectEntry.getActions();
        for (Map.Entry entry : actions.entrySet()) {
            Map map = (Map)entry.getValue();
            String href = (String)map.get("href");
            map.put("href", StringUtil.replace((String)href, (String)StringUtil.lowerCaseFirstLetter((String)this._objectDefinition.getPluralLabel(this.contextAcceptLanguage.getPreferredLocale())), (String)StringUtil.lowerCaseFirstLetter((String)objectDefinition.getPluralLabel(this.contextAcceptLanguage.getPreferredLocale()))));
        }
        return objectEntry;
    }
}

