/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.rest.internal.odata.filter.expression;

import com.liferay.object.field.business.type.ObjectFieldBusinessType;
import com.liferay.object.field.business.type.ObjectFieldBusinessTypeRegistry;
import com.liferay.object.model.ObjectField;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.spi.expression.DefaultPredicate;
import com.liferay.petra.sql.dsl.spi.expression.Operand;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.odata.entity.EntityField;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.expression.BinaryExpression;
import com.liferay.portal.odata.filter.expression.CollectionPropertyExpression;
import com.liferay.portal.odata.filter.expression.Expression;
import com.liferay.portal.odata.filter.expression.ExpressionVisitException;
import com.liferay.portal.odata.filter.expression.ExpressionVisitor;
import com.liferay.portal.odata.filter.expression.LambdaFunctionExpression;
import com.liferay.portal.odata.filter.expression.LambdaVariableExpression;
import com.liferay.portal.odata.filter.expression.ListExpression;
import com.liferay.portal.odata.filter.expression.LiteralExpression;
import com.liferay.portal.odata.filter.expression.MemberExpression;
import com.liferay.portal.odata.filter.expression.MethodExpression;
import com.liferay.portal.odata.filter.expression.PrimitivePropertyExpression;
import com.liferay.portal.odata.filter.expression.UnaryExpression;
import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PredicateExpressionVisitorImpl
implements ExpressionVisitor<Object> {
    private static final Log _log = LogFactoryUtil.getLog(PredicateExpressionVisitorImpl.class);
    private final EntityModel _entityModel;
    private Map<String, String> _lambdaVariableExpressionFieldNames;
    private final long _objectDefinitionId;
    private final ObjectFieldBusinessTypeRegistry _objectFieldBusinessTypeRegistry;
    private final ObjectFieldLocalService _objectFieldLocalService;

    public PredicateExpressionVisitorImpl(EntityModel entityModel, long objectDefinitionId, ObjectFieldBusinessTypeRegistry objectFieldBusinessTypeRegistry, ObjectFieldLocalService objectFieldLocalService) {
        this(entityModel, new HashMap<String, String>(), objectDefinitionId, objectFieldBusinessTypeRegistry, objectFieldLocalService);
    }

    public Predicate visitBinaryExpressionOperation(BinaryExpression.Operation operation, Object left, Object right) {
        Optional<Predicate> predicateOptional = this._getPredicateOptional(operation, left, right);
        return predicateOptional.orElseThrow(() -> new UnsupportedOperationException("Unsupported method visitBinaryExpressionOperation with operation " + operation));
    }

    public Predicate visitCollectionPropertyExpression(CollectionPropertyExpression collectionPropertyExpression) throws ExpressionVisitException {
        LambdaFunctionExpression lambdaFunctionExpression = collectionPropertyExpression.getLambdaFunctionExpression();
        return (Predicate)lambdaFunctionExpression.accept((ExpressionVisitor)new PredicateExpressionVisitorImpl(this._entityModel, Collections.singletonMap(lambdaFunctionExpression.getVariableName(), collectionPropertyExpression.getName()), this._objectDefinitionId, this._objectFieldBusinessTypeRegistry, this._objectFieldLocalService));
    }

    public Object visitLambdaFunctionExpression(LambdaFunctionExpression.Type type, String variableName, Expression expression) throws ExpressionVisitException {
        return expression.accept((ExpressionVisitor)this);
    }

    public Object visitLambdaVariableExpression(LambdaVariableExpression lambdaVariableExpression) {
        return this._lambdaVariableExpressionFieldNames.get(lambdaVariableExpression.getVariableName());
    }

    public Predicate visitListExpressionOperation(ListExpression.Operation operation, Object left, List<Object> rights) throws ExpressionVisitException {
        if (Objects.equals(ListExpression.Operation.IN, operation)) {
            Column<?, Object> column = this._getColumn(left);
            return column.in(TransformUtil.transformToArray(rights, right -> this._getValue(left, right), Object.class));
        }
        throw new UnsupportedOperationException("Unsupported method visitListExpressionOperation with operation " + operation);
    }

    public Object visitLiteralExpression(LiteralExpression literalExpression) {
        if (Objects.equals(LiteralExpression.Type.BOOLEAN, literalExpression.getType())) {
            return GetterUtil.getBoolean((String)literalExpression.getText());
        }
        if (Objects.equals(LiteralExpression.Type.DATE, literalExpression.getType())) {
            return GetterUtil.getDate((String)literalExpression.getText(), (DateFormat)DateFormatFactoryUtil.getSimpleDateFormat((String)"yyyy-MM-dd"));
        }
        if (Objects.equals(LiteralExpression.Type.DOUBLE, literalExpression.getType())) {
            return GetterUtil.getDouble((String)literalExpression.getText());
        }
        if (Objects.equals(LiteralExpression.Type.INTEGER, literalExpression.getType())) {
            return GetterUtil.getLong((String)literalExpression.getText());
        }
        if (Objects.equals(LiteralExpression.Type.NULL, literalExpression.getType())) {
            return null;
        }
        if (Objects.equals(LiteralExpression.Type.STRING, literalExpression.getType())) {
            return StringUtil.unquote((String)literalExpression.getText());
        }
        return literalExpression.getText();
    }

    public Object visitMemberExpression(MemberExpression memberExpression) throws ExpressionVisitException {
        Expression expression = memberExpression.getExpression();
        return expression.accept((ExpressionVisitor)this);
    }

    public Object visitMethodExpression(List<Object> expressions, MethodExpression.Type type) {
        if (type == MethodExpression.Type.CONTAINS) {
            if (expressions.size() != 2) {
                throw new UnsupportedOperationException(StringBundler.concat((Object[])new Object[]{"Unsupported method visitMethodExpression with method ", "type ", type, " and ", expressions.size(), "params"}));
            }
            return this._contains(expressions.get(0), expressions.get(1));
        }
        if (type == MethodExpression.Type.STARTS_WITH) {
            if (expressions.size() != 2) {
                throw new UnsupportedOperationException(StringBundler.concat((Object[])new Object[]{"Unsupported method visitMethodExpression with method", "type ", type, " and ", expressions.size(), "params"}));
            }
            return this._startsWith(expressions.get(0), expressions.get(1));
        }
        throw new UnsupportedOperationException("Unsupported method visitMethodExpression with method type " + type);
    }

    public Object visitPrimitivePropertyExpression(PrimitivePropertyExpression primitivePropertyExpression) {
        return primitivePropertyExpression.getName();
    }

    public Predicate visitUnaryExpressionOperation(UnaryExpression.Operation operation, Object operand) {
        if (!Objects.equals(UnaryExpression.Operation.NOT, operation)) {
            throw new UnsupportedOperationException("Unsupported method visitUnaryExpressionOperation with operation " + operation);
        }
        DefaultPredicate defaultPredicate = (DefaultPredicate)operand;
        if (Objects.equals(Operand.IN, defaultPredicate.getOperand())) {
            return new DefaultPredicate(defaultPredicate.getLeftExpression(), Operand.NOT_IN, defaultPredicate.getRightExpression());
        }
        return Predicate.not((Predicate)defaultPredicate);
    }

    private PredicateExpressionVisitorImpl(EntityModel entityModel, Map<String, String> lambdaVariableExpressionFieldNames, long objectDefinitionId, ObjectFieldBusinessTypeRegistry objectFieldBusinessTypeRegistry, ObjectFieldLocalService objectFieldLocalService) {
        this._entityModel = entityModel;
        this._lambdaVariableExpressionFieldNames = lambdaVariableExpressionFieldNames;
        this._objectDefinitionId = objectDefinitionId;
        this._objectFieldBusinessTypeRegistry = objectFieldBusinessTypeRegistry;
        this._objectFieldLocalService = objectFieldLocalService;
    }

    private Predicate _contains(Object fieldName, Object fieldValue) {
        Column<?, Object> column = this._getColumn(fieldName);
        return column.like("%" + this._getValue(fieldName, fieldValue) + "%");
    }

    private Column<?, Object> _getColumn(Object fieldName) {
        EntityField entityField = this._getEntityField(fieldName);
        return this._objectFieldLocalService.getColumn(this._objectDefinitionId, entityField.getFilterableName(null));
    }

    private EntityField _getEntityField(Object fieldName) {
        Map entityFieldsMap = this._entityModel.getEntityFieldsMap();
        return (EntityField)entityFieldsMap.get(GetterUtil.getString((Object)fieldName));
    }

    private Optional<Predicate> _getPredicateOptional(BinaryExpression.Operation operation, Object left, Object right) {
        Predicate predicate = null;
        if (Objects.equals(BinaryExpression.Operation.AND, operation)) {
            predicate = Predicate.and((Predicate)((Predicate)left), (Predicate)((Predicate)right));
        } else if (Objects.equals(BinaryExpression.Operation.OR, operation)) {
            predicate = Predicate.or((Predicate)((Predicate)left), (Predicate)((Predicate)right));
        } else {
            ObjectField objectField = this._objectFieldLocalService.fetchObjectField(this._objectDefinitionId, String.valueOf(left));
            if (objectField != null && StringUtil.equals((String)objectField.getBusinessType(), (String)"MultiselectPicklist")) {
                predicate = this._contains(left, right);
            }
        }
        if (predicate != null) {
            return Optional.of(predicate);
        }
        Column<?, Object> column = this._getColumn(left);
        Object value = this._getValue(left, right);
        if (Objects.equals(BinaryExpression.Operation.EQ, operation)) {
            predicate = column.eq(value);
        } else if (Objects.equals(BinaryExpression.Operation.GE, operation)) {
            predicate = column.gte(value);
        } else if (Objects.equals(BinaryExpression.Operation.GT, operation)) {
            predicate = column.gt(value);
        } else if (Objects.equals(BinaryExpression.Operation.LE, operation)) {
            predicate = column.lte(value);
        } else if (Objects.equals(BinaryExpression.Operation.LT, operation)) {
            predicate = column.lt(value);
        } else if (Objects.equals(BinaryExpression.Operation.NE, operation)) {
            predicate = column.neq(value);
        } else {
            return Optional.empty();
        }
        return Optional.of(predicate);
    }

    private Object _getValue(Object left, Object right) {
        String entityFieldName;
        String entityFieldFilterableName;
        EntityField entityField = this._getEntityField(left);
        EntityField.Type entityType = entityField.getType();
        DB db = DBManagerUtil.getDB();
        if (entityType.equals((Object)EntityField.Type.DATE_TIME) && db.getDBType() == DBType.HYPERSONIC) {
            try {
                Format format = FastDateFormatFactoryUtil.getSimpleDateFormat((String)"dd-MMM-yyyy HH:mm:ss.SSS");
                DateFormat dateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)"yyyy-MM-dd'T'HH:mm:ss");
                Date date = dateFormat.parse(right.toString());
                right = format.format(date);
            }
            catch (ParseException parseException) {
                throw new RuntimeException(parseException);
            }
        }
        if (Objects.equals(entityFieldFilterableName = entityField.getFilterableName(null), entityFieldName = entityField.getName())) {
            return right;
        }
        try {
            ObjectField objectField = this._objectFieldLocalService.getObjectField(this._objectDefinitionId, entityFieldFilterableName);
            ObjectFieldBusinessType objectFieldBusinessType = this._objectFieldBusinessTypeRegistry.getObjectFieldBusinessType(objectField.getBusinessType());
            Object value = objectFieldBusinessType.getValue(objectField, Collections.singletonMap(entityFieldName, right));
            if (value == null) {
                return right;
            }
            return value;
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            return right;
        }
    }

    private Predicate _startsWith(Object fieldName, Object fieldValue) {
        Column<?, Object> column = this._getColumn(fieldName);
        return column.like(this._getValue(fieldName, fieldValue) + "%");
    }
}

