/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.rest.internal.dto.v1_0.converter;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.util.DLURLHelper;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFactory;
import com.liferay.list.type.model.ListTypeEntry;
import com.liferay.list.type.service.ListTypeEntryLocalService;
import com.liferay.object.entry.util.ObjectEntryValuesUtil;
import com.liferay.object.field.setting.util.ObjectFieldSettingUtil;
import com.liferay.object.field.util.ObjectFieldFormulaEvaluatorUtil;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.rest.dto.v1_0.FileEntry;
import com.liferay.object.rest.dto.v1_0.Link;
import com.liferay.object.rest.dto.v1_0.ListEntry;
import com.liferay.object.rest.dto.v1_0.Status;
import com.liferay.object.rest.dto.v1_0.util.CreatorUtil;
import com.liferay.object.scope.ObjectScopeProvider;
import com.liferay.object.scope.ObjectScopeProviderRegistry;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectFieldSettingLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.workflow.WorkflowConstants;
import com.liferay.portal.language.LanguageResources;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.object.model.ObjectEntry"}, service={DTOConverter.class, ObjectEntryDTOConverter.class})
public class ObjectEntryDTOConverter
implements DTOConverter<ObjectEntry, com.liferay.object.rest.dto.v1_0.ObjectEntry> {
    private static final Log _log = LogFactoryUtil.getLog(ObjectEntryDTOConverter.class);
    @Reference
    private DDMExpressionFactory _ddmExpressionFactory;
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private DLFileEntryLocalService _dLFileEntryLocalService;
    @Reference
    private DLURLHelper _dlURLHelper;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Language _language;
    @Reference
    private ListTypeEntryLocalService _listTypeEntryLocalService;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private ObjectFieldSettingLocalService _objectFieldSettingLocalService;
    @Reference
    private ObjectRelationshipLocalService _objectRelationshipLocalService;
    @Reference
    private ObjectScopeProviderRegistry _objectScopeProviderRegistry;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    public String getContentType() {
        return com.liferay.object.rest.dto.v1_0.ObjectEntry.class.getSimpleName();
    }

    public com.liferay.object.rest.dto.v1_0.ObjectEntry toDTO(DTOConverterContext dtoConverterContext, ObjectEntry objectEntry) throws Exception {
        Optional uriInfoOptional = dtoConverterContext.getUriInfoOptional();
        UriInfo uriInfo = uriInfoOptional.orElse(null);
        if (uriInfo == null) {
            return this._toDTO(dtoConverterContext, Math.min(1, PropsValues.OBJECT_NESTED_FIELDS_MAX_QUERY_DEPTH), objectEntry);
        }
        MultivaluedMap queryParameters = uriInfo.getQueryParameters();
        return this._toDTO(dtoConverterContext, Math.min(GetterUtil.getInteger((String)((String)queryParameters.getFirst((Object)"nestedFieldsDepth")), (int)1), PropsValues.OBJECT_NESTED_FIELDS_MAX_QUERY_DEPTH), objectEntry);
    }

    private void _addNestedFields(Map<String, Object> map, String nestedFields, String objectFieldName, ObjectRelationship objectRelationship, Object value) {
        String objectFieldNameNestedField = StringUtil.replaceLast((String)objectFieldName.substring(objectFieldName.lastIndexOf("_") + 1), (String)"Id", (String)"");
        for (String nestedField : nestedFields.split(",")) {
            if (nestedField.contains(objectFieldNameNestedField)) {
                map.put(StringUtil.replaceLast((String)objectFieldName, (String)"Id", (String)""), value);
            }
            if (!GetterUtil.getBoolean((String)PropsUtil.get((String)"feature.flag.LPS-161364")) || !nestedField.equals(objectRelationship.getName())) continue;
            map.put(nestedField, value);
        }
    }

    private DTOConverterContext _getDTOConverterContext(DTOConverterContext dtoConverterContext, long objectEntryId) {
        Optional uriInfoOptional = dtoConverterContext.getUriInfoOptional();
        UriInfo uriInfo = uriInfoOptional.orElse(null);
        return new DefaultDTOConverterContext(dtoConverterContext.isAcceptAllLanguages(), null, dtoConverterContext.getDTOConverterRegistry(), dtoConverterContext.getHttpServletRequest(), (Object)objectEntryId, dtoConverterContext.getLocale(), uriInfo, dtoConverterContext.getUser());
    }

    private ListEntry _getListEntry(final DTOConverterContext dtoConverterContext, String key, long listTypeDefinitionId) {
        final ListTypeEntry listTypeEntry = this._listTypeEntryLocalService.fetchListTypeEntry(listTypeDefinitionId, key);
        if (listTypeEntry == null) {
            return null;
        }
        return new ListEntry(){
            {
                this.key = listTypeEntry.getKey();
                this.name = listTypeEntry.getName(dtoConverterContext.getLocale());
                this.name_i18n = LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)listTypeEntry.getNameMap());
            }
        };
    }

    private com.liferay.object.rest.dto.v1_0.ObjectEntry[] _getManyToManyRelationshipObjectEntries(DTOConverterContext dtoConverterContext, int nestedFieldsDepth, ObjectEntry objectEntry, ObjectRelationship objectRelationship) {
        try {
            return this._toObjectEntries(dtoConverterContext, nestedFieldsDepth, this._objectEntryLocalService.getManyToManyObjectEntries(objectEntry.getGroupId(), objectRelationship.getObjectRelationshipId(), objectEntry.getObjectEntryId(), true, objectRelationship.isReverse(), -1, -1));
        }
        catch (PortalException portalException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)portalException);
            }
            return null;
        }
    }

    private ObjectDefinition _getObjectDefinition(DTOConverterContext dtoConverterContext, ObjectEntry objectEntry) throws Exception {
        ObjectDefinition objectDefinition = (ObjectDefinition)dtoConverterContext.getAttribute("objectDefinition");
        if (objectDefinition == null) {
            objectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectEntry.getObjectDefinitionId());
        }
        return objectDefinition;
    }

    private com.liferay.object.rest.dto.v1_0.ObjectEntry[] _getOneToManyRelationshipObjectEntries(DTOConverterContext dtoConverterContext, int nestedFieldsDepth, ObjectEntry objectEntry, ObjectRelationship objectRelationship) {
        try {
            return this._toObjectEntries(dtoConverterContext, nestedFieldsDepth, this._objectEntryLocalService.getOneToManyObjectEntries(objectEntry.getGroupId(), objectRelationship.getObjectRelationshipId(), objectEntry.getObjectEntryId(), true, -1, -1));
        }
        catch (PortalException portalException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)portalException);
            }
            return null;
        }
    }

    private String _getScopeKey(ObjectDefinition objectDefinition, ObjectEntry objectEntry) {
        ObjectScopeProvider objectScopeProvider = this._objectScopeProviderRegistry.getObjectScopeProvider(objectDefinition.getScope());
        if (objectScopeProvider.isGroupAware()) {
            Group group = this._groupLocalService.fetchGroup(objectEntry.getGroupId());
            if (group == null) {
                return null;
            }
            return group.getGroupKey();
        }
        return null;
    }

    private com.liferay.object.rest.dto.v1_0.ObjectEntry _toDTO(final DTOConverterContext dtoConverterContext, final int nestedFieldsDepth, final ObjectEntry objectEntry) throws Exception {
        final ObjectDefinition objectDefinition = this._getObjectDefinition(dtoConverterContext, objectEntry);
        return new com.liferay.object.rest.dto.v1_0.ObjectEntry(){
            {
                this.actions = dtoConverterContext.getActions();
                this.creator = CreatorUtil.toCreator((Portal)ObjectEntryDTOConverter.this._portal, (Optional)dtoConverterContext.getUriInfoOptional(), (User)ObjectEntryDTOConverter.this._userLocalService.fetchUser(objectEntry.getUserId()));
                this.dateCreated = objectEntry.getCreateDate();
                this.dateModified = objectEntry.getModifiedDate();
                this.externalReferenceCode = objectEntry.getExternalReferenceCode();
                this.id = objectEntry.getObjectEntryId();
                this.properties = ObjectEntryDTOConverter.this._toProperties(dtoConverterContext, nestedFieldsDepth, objectDefinition, objectEntry);
                this.scopeKey = ObjectEntryDTOConverter.this._getScopeKey(objectDefinition, objectEntry);
                this.status = new Status(){
                    {
                        this.code = objectEntry.getStatus();
                        this.label = WorkflowConstants.getStatusLabel((int)objectEntry.getStatus());
                        this.label_i18n = ObjectEntryDTOConverter.this._language.get(LanguageResources.getResourceBundle((Locale)dtoConverterContext.getLocale()), WorkflowConstants.getStatusLabel((int)objectEntry.getStatus()));
                    }
                };
            }
        };
    }

    private com.liferay.object.rest.dto.v1_0.ObjectEntry[] _toObjectEntries(DTOConverterContext dtoConverterContext, int nestedFieldsDepth, List<ObjectEntry> objectEntries) {
        return (com.liferay.object.rest.dto.v1_0.ObjectEntry[])TransformUtil.transformToArray(objectEntries, objectEntry -> {
            try {
                return this._toDTO(this._getDTOConverterContext(dtoConverterContext, objectEntry.getObjectEntryId()), nestedFieldsDepth - 1, (ObjectEntry)objectEntry);
            }
            catch (Exception exception) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Throwable)exception);
                }
                return null;
            }
        }, com.liferay.object.rest.dto.v1_0.ObjectEntry.class);
    }

    private Map<String, Object> _toProperties(DTOConverterContext dtoConverterContext, int nestedFieldsDepth, ObjectDefinition objectDefinition, ObjectEntry objectEntry) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map values = objectEntry.getValues();
        List objectFields = this._objectFieldLocalService.getObjectFields(objectDefinition.getObjectDefinitionId(), false);
        for (ObjectField objectField : objectFields) {
            long listTypeDefinitionId = objectField.getListTypeDefinitionId();
            String objectFieldName = objectField.getName();
            Serializable serializable = (Serializable)values.get(objectFieldName);
            if (listTypeDefinitionId != 0L) {
                if (StringUtil.equals((String)objectField.getBusinessType(), (String)"MultiselectPicklist")) {
                    ArrayList<ListEntry> listEntries = new ArrayList<ListEntry>();
                    for (String key : StringUtil.split((String)((String)((Object)serializable)), (String)", ")) {
                        listEntries.add(this._getListEntry(dtoConverterContext, key, listTypeDefinitionId));
                    }
                    map.put(objectFieldName, listEntries);
                    continue;
                }
                ListEntry listEntry = this._getListEntry(dtoConverterContext, (String)((Object)serializable), listTypeDefinitionId);
                if (listEntry == null) continue;
                map.put(objectFieldName, listEntry);
                continue;
            }
            if (Objects.equals(objectField.getBusinessType(), "Attachment")) {
                Link fileEntryLink;
                DLFileEntry dlFileEntry;
                block21: {
                    long fileEntryId = GetterUtil.getLong(values.get(objectField.getName()));
                    if (fileEntryId == 0L) continue;
                    dlFileEntry = this._dLFileEntryLocalService.getFileEntry(fileEntryId);
                    fileEntryLink = new Link(){
                        {
                            this.href = StringBundler.concat((String[])new String[]{ObjectEntryDTOConverter.this._portal.getPathContext(), ObjectEntryDTOConverter.this._portal.getPathMain(), "/portal/login"});
                            this.label = dlFileEntry.getFileName();
                        }
                    };
                    try {
                        com.liferay.portal.kernel.repository.model.FileEntry fileEntry = this._dlAppService.getFileEntry(fileEntryId);
                        fileEntryLink.setHref(this._dlURLHelper.getDownloadURL(fileEntry, fileEntry.getFileVersion(), null, ""));
                    }
                    catch (PrincipalException principalException) {
                        if (!_log.isWarnEnabled()) break block21;
                        _log.warn((Throwable)principalException);
                    }
                }
                map.put(objectFieldName, new FileEntry(){
                    {
                        this.id = dlFileEntry.getFileEntryId();
                        this.link = fileEntryLink;
                        this.name = dlFileEntry.getFileName();
                    }
                });
                continue;
            }
            if (Objects.equals(objectField.getBusinessType(), "RichText")) {
                map.put(objectFieldName, serializable);
                map.put(objectFieldName + "RawText", ObjectEntryValuesUtil.getValueString((ObjectField)objectField, (Map)values));
                continue;
            }
            if (nestedFieldsDepth > 0 && Objects.equals(objectField.getRelationshipType(), "oneToMany")) {
                long objectEntryId = 0L;
                ObjectRelationship objectRelationship = this._objectRelationshipLocalService.fetchObjectRelationshipByObjectFieldId2(objectField.getObjectFieldId());
                if (serializable != null) {
                    if (GetterUtil.getLong((Object)serializable) > 0L) {
                        objectEntryId = (Long)serializable;
                    }
                    Optional uriInfoOptional = dtoConverterContext.getUriInfoOptional();
                    Optional<String> nestedFieldsOptional = uriInfoOptional.map(UriInfo::getQueryParameters).map(queryParameters -> (String)queryParameters.getFirst((Object)"nestedFields"));
                    if (objectEntryId != 0L && nestedFieldsOptional.isPresent()) {
                        ObjectDefinition relatedObjectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectRelationship.getObjectDefinitionId1());
                        if (relatedObjectDefinition.isSystem()) {
                            HashMap variables = new HashMap();
                            Map systemModelAttributes = this._objectEntryLocalService.getSystemModelAttributes(relatedObjectDefinition, objectEntryId);
                            for (Map.Entry entry : systemModelAttributes.entrySet()) {
                                variables.put(entry.getKey(), (Serializable)entry.getValue());
                            }
                            this._addNestedFields(map, nestedFieldsOptional.get(), objectFieldName, objectRelationship, ObjectFieldFormulaEvaluatorUtil.evaluate((DDMExpressionFactory)this._ddmExpressionFactory, (List)this._objectFieldLocalService.getObjectFields(relatedObjectDefinition.getObjectDefinitionId()), (ObjectFieldSettingLocalService)this._objectFieldSettingLocalService, (UserLocalService)this._userLocalService, variables));
                        } else {
                            this._addNestedFields(map, nestedFieldsOptional.get(), objectFieldName, objectRelationship, this._toDTO(this._getDTOConverterContext(dtoConverterContext, objectEntryId), nestedFieldsDepth - 1, this._objectEntryLocalService.getObjectEntry(objectEntryId)));
                        }
                    }
                }
                map.put(objectFieldName, objectEntryId);
                if (GetterUtil.getBoolean((String)PropsUtil.get((String)"feature.flag.LPS-161364")) && map.get(objectRelationship.getName()) == null) {
                    map.put(objectRelationship.getName() + "Id", objectEntryId);
                }
                String objectRelationshipERCFieldName = ObjectFieldSettingUtil.getValue((String)"objectRelationshipERCFieldName", (ObjectField)objectField);
                map.put(objectRelationshipERCFieldName, GetterUtil.getString(values.get(objectRelationshipERCFieldName)));
                continue;
            }
            map.put(objectFieldName, serializable);
        }
        if (nestedFieldsDepth > 0) {
            List objectRelationships = this._objectRelationshipLocalService.getObjectRelationships(objectDefinition.getObjectDefinitionId());
            Optional uriInfoOptional = dtoConverterContext.getUriInfoOptional();
            for (ObjectRelationship objectRelationship : objectRelationships) {
                if (!uriInfoOptional.map(UriInfo::getQueryParameters).map(queryParameters -> (String)queryParameters.getFirst((Object)"nestedFields")).map(nestedFields -> {
                    List<String> strings = Arrays.asList(nestedFields.split(","));
                    return strings.contains(objectRelationship.getName());
                }).orElse(false).booleanValue()) continue;
                com.liferay.object.rest.dto.v1_0.ObjectEntry[] objectEntries = new com.liferay.object.rest.dto.v1_0.ObjectEntry[]{};
                if (Objects.equals(objectRelationship.getType(), "manyToMany")) {
                    objectEntries = this._getManyToManyRelationshipObjectEntries(dtoConverterContext, nestedFieldsDepth, objectEntry, objectRelationship);
                } else if (Objects.equals(objectRelationship.getType(), "oneToMany")) {
                    objectEntries = this._getOneToManyRelationshipObjectEntries(dtoConverterContext, nestedFieldsDepth, objectEntry, objectRelationship);
                }
                map.put(objectRelationship.getName(), objectEntries);
            }
        }
        values.remove(objectDefinition.getPKObjectFieldName());
        return map;
    }
}

