/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.rest.internal.deployer;

import com.liferay.object.action.engine.ObjectActionEngine;
import com.liferay.object.deployer.ObjectDefinitionDeployer;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.rest.dto.v1_0.ObjectEntry;
import com.liferay.object.rest.internal.graphql.dto.v1_0.ObjectDefinitionGraphQLDTOContributor;
import com.liferay.object.rest.internal.jaxrs.application.ObjectEntryApplication;
import com.liferay.object.rest.internal.jaxrs.context.provider.ObjectDefinitionContextProvider;
import com.liferay.object.rest.internal.jaxrs.exception.mapper.ObjectEntryManagerHttpExceptionMapper;
import com.liferay.object.rest.internal.jaxrs.exception.mapper.ObjectEntryValuesExceptionMapper;
import com.liferay.object.rest.internal.jaxrs.exception.mapper.ObjectValidationRuleEngineExceptionMapper;
import com.liferay.object.rest.internal.jaxrs.exception.mapper.RequiredObjectRelationshipExceptionMapper;
import com.liferay.object.rest.internal.resource.v1_0.BaseObjectEntryResourceImpl;
import com.liferay.object.rest.internal.resource.v1_0.ObjectEntryRelatedObjectsResourceImpl;
import com.liferay.object.rest.internal.resource.v1_0.ObjectEntryResourceFactoryImpl;
import com.liferay.object.rest.internal.resource.v1_0.ObjectEntryResourceImpl;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManagerRegistry;
import com.liferay.object.rest.openapi.v1_0.ObjectEntryOpenAPIResource;
import com.liferay.object.rest.petra.sql.dsl.expression.FilterPredicateFactory;
import com.liferay.object.rest.resource.v1_0.ObjectEntryResource;
import com.liferay.object.scope.ObjectScopeProvider;
import com.liferay.object.scope.ObjectScopeProviderRegistry;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.object.service.ObjectRelationshipService;
import com.liferay.object.system.JaxRsApplicationDescriptor;
import com.liferay.object.system.SystemObjectDefinitionMetadata;
import com.liferay.object.system.SystemObjectDefinitionMetadataRegistry;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.odata.sort.SortParserProvider;
import com.liferay.portal.vulcan.graphql.dto.GraphQLDTOContributor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.ExceptionMapper;
import org.apache.cxf.jaxrs.ext.ContextProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.PrototypeServiceFactory;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentFactory;
import org.osgi.service.component.ComponentInstance;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ObjectDefinitionDeployer.class})
public class ObjectDefinitionDeployerImpl
implements ObjectDefinitionDeployer {
    private static final Log _log = LogFactoryUtil.getLog(ObjectDefinitionDeployerImpl.class);
    private final Map<String, Dictionary<String, Object>> _applicationProperties = new HashMap<String, Dictionary<String, Object>>();
    private final Map<String, ServiceRegistration<Application>> _applicationServiceRegistrations = new HashMap<String, ServiceRegistration<Application>>();
    private BundleContext _bundleContext;
    @Reference
    private CompanyLocalService _companyLocalService;
    private final Map<String, List<ComponentInstance>> _componentInstancesMap = new HashMap<String, List<ComponentInstance>>();
    @Reference
    private ConfigurationAdmin _configurationAdmin;
    @Reference
    private PermissionCheckerFactory _defaultPermissionCheckerFactory;
    @Reference(target="(result.class.name=com.liferay.portal.kernel.search.filter.Filter)")
    private ExpressionConvert<Filter> _expressionConvert;
    @Reference
    private FilterParserProvider _filterParserProvider;
    @Reference
    private FilterPredicateFactory _filterPredicateFactory;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private ObjectActionEngine _objectActionEngine;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    private final Map<String, Map<Long, ObjectDefinition>> _objectDefinitionsMap = new HashMap<String, Map<Long, ObjectDefinition>>();
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    @Reference
    private ObjectEntryManagerRegistry _objectEntryManagerRegistry;
    @Reference
    private ObjectEntryOpenAPIResource _objectEntryOpenAPIResource;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private ObjectRelationshipLocalService _objectRelationshipLocalService;
    @Reference
    private ObjectRelationshipService _objectRelationshipService;
    @Reference
    private ObjectScopeProviderRegistry _objectScopeProviderRegistry;
    @Reference
    private Portal _portal;
    @Reference(target="(component.factory=com.liferay.object.rest.internal.resource.v1_0.RelatedObjectEntryResourceImpl)")
    private ComponentFactory _relatedObjectEntryResourceImplComponentFactory;
    @Reference
    private ResourceActionLocalService _resourceActionLocalService;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    private final Map<String, List<String>> _restContextPathCompanyIds = new HashMap<String, List<String>>();
    @Reference
    private RoleLocalService _roleLocalService;
    private final Map<String, List<ServiceRegistration<?>>> _serviceRegistrationsMap = new HashMap();
    @Reference
    private SortParserProvider _sortParserProvider;
    @Reference
    private SystemObjectDefinitionMetadataRegistry _systemObjectDefinitionMetadataRegistry;
    @Reference
    private UserLocalService _userLocalService;

    public synchronized List<ServiceRegistration<?>> deploy(ObjectDefinition objectDefinition) {
        if (objectDefinition.isSystem()) {
            this._initSystemObjectDefinition(this._systemObjectDefinitionMetadataRegistry.getSystemObjectDefinitionMetadata(objectDefinition.getName()));
            return Collections.emptyList();
        }
        ObjectScopeProvider objectScopeProvider = this._objectScopeProviderRegistry.getObjectScopeProvider(objectDefinition.getScope());
        Map<Long, ObjectDefinition> objectDefinitions = this._objectDefinitionsMap.get(objectDefinition.getRESTContextPath());
        if (objectDefinitions == null) {
            objectDefinitions = new HashMap<Long, ObjectDefinition>();
            this._objectDefinitionsMap.put(objectDefinition.getRESTContextPath(), objectDefinitions);
            this._excludeScopedMethods(objectDefinition, objectScopeProvider);
        }
        this._initCustomObjectDefinition(objectDefinition);
        objectDefinitions.put(objectDefinition.getCompanyId(), objectDefinition);
        return Collections.singletonList(this._bundleContext.registerService(GraphQLDTOContributor.class, (Object)ObjectDefinitionGraphQLDTOContributor.of(this._filterPredicateFactory, objectDefinition, this._objectEntryManagerRegistry.getObjectEntryManager(objectDefinition.getStorageType()), this._objectFieldLocalService, this._objectRelationshipLocalService, objectScopeProvider), (Dictionary)HashMapDictionaryBuilder.put((Object)"dto.name", (Object)objectDefinition.getDBTableName()).build()));
    }

    public ObjectDefinition getObjectDefinition(long companyId, String restContextPath) {
        Map<Long, ObjectDefinition> objectDefinitions = this._objectDefinitionsMap.get(restContextPath);
        if (objectDefinitions != null) {
            return objectDefinitions.get(companyId);
        }
        return null;
    }

    public synchronized void undeploy(ObjectDefinition objectDefinition) {
        List<ServiceRegistration<?>> serviceRegistrations;
        ServiceRegistration<Application> serviceRegistration1;
        List<ComponentInstance> componentInstances;
        List<String> companyIds;
        String restContextPath = objectDefinition.getRESTContextPath();
        Map<Long, ObjectDefinition> objectDefinitions = this._objectDefinitionsMap.get(restContextPath);
        if (objectDefinitions != null) {
            objectDefinitions.remove(objectDefinition.getCompanyId());
            if (objectDefinitions.isEmpty()) {
                this._objectDefinitionsMap.remove(restContextPath);
            }
        }
        if ((companyIds = this._restContextPathCompanyIds.get(restContextPath)) != null) {
            companyIds.remove(String.valueOf(objectDefinition.getCompanyId()));
            if (!companyIds.isEmpty()) {
                ServiceRegistration<Application> serviceRegistration = this._applicationServiceRegistrations.get(restContextPath);
                serviceRegistration.setProperties(this._applicationProperties.get(restContextPath));
                return;
            }
        }
        if ((componentInstances = this._componentInstancesMap.remove(restContextPath)) != null) {
            for (ComponentInstance componentInstance : componentInstances) {
                componentInstance.dispose();
            }
        }
        if ((serviceRegistration1 = this._applicationServiceRegistrations.remove(restContextPath)) != null) {
            serviceRegistration1.unregister();
        }
        if ((serviceRegistrations = this._serviceRegistrationsMap.remove(restContextPath)) != null) {
            for (ServiceRegistration<?> serviceRegistration2 : serviceRegistrations) {
                serviceRegistration2.unregister();
            }
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    private ObjectEntryResourceImpl _createObjectEntryResourceImpl() {
        return new ObjectEntryResourceImpl(this._filterPredicateFactory, this._jsonFactory, this._objectActionEngine, this._objectDefinitionLocalService, this._objectEntryLocalService, this._objectEntryManagerRegistry, this._objectFieldLocalService, this._objectRelationshipService, this._objectScopeProviderRegistry, this._systemObjectDefinitionMetadataRegistry);
    }

    private void _excludeScopedMethods(ObjectDefinition objectDefinition, ObjectScopeProvider objectScopeProvider) {
        block3: {
            try {
                String factoryPid = "com.liferay.portal.vulcan.internal.configuration.VulcanConfiguration";
                Configuration configuration = this._configurationAdmin.createFactoryConfiguration(factoryPid, "?");
                Method[] methods = BaseObjectEntryResourceImpl.class.getMethods();
                ArrayList<String> excludedOperationIds = new ArrayList<String>();
                for (Method method : methods) {
                    Path path = method.getAnnotation(Path.class);
                    if (path == null) continue;
                    String value = path.value();
                    boolean groupAware = objectScopeProvider.isGroupAware();
                    boolean hasScope = value.contains("scopes");
                    if ((groupAware || !hasScope) && (!groupAware || hasScope || value.startsWith("/{objectEntryId}"))) continue;
                    excludedOperationIds.add(method.getName());
                }
                configuration.update((Dictionary)HashMapDictionaryBuilder.put((Object)"excludedOperationIds", (Object)StringUtil.merge(excludedOperationIds, (String)",")).put((Object)"path", (Object)objectDefinition.getRESTContextPath()).build());
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Throwable)exception);
            }
        }
    }

    private void _initCustomObjectDefinition(ObjectDefinition objectDefinition) {
        String restContextPath = objectDefinition.getRESTContextPath();
        List companyIds = this._restContextPathCompanyIds.computeIfAbsent(restContextPath, key -> new ArrayList());
        companyIds.add(String.valueOf(objectDefinition.getCompanyId()));
        String osgiJaxRsName = objectDefinition.getOSGiJaxRsName();
        HashMapDictionary properties = HashMapDictionaryBuilder.put((Object)"companyId", (Object)companyIds).put((Object)"liferay.jackson", (Object)false).put((Object)"osgi.jaxrs.application.base", (Object)objectDefinition.getRESTContextPath()).put((Object)"osgi.jaxrs.extension.select", (Object)"(osgi.jaxrs.name=Liferay.Vulcan)").put((Object)"osgi.jaxrs.name", (Object)osgiJaxRsName).build();
        this._applicationProperties.put(restContextPath, (Dictionary<String, Object>)properties);
        ServiceRegistration<Application> applicationServiceRegistration = this._applicationServiceRegistrations.get(restContextPath);
        if (applicationServiceRegistration == null) {
            this._applicationServiceRegistrations.put(restContextPath, (ServiceRegistration<Application>)this._bundleContext.registerService(Application.class, (Object)new ObjectEntryApplication(this._objectEntryOpenAPIResource), (Dictionary)properties));
        } else {
            applicationServiceRegistration.setProperties((Dictionary)properties);
        }
        this._serviceRegistrationsMap.computeIfAbsent(restContextPath, key -> Arrays.asList(this._bundleContext.registerService(ContextProvider.class, (Object)new ObjectDefinitionContextProvider(this, this._portal), (Dictionary)HashMapDictionaryBuilder.put((Object)"enabled", (Object)"false").put((Object)"osgi.jaxrs.application.select", (Object)("(osgi.jaxrs.name=" + osgiJaxRsName + ")")).put((Object)"osgi.jaxrs.extension", (Object)"true").put((Object)"osgi.jaxrs.name", (Object)objectDefinition.getOSGiJaxRsName("ObjectDefinitionContextProvider")).build()), this._bundleContext.registerService(ExceptionMapper.class, (Object)new ObjectEntryManagerHttpExceptionMapper(), (Dictionary)HashMapDictionaryBuilder.put((Object)"osgi.jaxrs.application.select", (Object)("(osgi.jaxrs.name=" + osgiJaxRsName + ")")).put((Object)"osgi.jaxrs.extension", (Object)"true").put((Object)"osgi.jaxrs.name", (Object)objectDefinition.getOSGiJaxRsName("ObjectEntryManagerHttpExceptionMapper")).build()), this._bundleContext.registerService(ExceptionMapper.class, (Object)new ObjectEntryValuesExceptionMapper(), (Dictionary)HashMapDictionaryBuilder.put((Object)"osgi.jaxrs.application.select", (Object)("(osgi.jaxrs.name=" + osgiJaxRsName + ")")).put((Object)"osgi.jaxrs.extension", (Object)"true").put((Object)"osgi.jaxrs.name", (Object)objectDefinition.getOSGiJaxRsName("ObjectEntryValuesExceptionMapper")).build()), this._bundleContext.registerService(ExceptionMapper.class, (Object)new ObjectValidationRuleEngineExceptionMapper(), (Dictionary)HashMapDictionaryBuilder.put((Object)"osgi.jaxrs.application.select", (Object)("(osgi.jaxrs.name=" + osgiJaxRsName + ")")).put((Object)"osgi.jaxrs.extension", (Object)"true").put((Object)"osgi.jaxrs.name", (Object)objectDefinition.getOSGiJaxRsName("ObjectValidationRuleEngineExceptionMapper")).build()), this._bundleContext.registerService(ExceptionMapper.class, (Object)new RequiredObjectRelationshipExceptionMapper(), (Dictionary)HashMapDictionaryBuilder.put((Object)"osgi.jaxrs.application.select", (Object)("(osgi.jaxrs.name=" + osgiJaxRsName + ")")).put((Object)"osgi.jaxrs.extension", (Object)"true").put((Object)"osgi.jaxrs.name", (Object)objectDefinition.getOSGiJaxRsName("RequiredObjectRelationshipExceptionMapper")).build()), this._bundleContext.registerService(ObjectEntryRelatedObjectsResourceImpl.class, (ServiceFactory)new PrototypeServiceFactory<ObjectEntryRelatedObjectsResourceImpl>(){

            public ObjectEntryRelatedObjectsResourceImpl getService(Bundle bundle, ServiceRegistration<ObjectEntryRelatedObjectsResourceImpl> serviceRegistration) {
                return new ObjectEntryRelatedObjectsResourceImpl(ObjectDefinitionDeployerImpl.this._objectDefinitionLocalService, ObjectDefinitionDeployerImpl.this._objectEntryManagerRegistry, ObjectDefinitionDeployerImpl.this._objectRelationshipService);
            }

            public void ungetService(Bundle bundle, ServiceRegistration<ObjectEntryRelatedObjectsResourceImpl> serviceRegistration, ObjectEntryRelatedObjectsResourceImpl objectEntryRelatedObjectsResourceImpl) {
            }
        }, (Dictionary)HashMapDictionaryBuilder.put((Object)"api.version", (Object)"v1.0").put((Object)"entity.class.name", (Object)(ObjectEntry.class.getName() + "#" + objectDefinition.getName())).put((Object)"osgi.jaxrs.application.select", (Object)("(osgi.jaxrs.name=" + osgiJaxRsName + ")")).put((Object)"osgi.jaxrs.resource", (Object)"true").build()), this._bundleContext.registerService(ObjectEntryResource.Factory.class, (Object)new ObjectEntryResourceFactoryImpl(this._companyLocalService, this._defaultPermissionCheckerFactory, this._expressionConvert, this._filterParserProvider, this._groupLocalService, objectDefinition, this::_createObjectEntryResourceImpl, this._resourceActionLocalService, this._resourcePermissionLocalService, this._roleLocalService, this._sortParserProvider, this._userLocalService), (Dictionary)HashMapDictionaryBuilder.put((Object)"resource.locator.key", (Object)(objectDefinition.getRESTContextPath() + "/" + objectDefinition.getShortName())).build()), this._bundleContext.registerService(ObjectEntryResource.class, (ServiceFactory)new PrototypeServiceFactory<ObjectEntryResource>(){

            public ObjectEntryResource getService(Bundle bundle, ServiceRegistration<ObjectEntryResource> serviceRegistration) {
                return ObjectDefinitionDeployerImpl.this._createObjectEntryResourceImpl();
            }

            public void ungetService(Bundle bundle, ServiceRegistration<ObjectEntryResource> serviceRegistration, ObjectEntryResource objectEntryResource) {
            }
        }, (Dictionary)HashMapDictionaryBuilder.put((Object)"api.version", (Object)"v1.0").put((Object)"batch.engine.entity.class.name", (Object)(ObjectEntry.class.getName() + "#" + osgiJaxRsName)).put((Object)"batch.engine.task.item.delegate", (Object)"true").put((Object)"batch.engine.task.item.delegate.name", (Object)osgiJaxRsName).put((Object)"batch.planner.export.enabled", (Object)"true").put((Object)"batch.planner.import.enabled", (Object)"true").put((Object)"entity.class.name", (Object)(ObjectEntry.class.getName() + "#" + osgiJaxRsName)).put((Object)"osgi.jaxrs.application.select", (Object)("(osgi.jaxrs.name=" + osgiJaxRsName + ")")).put((Object)"osgi.jaxrs.resource", (Object)"true").build())));
    }

    private void _initSystemObjectDefinition(SystemObjectDefinitionMetadata systemObjectDefinitionMetadata) {
        if (systemObjectDefinitionMetadata == null) {
            return;
        }
        JaxRsApplicationDescriptor jaxRsApplicationDescriptor = systemObjectDefinitionMetadata.getJaxRsApplicationDescriptor();
        this._componentInstancesMap.computeIfAbsent(jaxRsApplicationDescriptor.getRESTContextPath(), key -> Arrays.asList(this._relatedObjectEntryResourceImplComponentFactory.newInstance((Dictionary)HashMapDictionaryBuilder.put((Object)"api.version", (Object)"v1.0").put((Object)"osgi.jaxrs.application.select", () -> {
            String applicationName = jaxRsApplicationDescriptor.getApplicationName();
            return "(osgi.jaxrs.name=" + applicationName + ")";
        }).put((Object)"osgi.jaxrs.resource", (Object)"true").build())));
    }
}

