/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.petra.sql.dsl;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.petra.sql.dsl.DynamicObjectDefinitionTableUtil;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.base.BaseTable;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.List;

public class DynamicObjectDefinitionTable
extends BaseTable<DynamicObjectDefinitionTable> {
    private static final Log _log = LogFactoryUtil.getLog(DynamicObjectDefinitionTable.class);
    private final ObjectDefinition _objectDefinition;
    private final List<ObjectField> _objectFields;
    private final String _primaryKeyColumnName;
    private final String _tableName;

    public DynamicObjectDefinitionTable(ObjectDefinition objectDefinition, List<ObjectField> objectFields, String tableName) {
        super(tableName, () -> null);
        this._objectDefinition = objectDefinition;
        this._objectFields = objectFields;
        this._tableName = tableName;
        this._primaryKeyColumnName = objectDefinition.getPKObjectFieldDBColumnName();
        this.createColumn(this._primaryKeyColumnName, Long.class, -5, 2);
        for (ObjectField objectField : objectFields) {
            if (objectField.compareBusinessType("Aggregation") || objectField.compareBusinessType("Formula") || objectField.isLocalized()) continue;
            this.createColumn(objectField.getDBColumnName(), DynamicObjectDefinitionTableUtil.getJavaClass(objectField.getDBType()), DynamicObjectDefinitionTableUtil.getSQLType(objectField.getDBType()), 0);
        }
    }

    public String getCreateTableSQL() {
        StringBundler sb = new StringBundler();
        sb.append("create table ");
        sb.append(this._tableName);
        sb.append(" (");
        sb.append(this._primaryKeyColumnName);
        sb.append(" LONG not null primary key");
        for (ObjectField objectField : this._objectFields) {
            if (objectField.compareBusinessType("Aggregation") || objectField.compareBusinessType("Formula") || objectField.isLocalized()) continue;
            sb.append(", ");
            sb.append(objectField.getDBColumnName());
            sb.append(" ");
            sb.append(DynamicObjectDefinitionTableUtil.getDataType(objectField.getDBType()));
            sb.append(DynamicObjectDefinitionTableUtil.getSQLColumnNull(objectField.getDBType()));
        }
        sb.append(")");
        String sql = sb.toString();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("SQL: " + sql));
        }
        return sql;
    }

    public ObjectDefinition getObjectDefinition() {
        return this._objectDefinition;
    }

    public List<ObjectField> getObjectFields() {
        return this._objectFields;
    }

    public Column<DynamicObjectDefinitionTable, Long> getPrimaryKeyColumn() {
        return this.getColumn(this._primaryKeyColumnName);
    }

    public String getPrimaryKeyColumnName() {
        return this._primaryKeyColumnName;
    }

    protected <C> Column<DynamicObjectDefinitionTable, C> createColumn(String name, Class<C> javaClass, int sqlType, int flags) {
        return super.createColumn(name, javaClass, sqlType, flags);
    }
}

