/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.petra.sql.dsl;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.petra.sql.dsl.DynamicObjectDefinitionTableUtil;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.base.BaseTable;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.ArrayList;
import java.util.List;

public class DynamicObjectDefinitionLocalizationTable
extends BaseTable<DynamicObjectDefinitionLocalizationTable> {
    private static final Log _log = LogFactoryUtil.getLog(DynamicObjectDefinitionLocalizationTable.class);
    private final ObjectDefinition _objectDefinition;
    private final List<Column<DynamicObjectDefinitionLocalizationTable, ?>> _objectFieldColumns;
    private final List<ObjectField> _objectFields;

    public DynamicObjectDefinitionLocalizationTable(ObjectDefinition objectDefinition, List<ObjectField> objectFields) {
        super(objectDefinition.getLocalizationDBTableName(), () -> null);
        this._objectDefinition = objectDefinition;
        this._objectFields = objectFields;
        this.createColumn(objectDefinition.getPKObjectFieldDBColumnName(), Long.class, -5, 0);
        this.createColumn("languageId", String.class, 12, 0);
        for (ObjectField objectField : objectFields) {
            this.createColumn(objectField.getDBColumnName(), DynamicObjectDefinitionTableUtil.getJavaClass(objectField.getDBType()), DynamicObjectDefinitionTableUtil.getSQLType(objectField.getDBType()), 0);
        }
        this._objectFieldColumns = ListUtil.filter(new ArrayList(this.getColumns()), column -> !column.equals(this.getForeignKeyColumn()) && !column.equals(this.getLanguageIdColumn()));
    }

    public String getCreateTableSQL() {
        StringBundler sb = new StringBundler();
        sb.append("create table ");
        sb.append(this._objectDefinition.getLocalizationDBTableName());
        sb.append(" (");
        sb.append(this._objectDefinition.getPKObjectFieldDBColumnName());
        sb.append(" LONG not null, languageId VARCHAR(10) not null");
        for (ObjectField objectField : this._objectFields) {
            sb.append(", ");
            sb.append(objectField.getDBColumnName());
            sb.append(" ");
            sb.append(DynamicObjectDefinitionTableUtil.getDataType(objectField.getDBType()));
        }
        sb.append(", primary key (");
        sb.append(this._objectDefinition.getPKObjectFieldDBColumnName());
        sb.append(", languageId))");
        String sql = sb.toString();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("SQL: " + sql));
        }
        return sql;
    }

    public Column<DynamicObjectDefinitionLocalizationTable, Long> getForeignKeyColumn() {
        return this.getColumn(this._objectDefinition.getPKObjectFieldDBColumnName());
    }

    public String getForeignKeyColumnName() {
        Column<DynamicObjectDefinitionLocalizationTable, Long> foreignKeyColumn = this.getForeignKeyColumn();
        return foreignKeyColumn.getName();
    }

    public Column<DynamicObjectDefinitionLocalizationTable, String> getLanguageIdColumn() {
        return this.getColumn("languageId");
    }

    public ObjectDefinition getObjectDefinition() {
        return this._objectDefinition;
    }

    public List<Column<DynamicObjectDefinitionLocalizationTable, ?>> getObjectFieldColumns() {
        return this._objectFieldColumns;
    }

    public List<ObjectField> getObjectFields() {
        return this._objectFields;
    }
}

