/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.system;

import com.liferay.object.field.util.ObjectFieldUtil;
import com.liferay.object.model.ObjectField;
import com.liferay.object.system.SystemObjectDefinitionManager;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.vulcan.extension.ExtensionProvider;
import com.liferay.portal.vulcan.extension.ExtensionProviderRegistry;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseSystemObjectDefinitionManager
implements SystemObjectDefinitionManager {
    @Reference
    protected ExtensionProviderRegistry extensionProviderRegistry;

    @Override
    public String getModelClassName() {
        Class<?> modelClass = this.getModelClass();
        return modelClass.getName();
    }

    @Override
    public String getName() {
        Table table = this.getTable();
        String tableName = table.getName();
        if (tableName.endsWith("_")) {
            return tableName.substring(0, tableName.length() - 1);
        }
        return tableName;
    }

    @Override
    public String getRESTDTOIdPropertyName() {
        return "id";
    }

    @Override
    public String getTitleObjectFieldName() {
        return "id";
    }

    @Override
    public long upsertBaseModel(String externalReferenceCode, long companyId, User user, Map<String, Object> values) throws Exception {
        BaseModel<?> baseModel = this.fetchBaseModelByExternalReferenceCode(externalReferenceCode, companyId);
        if (baseModel != null) {
            long primaryKey = (Long)baseModel.getPrimaryKeyObj();
            this.updateBaseModel(primaryKey, user, values);
            return primaryKey;
        }
        return this.addBaseModel(user, values);
    }

    protected Map<Locale, String> createLabelMap(String labelKey) {
        return LocalizedMapUtil.getLocalizedMap((String)this._translate(labelKey));
    }

    protected ObjectField createObjectField(String businessType, String dbType, String labelKey, String name, boolean required, boolean system) {
        return this.createObjectField(businessType, null, dbType, labelKey, name, required, system);
    }

    protected ObjectField createObjectField(String businessType, String dbColumnName, String dbType, String labelKey, String name, boolean required, boolean system) {
        return ObjectFieldUtil.createObjectField(0L, businessType, dbColumnName, dbType, false, false, null, this._translate(labelKey), name, required, system);
    }

    protected Map<String, String> getLanguageIdMap(String propertyName, Map<String, Object> values) {
        Object propertyValue = values.get(propertyName);
        if (propertyValue instanceof Map) {
            return (Map)propertyValue;
        }
        if (propertyValue instanceof String) {
            return LocalizedMapUtil.getLanguageIdMap((Map)LocalizedMapUtil.getLocalizedMap((String)GetterUtil.getString((Object)propertyValue)));
        }
        return null;
    }

    protected void setExtendedProperties(String className, Object entity, User user, Map<String, Object> values) throws Exception {
        List extensionProviders = this.extensionProviderRegistry.getExtensionProviders(user.getCompanyId(), className);
        if (ListUtil.isEmpty((List)extensionProviders)) {
            return;
        }
        for (ExtensionProvider extensionProvider : extensionProviders) {
            Map propertyDefinitions = extensionProvider.getExtendedPropertyDefinitions(user.getCompanyId(), className);
            HashMap<String, Serializable> extendedProperties = new HashMap<String, Serializable>();
            for (Map.Entry<String, Object> entry : values.entrySet()) {
                String propertyKey = entry.getKey();
                if (!propertyDefinitions.containsKey(propertyKey)) continue;
                extendedProperties.put(propertyKey, (Serializable)entry.getValue());
            }
            if (!MapUtil.isNotEmpty(extendedProperties)) continue;
            extensionProvider.setExtendedProperties(user.getCompanyId(), user.getUserId(), className, entity, extendedProperties);
        }
    }

    private String _translate(String labelKey) {
        return LanguageUtil.get((Locale)LocaleUtil.getDefault(), (String)labelKey);
    }
}

