/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.field.setting.util;

import com.liferay.dynamic.data.mapping.expression.CreateExpressionRequest;
import com.liferay.dynamic.data.mapping.expression.DDMExpression;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionException;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFactory;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectFieldSetting;
import com.liferay.object.service.ObjectFieldSettingLocalService;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Map;
import java.util.Objects;

public class ObjectFieldSettingUtil {
    private static final Log _log = LogFactoryUtil.getLog(ObjectFieldSettingUtil.class);

    public static String getDefaultValueAsString(DDMExpressionFactory ddmExpressionFactory, long objectFieldId, ObjectFieldSettingLocalService objectFieldSettingLocalService, Map<String, Object> values) {
        ObjectFieldSetting defaultValueObjectFieldSetting = objectFieldSettingLocalService.fetchObjectFieldSetting(objectFieldId, "defaultValue");
        if (defaultValueObjectFieldSetting == null) {
            return null;
        }
        ObjectFieldSetting defaultValueTypeObjectFieldSetting = objectFieldSettingLocalService.fetchObjectFieldSetting(objectFieldId, "defaultValueType");
        if (defaultValueTypeObjectFieldSetting == null || StringUtil.equals((String)defaultValueTypeObjectFieldSetting.getValue(), (String)"inputAsValue")) {
            return defaultValueObjectFieldSetting.getValue();
        }
        if (ddmExpressionFactory == null) {
            return "";
        }
        try {
            DDMExpression ddmExpression = ddmExpressionFactory.createExpression(CreateExpressionRequest.Builder.newBuilder((String)defaultValueObjectFieldSetting.getValue()).build());
            ddmExpression.setVariables(values);
            return (String)ddmExpression.evaluate();
        }
        catch (DDMExpressionException ddmExpressionException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)ddmExpressionException);
            }
            return "";
        }
    }

    public static String getValue(String name, ObjectField objectField) {
        for (ObjectFieldSetting objectFieldSetting : objectField.getObjectFieldSettings()) {
            if (!Objects.equals(objectFieldSetting.getName(), name)) continue;
            return objectFieldSetting.getValue();
        }
        return null;
    }
}

