/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.field.filter.parser;

import com.liferay.object.exception.ObjectViewFilterColumnException;
import com.liferay.object.field.filter.parser.ObjectFieldFilterStrategy;
import com.liferay.object.model.ObjectViewFilterColumn;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Validator;
import java.util.Locale;
import java.util.Map;

public abstract class BaseObjectFieldFilterStrategy
implements ObjectFieldFilterStrategy {
    protected Locale locale;
    protected ObjectViewFilterColumn objectViewFilterColumn;

    public BaseObjectFieldFilterStrategy(Locale locale, ObjectViewFilterColumn objectViewFilterColumn) {
        this.locale = locale;
        this.objectViewFilterColumn = objectViewFilterColumn;
    }

    @Override
    public Map<String, Object> parse() throws PortalException {
        if (Validator.isNull((String)this.objectViewFilterColumn.getFilterType())) {
            return null;
        }
        return HashMapBuilder.put((Object)"exclude", (Object)"excludes".equals(this.objectViewFilterColumn.getFilterType())).put((Object)"selectedItems", this.getSelectionFDSFilterItems()).build();
    }

    @Override
    public void validate() throws PortalException {
        if (this.getJSONArray() == null) {
            throw new ObjectViewFilterColumnException("JSON array is null for filter type " + this.objectViewFilterColumn.getFilterType());
        }
    }

    protected JSONArray getJSONArray() throws JSONException {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)this.objectViewFilterColumn.getJSON());
        return jsonObject.getJSONArray(this.objectViewFilterColumn.getFilterType());
    }
}

