/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.field.business.type;

import com.liferay.object.exception.ObjectFieldDefaultValueException;
import com.liferay.object.exception.ObjectFieldSettingNameException;
import com.liferay.object.exception.ObjectFieldSettingValueException;
import com.liferay.object.field.render.ObjectFieldRenderingContext;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectFieldSetting;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.extension.PropertyDefinition;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public interface ObjectFieldBusinessType {
    default public Set<String> getAllowedObjectFieldSettingsNames() {
        return Collections.emptySet();
    }

    public String getDBType();

    public String getDDMFormFieldTypeName();

    default public String getDescription(Locale locale) {
        return "";
    }

    public String getLabel(Locale var1);

    public String getName();

    default public Map<String, Object> getProperties(ObjectField objectField, ObjectFieldRenderingContext objectFieldRenderingContext) throws PortalException {
        return Collections.emptyMap();
    }

    public PropertyDefinition.PropertyType getPropertyType();

    default public Set<String> getRequiredObjectFieldSettingsNames(ObjectField objectField) {
        return Collections.emptySet();
    }

    default public Set<String> getUnmodifiablObjectFieldSettingsNames() {
        return Collections.emptySet();
    }

    default public Object getValue(ObjectField objectField, Map<String, Object> values) throws PortalException {
        return values.get(objectField.getName());
    }

    default public boolean isVisible(ObjectDefinition objectDefinition) {
        return true;
    }

    default public void predefineObjectFieldSettings(ObjectField newObjectField, ObjectField oldObjectField, List<ObjectFieldSetting> objectFieldSettings) throws PortalException {
    }

    default public void validateObjectFieldSettings(ObjectField objectField, List<ObjectFieldSetting> objectFieldSettings) throws PortalException {
        HashSet<String> missingRequiredObjectFieldSettingsNames = new HashSet<String>();
        HashMap<String, String> objectFieldSettingsValuesMap = new HashMap<String, String>();
        for (ObjectFieldSetting objectFieldSetting : objectFieldSettings) {
            objectFieldSettingsValuesMap.put(objectFieldSetting.getName(), objectFieldSetting.getValue());
        }
        for (String requiredObjectFieldSettingName : this.getRequiredObjectFieldSettingsNames(objectField)) {
            if (!Validator.isNull((String)((String)objectFieldSettingsValuesMap.get(requiredObjectFieldSettingName)))) continue;
            missingRequiredObjectFieldSettingsNames.add(requiredObjectFieldSettingName);
        }
        if (!missingRequiredObjectFieldSettingsNames.isEmpty()) {
            throw new ObjectFieldSettingValueException.MissingRequiredValues(objectField.getName(), missingRequiredObjectFieldSettingsNames);
        }
        HashSet<String> notAllowedObjectFieldSettingsNames = new HashSet<String>(objectFieldSettingsValuesMap.keySet());
        notAllowedObjectFieldSettingsNames.removeAll(this.getAllowedObjectFieldSettingsNames());
        notAllowedObjectFieldSettingsNames.removeAll(this.getRequiredObjectFieldSettingsNames(objectField));
        if (!notAllowedObjectFieldSettingsNames.isEmpty()) {
            if (!FeatureFlagManagerUtil.isEnabled((String)"LPS-163716") && notAllowedObjectFieldSettingsNames.contains("defaultValue")) {
                throw new ObjectFieldDefaultValueException(StringBundler.concat((String[])new String[]{"Object field can only have a default type when the ", "business type is \"", "Picklist", "\""}));
            }
            throw new ObjectFieldSettingNameException.NotAllowedNames(objectField.getName(), notAllowedObjectFieldSettingsNames);
        }
        this.validateObjectFieldSettingsDefaultValue(objectField, objectFieldSettingsValuesMap);
    }

    default public void validateObjectFieldSettingsDefaultValue(ObjectField objectField, Map<String, String> objectFieldSettingsValuesMap) throws PortalException {
        String defaultValueType = objectFieldSettingsValuesMap.get("defaultValueType");
        if (defaultValueType == null) {
            return;
        }
        if (!StringUtil.equals((String)defaultValueType, (String)"expressionBuilder") && !StringUtil.equals((String)defaultValueType, (String)"inputAsValue")) {
            throw new ObjectFieldSettingValueException.InvalidValue(objectField.getName(), "defaultValueType", defaultValueType);
        }
    }
}

