/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.exception;

import com.liferay.portal.kernel.exception.PortalException;

public class ObjectActionNameException
extends PortalException {
    private final String _messageKey;

    public String getMessageKey() {
        return this._messageKey;
    }

    private ObjectActionNameException(String message, String messageKey) {
        super(message);
        this._messageKey = messageKey;
    }

    public static class MustOnlyContainLettersAndDigits
    extends ObjectActionNameException {
        public MustOnlyContainLettersAndDigits() {
            super("Name must only contain letters and digits", "name-must-only-contain-letters-and-digits");
        }
    }

    public static class MustNotBeNull
    extends ObjectActionNameException {
        public MustNotBeNull() {
            super("Name is null", "name-is-required");
        }
    }

    public static class MustNotBeDuplicate
    extends ObjectActionNameException {
        public MustNotBeDuplicate(String name) {
            super("Duplicate name " + name, "this-name-is-already-in-use-try-another-one");
        }
    }

    public static class MustBeLessThan41Characters
    extends ObjectActionNameException {
        public MustBeLessThan41Characters() {
            super("Name must be less than 41 characters", "only-41-characters-are-allowed");
        }
    }
}

