/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.field.business.type;

import com.liferay.object.exception.ObjectFieldSettingNameException;
import com.liferay.object.exception.ObjectFieldSettingValueException;
import com.liferay.object.field.render.ObjectFieldRenderingContext;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectFieldSetting;
import com.liferay.object.model.ObjectFieldSettingModel;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.extension.PropertyDefinition;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface ObjectFieldBusinessType {
    default public Set<String> getAllowedObjectFieldSettingsNames() {
        return Collections.emptySet();
    }

    public String getDBType();

    public String getDDMFormFieldTypeName();

    default public String getDescription(Locale locale) {
        return "";
    }

    public String getLabel(Locale var1);

    public String getName();

    default public Map<String, Object> getProperties(ObjectField objectField, ObjectFieldRenderingContext objectFieldRenderingContext) throws PortalException {
        return Collections.emptyMap();
    }

    public PropertyDefinition.PropertyType getPropertyType();

    default public Set<String> getRequiredObjectFieldSettingsNames() {
        return Collections.emptySet();
    }

    default public Object getValue(ObjectField objectField, Map<String, Object> values) throws PortalException {
        return values.get(objectField.getName());
    }

    default public boolean isVisible() {
        return true;
    }

    default public void predefineObjectFieldSettings(ObjectField newObjectField, ObjectField oldObjectField, List<ObjectFieldSetting> objectFieldSettings) throws PortalException {
    }

    default public void validateObjectFieldSettings(long objectDefinitionId, String objectFieldName, List<ObjectFieldSetting> objectFieldSettings) throws PortalException {
        HashSet<String> missingRequiredObjectFieldSettingsNames = new HashSet<String>();
        Stream stream = objectFieldSettings.stream();
        Map<String, String> objectFieldSettingsValuesMap = stream.collect(Collectors.toMap(ObjectFieldSettingModel::getName, ObjectFieldSettingModel::getValue));
        for (String requiredObjectFieldSettingName : this.getRequiredObjectFieldSettingsNames()) {
            if (!Validator.isNull((String)objectFieldSettingsValuesMap.get(requiredObjectFieldSettingName))) continue;
            missingRequiredObjectFieldSettingsNames.add(requiredObjectFieldSettingName);
        }
        if (!missingRequiredObjectFieldSettingsNames.isEmpty()) {
            throw new ObjectFieldSettingValueException.MissingRequiredValues(objectFieldName, missingRequiredObjectFieldSettingsNames);
        }
        HashSet<String> notAllowedObjectFieldSettingsNames = new HashSet<String>(objectFieldSettingsValuesMap.keySet());
        notAllowedObjectFieldSettingsNames.removeAll(this.getAllowedObjectFieldSettingsNames());
        notAllowedObjectFieldSettingsNames.removeAll(this.getRequiredObjectFieldSettingsNames());
        if (!notAllowedObjectFieldSettingsNames.isEmpty()) {
            throw new ObjectFieldSettingNameException.NotAllowedNames(objectFieldName, notAllowedObjectFieldSettingsNames);
        }
    }
}

