/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.exception;

import com.liferay.portal.kernel.exception.PortalException;

public class ObjectFieldNameException
extends PortalException {
    private ObjectFieldNameException(String msg) {
        super(msg);
    }

    public static class MustOnlyContainLettersAndDigits
    extends ObjectFieldNameException {
        public MustOnlyContainLettersAndDigits() {
            super("Name must only contain letters and digits");
        }
    }

    public static class MustNotBeReserved
    extends ObjectFieldNameException {
        public MustNotBeReserved(String name) {
            super("Reserved name " + name);
        }
    }

    public static class MustNotBeNull
    extends ObjectFieldNameException {
        public MustNotBeNull() {
            super("Name is null");
        }
    }

    public static class MustNotBeDuplicate
    extends ObjectFieldNameException {
        public MustNotBeDuplicate(String name) {
            super("Duplicate name " + name);
        }
    }

    public static class MustBeLessThan41Characters
    extends ObjectFieldNameException {
        public MustBeLessThan41Characters() {
            super("Name must be less than 41 characters");
        }
    }

    public static class MustBeginWithLowerCaseLetter
    extends ObjectFieldNameException {
        public MustBeginWithLowerCaseLetter() {
            super("The first character of a name must be a lower case letter");
        }
    }
}

