/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.field.util;

import com.liferay.dynamic.data.mapping.expression.CreateExpressionRequest;
import com.liferay.dynamic.data.mapping.expression.DDMExpression;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFactory;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectFieldSetting;
import com.liferay.object.service.ObjectFieldSettingLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ObjectFieldFormulaEvaluatorUtil {
    private static final Log _log = LogFactoryUtil.getLog(ObjectFieldFormulaEvaluatorUtil.class);

    public static Map<String, Serializable> evaluate(DDMExpressionFactory ddmExpressionFactory, List<ObjectField> objectFields, ObjectFieldSettingLocalService objectFieldSettingLocalService, UserLocalService userLocalService, Map<String, Serializable> values) throws PortalException {
        for (ObjectField objectField : objectFields) {
            if (!objectField.compareBusinessType("Formula")) continue;
            HashMap<String, String> objectFieldSettingMap = new HashMap<String, String>();
            List<ObjectFieldSetting> objectFieldSettings = objectFieldSettingLocalService.getObjectFieldObjectFieldSettings(objectField.getObjectFieldId());
            for (ObjectFieldSetting objectFieldSetting : objectFieldSettings) {
                objectFieldSettingMap.put(objectFieldSetting.getName(), objectFieldSetting.getValue());
            }
            Object script = objectFieldSettingMap.get("script");
            if (script == null) break;
            DDMExpression ddmExpression = ddmExpressionFactory.createExpression(CreateExpressionRequest.Builder.newBuilder((String)String.valueOf(script)).build());
            ddmExpression.setVariables(new HashMap<String, Serializable>(values));
            try {
                values.put(objectField.getName(), ObjectFieldFormulaEvaluatorUtil._getOutputValue(String.valueOf(objectFieldSettingMap.get("output")), userLocalService, ddmExpression.evaluate()));
            }
            catch (PortalException portalException) {
                _log.error((Throwable)portalException);
            }
        }
        return values;
    }

    private static Serializable _getOutputValue(String outputType, UserLocalService userLocalService, Object value) {
        if (StringUtil.equals((String)outputType, (String)"Boolean")) {
            return Boolean.valueOf(GetterUtil.getBoolean((Object)value));
        }
        if (StringUtil.equals((String)outputType, (String)"Date")) {
            User user = userLocalService.fetchUser(PrincipalThreadLocal.getUserId());
            Locale locale = user == null ? LocaleUtil.getSiteDefault() : user.getLocale();
            DateFormat dateFormat = DateFormatFactoryUtil.getDate((Locale)locale);
            return dateFormat.format(value);
        }
        if (StringUtil.equals((String)outputType, (String)"Decimal")) {
            return Double.valueOf(GetterUtil.getDouble((Object)value));
        }
        if (StringUtil.equals((String)outputType, (String)"Integer")) {
            return Integer.valueOf(GetterUtil.getInteger((Object)value));
        }
        if (StringUtil.equals((String)outputType, (String)"Text")) {
            return value.toString();
        }
        return null;
    }
}

