/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.system.model.listener;

import com.liferay.object.action.engine.ObjectActionEngine;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.Map;
import java.util.function.Function;

public class SystemObjectDefinitionMetadataModelListener
extends BaseModelListener {
    private final JSONFactory _jsonFactory;
    private final Class<?> _modelClass;
    private final ObjectActionEngine _objectActionEngine;
    private final ObjectDefinitionLocalService _objectDefinitionLocalService;
    private final ObjectEntryLocalService _objectEntryLocalService;

    public SystemObjectDefinitionMetadataModelListener(JSONFactory jsonFactory, Class<?> modelClass, ObjectActionEngine objectActionEngine, ObjectDefinitionLocalService objectDefinitionLocalService, ObjectEntryLocalService objectEntryLocalService) {
        this._jsonFactory = jsonFactory;
        this._modelClass = modelClass;
        this._objectActionEngine = objectActionEngine;
        this._objectDefinitionLocalService = objectDefinitionLocalService;
        this._objectEntryLocalService = objectEntryLocalService;
    }

    public Class<?> getModelClass() {
        return this._modelClass;
    }

    public void onAfterCreate(BaseModel baseModel) throws ModelListenerException {
        this._executeObjectActions("onAfterAdd", null, (BaseModel)baseModel.clone());
    }

    public void onAfterRemove(BaseModel baseModel) throws ModelListenerException {
        this._executeObjectActions("onAfterDelete", null, baseModel);
    }

    public void onAfterUpdate(BaseModel originalBaseModel, BaseModel baseModel) throws ModelListenerException {
        this._executeObjectActions("onAfterUpdate", originalBaseModel, (BaseModel)baseModel.clone());
    }

    public void onBeforeRemove(BaseModel baseModel) throws ModelListenerException {
        try {
            ObjectDefinition objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinitionByClassName(this._getCompanyId(baseModel), this._modelClass.getName());
            if (objectDefinition == null) {
                return;
            }
            this._objectEntryLocalService.deleteRelatedObjectEntries(0L, objectDefinition.getObjectDefinitionId(), GetterUtil.getLong((Object)baseModel.getPrimaryKeyObj()));
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
    }

    private void _executeObjectActions(String objectActionTriggerKey, BaseModel originalBaseModel, BaseModel baseModel) throws ModelListenerException {
        try {
            long userId = PrincipalThreadLocal.getUserId();
            if (userId == 0L) {
                userId = this._getUserId(baseModel);
            }
            this._objectActionEngine.executeObjectActions(this._modelClass.getName(), this._getCompanyId(baseModel), objectActionTriggerKey, this._getPayloadJSONObject(objectActionTriggerKey, originalBaseModel, baseModel), userId);
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
    }

    private long _getCompanyId(BaseModel<?> baseModel) {
        Map functions = baseModel.getAttributeGetterFunctions();
        Function function = (Function)functions.get("companyId");
        if (function == null) {
            throw new IllegalArgumentException("Base model does not have a company ID column");
        }
        return (Long)function.apply(baseModel);
    }

    private JSONObject _getPayloadJSONObject(String objectActionTriggerKey, BaseModel originalBaseModel, BaseModel baseModel) throws JSONException {
        return JSONUtil.put((String)"objectActionTriggerKey", (Object)objectActionTriggerKey).put("model" + this._modelClass.getSimpleName(), this._jsonFactory.createJSONObject(this._jsonFactory.serialize((Object)baseModel))).put("original" + this._modelClass.getSimpleName(), () -> {
            if (originalBaseModel != null) {
                return this._jsonFactory.createJSONObject(this._jsonFactory.serialize((Object)originalBaseModel));
            }
            return null;
        });
    }

    private long _getUserId(BaseModel<?> baseModel) {
        Map functions = baseModel.getAttributeGetterFunctions();
        Function function = (Function)functions.get("userId");
        if (function == null) {
            throw new IllegalArgumentException("Base model does not have a user ID column");
        }
        return (Long)function.apply(baseModel);
    }
}

