/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.admin.rest.internal.resource.v1_0;

import com.liferay.list.type.service.ListTypeDefinitionLocalService;
import com.liferay.list.type.service.ListTypeEntryLocalService;
import com.liferay.object.admin.rest.dto.v1_0.ObjectLayout;
import com.liferay.object.admin.rest.dto.v1_0.ObjectRelationship;
import com.liferay.object.admin.rest.dto.v1_0.Status;
import com.liferay.object.admin.rest.dto.v1_0.util.ObjectActionUtil;
import com.liferay.object.admin.rest.internal.dto.v1_0.converter.ObjectFieldDTOConverter;
import com.liferay.object.admin.rest.internal.dto.v1_0.converter.ObjectRelationshipDTOConverter;
import com.liferay.object.admin.rest.internal.dto.v1_0.converter.ObjectViewDTOConverter;
import com.liferay.object.admin.rest.internal.dto.v1_0.util.ObjectFieldSettingUtil;
import com.liferay.object.admin.rest.internal.dto.v1_0.util.ObjectFieldUtil;
import com.liferay.object.admin.rest.internal.dto.v1_0.util.ObjectLayoutUtil;
import com.liferay.object.admin.rest.internal.odata.entity.v1_0.ObjectDefinitionEntityModel;
import com.liferay.object.admin.rest.internal.resource.v1_0.BaseObjectDefinitionResourceImpl;
import com.liferay.object.admin.rest.resource.v1_0.ObjectActionResource;
import com.liferay.object.admin.rest.resource.v1_0.ObjectDefinitionResource;
import com.liferay.object.admin.rest.resource.v1_0.ObjectLayoutResource;
import com.liferay.object.admin.rest.resource.v1_0.ObjectRelationshipResource;
import com.liferay.object.admin.rest.resource.v1_0.ObjectViewResource;
import com.liferay.object.exception.ObjectDefinitionStorageTypeException;
import com.liferay.object.model.ObjectAction;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectView;
import com.liferay.object.service.ObjectActionLocalService;
import com.liferay.object.service.ObjectActionService;
import com.liferay.object.service.ObjectDefinitionService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectFieldSettingLocalService;
import com.liferay.object.service.ObjectFilterLocalService;
import com.liferay.object.service.ObjectLayoutLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.object.service.ObjectViewLocalService;
import com.liferay.object.service.ObjectViewService;
import com.liferay.object.system.JaxRsApplicationDescriptor;
import com.liferay.object.system.SystemObjectDefinitionMetadata;
import com.liferay.object.system.SystemObjectDefinitionMetadataRegistry;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowConstants;
import com.liferay.portal.language.LanguageResources;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/object-definition.properties"}, scope=ServiceScope.PROTOTYPE, service={ObjectDefinitionResource.class})
public class ObjectDefinitionResourceImpl
extends BaseObjectDefinitionResourceImpl {
    private static final EntityModel _entityModel = new ObjectDefinitionEntityModel();
    @Reference
    private Language _language;
    @Reference
    private ListTypeDefinitionLocalService _listTypeDefinitionLocalService;
    @Reference
    private ListTypeEntryLocalService _listTypeEntryLocalService;
    @Reference
    private ObjectActionLocalService _objectActionLocalService;
    @Reference
    private ObjectActionResource.Factory _objectActionResourceFactory;
    @Reference
    private ObjectActionService _objectActionService;
    @Reference
    private ObjectDefinitionService _objectDefinitionService;
    @Reference
    private ObjectFieldDTOConverter _objectFieldDTOConverter;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private ObjectFieldSettingLocalService _objectFieldSettingLocalService;
    @Reference
    private ObjectFilterLocalService _objectFilterLocalService;
    @Reference
    private ObjectLayoutLocalService _objectLayoutLocalService;
    @Reference
    private ObjectLayoutResource.Factory _objectLayoutResourceFactory;
    @Reference
    private ObjectRelationshipDTOConverter _objectRelationshipDTOConverter;
    @Reference
    private ObjectRelationshipLocalService _objectRelationshipLocalService;
    @Reference
    private ObjectRelationshipResource.Factory _objectRelationshipResourceFactory;
    @Reference
    private ObjectViewDTOConverter _objectViewDTOConverter;
    @Reference
    private ObjectViewLocalService _objectViewLocalService;
    @Reference
    private ObjectViewResource.Factory _objectViewResourceFactory;
    @Reference
    private ObjectViewService _objectViewService;
    @Reference
    private SystemObjectDefinitionMetadataRegistry _systemObjectDefinitionMetadataRegistry;

    @Override
    public void create(Collection<com.liferay.object.admin.rest.dto.v1_0.ObjectDefinition> objectDefinitions, Map<String, Serializable> parameters) throws Exception {
        super.create(objectDefinitions, parameters);
        for (com.liferay.object.admin.rest.dto.v1_0.ObjectDefinition objectDefinition : objectDefinitions) {
            Status status = objectDefinition.getStatus();
            if (status == null || status.getCode() != 0) continue;
            ObjectDefinition serviceBuilderObjectDefinition = this._objectDefinitionService.getObjectDefinitionByExternalReferenceCode(objectDefinition.getExternalReferenceCode(), this.contextCompany.getCompanyId());
            this._objectDefinitionService.publishCustomObjectDefinition(serviceBuilderObjectDefinition.getObjectDefinitionId());
        }
    }

    @Override
    public void deleteObjectDefinition(Long objectDefinitionId) throws Exception {
        this._objectDefinitionService.deleteObjectDefinition(objectDefinitionId.longValue());
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return _entityModel;
    }

    @Override
    public com.liferay.object.admin.rest.dto.v1_0.ObjectDefinition getObjectDefinition(Long objectDefinitionId) throws Exception {
        return this._toObjectDefinition(this._objectDefinitionService.getObjectDefinition(objectDefinitionId.longValue()));
    }

    @Override
    public com.liferay.object.admin.rest.dto.v1_0.ObjectDefinition getObjectDefinitionByExternalReferenceCode(String externalReferenceCode) throws Exception {
        return this._toObjectDefinition(this._objectDefinitionService.fetchObjectDefinitionByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId()));
    }

    @Override
    public Page<com.liferay.object.admin.rest.dto.v1_0.ObjectDefinition> getObjectDefinitionsPage(String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search((Map)HashMapBuilder.put((Object)"create", this.addAction("ADD_OBJECT_DEFINITION", "postObjectDefinition", "com.liferay.object", this.contextCompany.getCompanyId())).put((Object)"createBatch", this.addAction("ADD_OBJECT_DEFINITION", "postObjectDefinitionBatch", "com.liferay.object", this.contextCompany.getCompanyId())).put((Object)"deleteBatch", this.addAction("DELETE", "deleteObjectDefinitionBatch", "com.liferay.object", null)).put((Object)"get", this.addAction("VIEW", "getObjectDefinitionsPage", "com.liferay.object", this.contextCompany.getCompanyId())).put((Object)"updateBatch", this.addAction("UPDATE", "putObjectDefinitionBatch", "com.liferay.object", null)).build(), booleanQuery -> {}, (Filter)filter, (String)ObjectDefinition.class.getName(), (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.addVulcanAggregation(aggregation);
            searchContext.setAttribute("name", (Serializable)((Object)search));
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
        }, (Sort[])sorts, document -> this._toObjectDefinition(this._objectDefinitionService.getObjectDefinition(GetterUtil.getLong((String)document.get("entryClassPK")))));
    }

    @Override
    public com.liferay.object.admin.rest.dto.v1_0.ObjectDefinition postObjectDefinition(com.liferay.object.admin.rest.dto.v1_0.ObjectDefinition objectDefinition) throws Exception {
        ObjectField serviceBuilderObjectField;
        if (!Validator.isBlank((String)objectDefinition.getStorageType()) && !GetterUtil.getBoolean((String)PropsUtil.get((String)"feature.flag.LPS-135430"))) {
            throw new ObjectDefinitionStorageTypeException();
        }
        this._addListTypeDefinition(objectDefinition);
        ObjectDefinition serviceBuilderObjectDefinition = this._objectDefinitionService.addCustomObjectDefinition(com.liferay.object.util.LocalizedMapUtil.getLocalizedMap((Map)objectDefinition.getLabel()), objectDefinition.getName(), objectDefinition.getPanelAppOrder(), objectDefinition.getPanelCategoryKey(), com.liferay.object.util.LocalizedMapUtil.getLocalizedMap((Map)objectDefinition.getPluralLabel()), objectDefinition.getScope(), objectDefinition.getStorageType(), this.transformToList(objectDefinition.getObjectFields(), objectField -> ObjectFieldUtil.toObjectField(this._listTypeDefinitionLocalService, objectField, this._objectFieldLocalService, this._objectFieldSettingLocalService, this._objectFilterLocalService)));
        if (!Validator.isBlank((String)objectDefinition.getExternalReferenceCode())) {
            serviceBuilderObjectDefinition = this._objectDefinitionService.updateExternalReferenceCode(serviceBuilderObjectDefinition.getObjectDefinitionId(), objectDefinition.getExternalReferenceCode());
        }
        if ((serviceBuilderObjectField = this._objectFieldLocalService.fetchObjectField(serviceBuilderObjectDefinition.getObjectDefinitionId(), objectDefinition.getTitleObjectFieldName())) != null) {
            serviceBuilderObjectDefinition = this._objectDefinitionService.updateTitleObjectFieldId(serviceBuilderObjectDefinition.getObjectDefinitionId(), serviceBuilderObjectField.getObjectFieldId());
        }
        this._addObjectDefinitionResources(objectDefinition.getObjectActions(), serviceBuilderObjectDefinition.getObjectDefinitionId(), objectDefinition.getObjectLayouts(), objectDefinition.getObjectRelationships(), objectDefinition.getObjectViews());
        return this._toObjectDefinition(serviceBuilderObjectDefinition);
    }

    @Override
    public void postObjectDefinitionPublish(Long objectDefinitionId) throws Exception {
        this._objectDefinitionService.publishCustomObjectDefinition(objectDefinitionId.longValue());
    }

    @Override
    public com.liferay.object.admin.rest.dto.v1_0.ObjectDefinition putObjectDefinition(Long objectDefinitionId, com.liferay.object.admin.rest.dto.v1_0.ObjectDefinition objectDefinition) throws Exception {
        com.liferay.object.admin.rest.dto.v1_0.ObjectView[] objectViews;
        ObjectRelationship[] objectRelationships;
        ObjectLayout[] objectLayouts;
        if (!Validator.isBlank((String)objectDefinition.getStorageType()) && !GetterUtil.getBoolean((String)PropsUtil.get((String)"feature.flag.LPS-135430"))) {
            throw new ObjectDefinitionStorageTypeException();
        }
        ObjectDefinition serviceBuilderObjectDefinition = this._objectDefinitionService.getObjectDefinition(objectDefinitionId.longValue());
        if (!serviceBuilderObjectDefinition.isApproved()) {
            this._addListTypeDefinition(objectDefinition);
        }
        long accountEntryRestrictedObjectFieldId = 0L;
        ObjectField accountEntryRestrictedServiceBuilderObjectField = this._objectFieldLocalService.fetchObjectField(objectDefinitionId.longValue(), objectDefinition.getAccountEntryRestrictedObjectFieldName());
        if (accountEntryRestrictedServiceBuilderObjectField != null) {
            accountEntryRestrictedObjectFieldId = accountEntryRestrictedServiceBuilderObjectField.getObjectFieldId();
        }
        long titleObjectFieldId = 0L;
        ObjectField titleServiceBuilderObjectField = this._objectFieldLocalService.fetchObjectField(objectDefinitionId.longValue(), objectDefinition.getTitleObjectFieldName());
        if (titleServiceBuilderObjectField != null) {
            titleObjectFieldId = titleServiceBuilderObjectField.getObjectFieldId();
        }
        if (serviceBuilderObjectDefinition.isSystem()) {
            return this._toObjectDefinition(this._objectDefinitionService.updateSystemObjectDefinition(objectDefinition.getExternalReferenceCode(), objectDefinitionId.longValue(), titleObjectFieldId));
        }
        serviceBuilderObjectDefinition = this._objectDefinitionService.updateCustomObjectDefinition(objectDefinition.getExternalReferenceCode(), objectDefinitionId.longValue(), GetterUtil.getLong((Object)accountEntryRestrictedObjectFieldId), 0L, titleObjectFieldId, GetterUtil.getBoolean((Object)objectDefinition.getAccountEntryRestricted()), GetterUtil.getBoolean((Object)objectDefinition.getActive(), (boolean)true), GetterUtil.getBoolean((Object)objectDefinition.getEnableCategorization(), (boolean)true), GetterUtil.getBoolean((Object)objectDefinition.getEnableComments()), GetterUtil.getBoolean((Object)objectDefinition.getEnableObjectEntryHistory()), com.liferay.object.util.LocalizedMapUtil.getLocalizedMap((Map)objectDefinition.getLabel()), objectDefinition.getName(), objectDefinition.getPanelAppOrder(), objectDefinition.getPanelCategoryKey(), objectDefinition.getPortlet().booleanValue(), com.liferay.object.util.LocalizedMapUtil.getLocalizedMap((Map)objectDefinition.getPluralLabel()), objectDefinition.getScope());
        ArrayList<ObjectField> serviceBuilderObjectFields = new ArrayList<ObjectField>(this._objectFieldLocalService.getObjectFields(objectDefinitionId.longValue()));
        for (com.liferay.object.admin.rest.dto.v1_0.ObjectField objectField : objectDefinition.getObjectFields()) {
            long listTypeDefinitionId = ObjectFieldUtil.getListTypeDefinitionId(serviceBuilderObjectDefinition.getCompanyId(), this._listTypeDefinitionLocalService, objectField);
            this._objectFieldLocalService.updateObjectField(objectField.getExternalReferenceCode(), GetterUtil.getLong((Object)objectField.getId()), this.contextUser.getUserId(), listTypeDefinitionId, objectDefinitionId.longValue(), objectField.getBusinessTypeAsString(), null, null, objectField.getDBTypeAsString(), objectField.getDefaultValue(), objectField.getIndexed().booleanValue(), objectField.getIndexedAsKeyword().booleanValue(), objectField.getIndexedLanguageId(), LocalizedMapUtil.getLocalizedMap((Map)objectField.getLabel()), objectField.getName(), objectField.getRequired().booleanValue(), GetterUtil.getBoolean((Object)objectField.getState()), objectField.getSystem().booleanValue(), this.transformToList(objectField.getObjectFieldSettings(), objectFieldSetting -> ObjectFieldSettingUtil.toObjectFieldSetting(objectField.getBusinessTypeAsString(), listTypeDefinitionId, objectFieldSetting, this._objectFieldSettingLocalService, this._objectFilterLocalService)));
            serviceBuilderObjectFields.removeIf(serviceBuilderObjectField -> Objects.equals(serviceBuilderObjectField.getName(), objectField.getName()));
        }
        for (ObjectField serviceBuilderObjectField2 : serviceBuilderObjectFields) {
            if (Objects.equals(serviceBuilderObjectField2.getBusinessType(), "Relationship")) continue;
            this._objectFieldLocalService.deleteObjectField(serviceBuilderObjectField2);
        }
        com.liferay.object.admin.rest.dto.v1_0.ObjectAction[] objectActions = objectDefinition.getObjectActions();
        if (objectActions != null) {
            this._objectActionLocalService.deleteObjectActions(objectDefinitionId.longValue());
        }
        if ((objectLayouts = objectDefinition.getObjectLayouts()) != null) {
            this._objectLayoutLocalService.deleteObjectLayouts(objectDefinitionId.longValue());
        }
        if ((objectRelationships = objectDefinition.getObjectRelationships()) != null) {
            this._objectRelationshipLocalService.deleteObjectRelationships(objectDefinitionId.longValue());
        }
        if ((objectViews = objectDefinition.getObjectViews()) != null) {
            this._objectViewLocalService.deleteObjectViews(objectDefinitionId.longValue());
        }
        this._addObjectDefinitionResources(objectActions, objectDefinitionId, objectLayouts, objectRelationships, objectViews);
        return this._toObjectDefinition(serviceBuilderObjectDefinition);
    }

    @Override
    public com.liferay.object.admin.rest.dto.v1_0.ObjectDefinition putObjectDefinitionByExternalReferenceCode(String externalReferenceCode, com.liferay.object.admin.rest.dto.v1_0.ObjectDefinition objectDefinition) throws Exception {
        ObjectDefinition serviceBuilderObjectDefinition = this._objectDefinitionService.fetchObjectDefinitionByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        objectDefinition.setExternalReferenceCode(externalReferenceCode);
        if (serviceBuilderObjectDefinition != null) {
            return this.putObjectDefinition(serviceBuilderObjectDefinition.getObjectDefinitionId(), objectDefinition);
        }
        return this.postObjectDefinition(objectDefinition);
    }

    private void _addListTypeDefinition(com.liferay.object.admin.rest.dto.v1_0.ObjectDefinition objectDefinition) throws Exception {
        if (objectDefinition.getObjectFields() == null) {
            return;
        }
        for (com.liferay.object.admin.rest.dto.v1_0.ObjectField objectField : objectDefinition.getObjectFields()) {
            if (!StringUtil.equals((String)objectField.getBusinessTypeAsString(), (String)"Picklist")) continue;
            ObjectFieldUtil.addListTypeDefinition(this.contextUser.getCompanyId(), this._listTypeDefinitionLocalService, this._listTypeEntryLocalService, objectField, this.contextUser.getUserId());
        }
    }

    private void _addObjectDefinitionResources(com.liferay.object.admin.rest.dto.v1_0.ObjectAction[] objectActions, long objectDefinitionId, ObjectLayout[] objectLayouts, ObjectRelationship[] objectRelationships, com.liferay.object.admin.rest.dto.v1_0.ObjectView[] objectViews) throws Exception {
        ObjectActionResource.Builder builder;
        if (objectActions != null) {
            builder = this._objectActionResourceFactory.create();
            ObjectActionResource objectActionResource = builder.user(this.contextUser).build();
            for (com.liferay.object.admin.rest.dto.v1_0.ObjectAction objectAction : objectActions) {
                objectActionResource.postObjectDefinitionObjectAction(Long.valueOf(objectDefinitionId), objectAction);
            }
        }
        if (objectLayouts != null) {
            builder = this._objectLayoutResourceFactory.create();
            ObjectLayoutResource objectLayoutResource = builder.user(this.contextUser).build();
            for (com.liferay.object.admin.rest.dto.v1_0.ObjectAction objectAction : objectLayouts) {
                objectLayoutResource.postObjectDefinitionObjectLayout(Long.valueOf(objectDefinitionId), (ObjectLayout)objectAction);
            }
        }
        if (objectRelationships != null) {
            builder = this._objectRelationshipResourceFactory.create();
            ObjectRelationshipResource objectRelationshipResource = builder.user(this.contextUser).build();
            for (com.liferay.object.admin.rest.dto.v1_0.ObjectAction objectAction : objectRelationships) {
                objectRelationshipResource.postObjectDefinitionObjectRelationship(Long.valueOf(objectDefinitionId), (ObjectRelationship)objectAction);
            }
        }
        if (objectViews != null) {
            builder = this._objectViewResourceFactory.create();
            ObjectViewResource objectViewResource = builder.user(this.contextUser).build();
            for (com.liferay.object.admin.rest.dto.v1_0.ObjectAction objectAction : objectViews) {
                objectViewResource.postObjectDefinitionObjectView(Long.valueOf(objectDefinitionId), (com.liferay.object.admin.rest.dto.v1_0.ObjectView)objectAction);
            }
        }
    }

    private com.liferay.object.admin.rest.dto.v1_0.ObjectDefinition _toObjectDefinition(final ObjectDefinition objectDefinition) {
        if (objectDefinition == null) {
            return null;
        }
        final String permissionName = ObjectDefinition.class.getName();
        String restContextPath = "";
        if (objectDefinition.isSystem()) {
            SystemObjectDefinitionMetadata systemObjectDefinitionMetadata = this._systemObjectDefinitionMetadataRegistry.getSystemObjectDefinitionMetadata(objectDefinition.getName());
            if (systemObjectDefinitionMetadata != null) {
                JaxRsApplicationDescriptor jaxRsApplicationDescriptor = systemObjectDefinitionMetadata.getJaxRsApplicationDescriptor();
                restContextPath = "/o/" + jaxRsApplicationDescriptor.getRESTContextPath();
            }
        } else {
            restContextPath = "/o" + objectDefinition.getRESTContextPath();
        }
        final String finalRESTContextPath = restContextPath;
        return new com.liferay.object.admin.rest.dto.v1_0.ObjectDefinition(){
            {
                this.accountEntryRestricted = objectDefinition.isAccountEntryRestricted();
                this.actions = HashMapBuilder.put((Object)"delete", () -> {
                    if (objectDefinition.isSystem()) {
                        return null;
                    }
                    return ObjectDefinitionResourceImpl.this.addAction("DELETE", "deleteObjectDefinition", permissionName, objectDefinition.getObjectDefinitionId());
                }).put((Object)"get", ObjectDefinitionResourceImpl.this.addAction("VIEW", "getObjectDefinition", permissionName, objectDefinition.getObjectDefinitionId())).put((Object)"permissions", ObjectDefinitionResourceImpl.this.addAction("PERMISSIONS", "patchObjectDefinition", permissionName, objectDefinition.getObjectDefinitionId())).put((Object)"publish", () -> {
                    if (objectDefinition.isApproved()) {
                        return null;
                    }
                    return ObjectDefinitionResourceImpl.this.addAction("UPDATE", "postObjectDefinitionPublish", permissionName, objectDefinition.getObjectDefinitionId());
                }).put((Object)"update", () -> {
                    if (objectDefinition.isSystem()) {
                        return null;
                    }
                    return ObjectDefinitionResourceImpl.this.addAction("UPDATE", "putObjectDefinition", permissionName, objectDefinition.getObjectDefinitionId());
                }).build();
                this.active = objectDefinition.isActive();
                this.dateCreated = objectDefinition.getCreateDate();
                this.dateModified = objectDefinition.getModifiedDate();
                this.enableCategorization = objectDefinition.getEnableCategorization();
                this.enableComments = objectDefinition.getEnableComments();
                this.enableObjectEntryHistory = objectDefinition.getEnableObjectEntryHistory();
                this.externalReferenceCode = objectDefinition.getExternalReferenceCode();
                this.id = objectDefinition.getObjectDefinitionId();
                this.label = com.liferay.object.util.LocalizedMapUtil.getLanguageIdMap((Map)objectDefinition.getLabelMap());
                this.name = objectDefinition.getShortName();
                this.objectActions = (com.liferay.object.admin.rest.dto.v1_0.ObjectAction[])ObjectDefinitionResourceImpl.this.transformToArray(ObjectDefinitionResourceImpl.this._objectActionLocalService.getObjectActions(objectDefinition.getObjectDefinitionId()), objectAction -> ObjectActionUtil.toObjectAction(null, (Locale)ObjectDefinitionResourceImpl.this.contextAcceptLanguage.getPreferredLocale(), (ObjectAction)objectAction), com.liferay.object.admin.rest.dto.v1_0.ObjectAction.class);
                this.objectFields = (com.liferay.object.admin.rest.dto.v1_0.ObjectField[])ObjectDefinitionResourceImpl.this.transformToArray(ObjectDefinitionResourceImpl.this._objectFieldLocalService.getObjectFields(objectDefinition.getObjectDefinitionId()), objectField -> ObjectDefinitionResourceImpl.this._objectFieldDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(false, null, null, null, ObjectDefinitionResourceImpl.this.contextAcceptLanguage.getPreferredLocale(), null, null), (ObjectField)objectField), com.liferay.object.admin.rest.dto.v1_0.ObjectField.class);
                this.objectLayouts = (ObjectLayout[])ObjectDefinitionResourceImpl.this.transformToArray(ObjectDefinitionResourceImpl.this._objectLayoutLocalService.getObjectLayouts(objectDefinition.getObjectDefinitionId()), objectLayout -> ObjectLayoutUtil.toObjectLayout(null, ObjectDefinitionResourceImpl.this._objectFieldLocalService, objectLayout), ObjectLayout.class);
                this.objectRelationships = (ObjectRelationship[])ObjectDefinitionResourceImpl.this.transformToArray(ObjectDefinitionResourceImpl.this._objectRelationshipLocalService.getObjectRelationships(objectDefinition.getObjectDefinitionId(), -1, -1), objectRelationship -> ObjectDefinitionResourceImpl.this._objectRelationshipDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(false, null, null, null, ObjectDefinitionResourceImpl.this.contextAcceptLanguage.getPreferredLocale(), null, null), (com.liferay.object.model.ObjectRelationship)objectRelationship), ObjectRelationship.class);
                this.objectViews = (com.liferay.object.admin.rest.dto.v1_0.ObjectView[])ObjectDefinitionResourceImpl.this.transformToArray(ObjectDefinitionResourceImpl.this._objectViewLocalService.getObjectViews(objectDefinition.getObjectDefinitionId()), objectView -> ObjectDefinitionResourceImpl.this._objectViewDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(false, null, null, null, ObjectDefinitionResourceImpl.this.contextAcceptLanguage.getPreferredLocale(), null, null), (ObjectView)objectView), com.liferay.object.admin.rest.dto.v1_0.ObjectView.class);
                this.panelCategoryKey = objectDefinition.getPanelCategoryKey();
                this.parameterRequired = finalRESTContextPath.matches(".*/\\{\\w+}/.*");
                this.pluralLabel = com.liferay.object.util.LocalizedMapUtil.getLanguageIdMap((Map)objectDefinition.getPluralLabelMap());
                this.portlet = objectDefinition.getPortlet();
                this.restContextPath = finalRESTContextPath;
                this.scope = objectDefinition.getScope();
                this.status = new Status(){
                    {
                        this.code = objectDefinition.getStatus();
                        this.label = WorkflowConstants.getStatusLabel((int)objectDefinition.getStatus());
                        this.label_i18n = ObjectDefinitionResourceImpl.this._language.get(LanguageResources.getResourceBundle((Locale)ObjectDefinitionResourceImpl.this.contextAcceptLanguage.getPreferredLocale()), WorkflowConstants.getStatusLabel((int)objectDefinition.getStatus()));
                    }
                };
                if (GetterUtil.getBoolean((String)PropsUtil.get((String)"feature.flag.LPS-135430"))) {
                    this.storageType = objectDefinition.getStorageType();
                }
                this.system = objectDefinition.isSystem();
                this.setAccountEntryRestrictedObjectFieldName(() -> {
                    ObjectField serviceBuilderObjectField = ObjectDefinitionResourceImpl.this._objectFieldLocalService.fetchObjectField(objectDefinition.getAccountEntryRestrictedObjectFieldId());
                    if (serviceBuilderObjectField == null) {
                        return "";
                    }
                    return serviceBuilderObjectField.getName();
                });
                this.setTitleObjectFieldName(() -> {
                    ObjectField serviceBuilderObjectField = ObjectDefinitionResourceImpl.this._objectFieldLocalService.fetchObjectField(objectDefinition.getTitleObjectFieldId());
                    if (serviceBuilderObjectField == null) {
                        return null;
                    }
                    return serviceBuilderObjectField.getName();
                });
            }
        };
    }
}

