/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.admin.rest.internal.dto.v1_0.util;

import com.liferay.object.admin.rest.dto.v1_0.ObjectLayoutBox;
import com.liferay.object.admin.rest.dto.v1_0.ObjectLayoutColumn;
import com.liferay.object.admin.rest.dto.v1_0.ObjectLayoutRow;
import com.liferay.object.admin.rest.dto.v1_0.ObjectLayoutTab;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectLayout;
import com.liferay.object.model.ObjectLayoutBox;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.util.LocalizedMapUtil;
import com.liferay.petra.function.transform.TransformUtil;
import java.util.Collection;
import java.util.Map;

public class ObjectLayoutUtil {
    public static com.liferay.object.admin.rest.dto.v1_0.ObjectLayout toObjectLayout(Map<String, Map<String, String>> actions, final ObjectFieldLocalService objectFieldLocalService, final ObjectLayout serviceBuilderObjectLayout) {
        if (serviceBuilderObjectLayout == null) {
            return null;
        }
        com.liferay.object.admin.rest.dto.v1_0.ObjectLayout objectLayout = new com.liferay.object.admin.rest.dto.v1_0.ObjectLayout(){
            {
                this.dateCreated = serviceBuilderObjectLayout.getCreateDate();
                this.dateModified = serviceBuilderObjectLayout.getModifiedDate();
                this.defaultObjectLayout = serviceBuilderObjectLayout.getDefaultObjectLayout();
                this.id = serviceBuilderObjectLayout.getObjectLayoutId();
                this.name = LocalizedMapUtil.getLanguageIdMap((Map)serviceBuilderObjectLayout.getNameMap());
                this.objectDefinitionId = serviceBuilderObjectLayout.getObjectDefinitionId();
                this.objectLayoutTabs = (ObjectLayoutTab[])TransformUtil.transformToArray((Collection)serviceBuilderObjectLayout.getObjectLayoutTabs(), objectLayoutTab -> ObjectLayoutUtil.toObjectLayoutTab(objectFieldLocalService, objectLayoutTab), ObjectLayoutTab.class);
            }
        };
        objectLayout.setActions(actions);
        return objectLayout;
    }

    public static ObjectLayoutTab toObjectLayoutTab(final ObjectFieldLocalService objectFieldLocalService, final com.liferay.object.model.ObjectLayoutTab objectLayoutTab) {
        if (objectLayoutTab == null) {
            return null;
        }
        return new ObjectLayoutTab(){
            {
                this.id = objectLayoutTab.getObjectLayoutTabId();
                this.name = LocalizedMapUtil.getLanguageIdMap((Map)objectLayoutTab.getNameMap());
                this.objectLayoutBoxes = (com.liferay.object.admin.rest.dto.v1_0.ObjectLayoutBox[])TransformUtil.transformToArray((Collection)objectLayoutTab.getObjectLayoutBoxes(), objectLayoutBox -> ObjectLayoutUtil._toObjectLayoutBox(objectFieldLocalService, objectLayoutBox), com.liferay.object.admin.rest.dto.v1_0.ObjectLayoutBox.class);
                this.objectRelationshipId = objectLayoutTab.getObjectRelationshipId();
                this.priority = objectLayoutTab.getPriority();
            }
        };
    }

    private static com.liferay.object.admin.rest.dto.v1_0.ObjectLayoutBox _toObjectLayoutBox(final ObjectFieldLocalService objectFieldLocalService, final ObjectLayoutBox objectLayoutBox) {
        if (objectLayoutBox == null) {
            return null;
        }
        return new com.liferay.object.admin.rest.dto.v1_0.ObjectLayoutBox(){
            {
                this.collapsable = objectLayoutBox.getCollapsable();
                this.id = objectLayoutBox.getObjectLayoutBoxId();
                this.name = LocalizedMapUtil.getLanguageIdMap((Map)objectLayoutBox.getNameMap());
                this.objectLayoutRows = (ObjectLayoutRow[])TransformUtil.transformToArray((Collection)objectLayoutBox.getObjectLayoutRows(), objectLayoutRow -> ObjectLayoutUtil._toObjectLayoutRow(objectFieldLocalService, objectLayoutRow), ObjectLayoutRow.class);
                this.priority = objectLayoutBox.getPriority();
                this.type = ObjectLayoutBox.Type.create((String)objectLayoutBox.getType());
            }
        };
    }

    private static ObjectLayoutColumn _toObjectLayoutColumn(ObjectFieldLocalService objectFieldLocalService, final com.liferay.object.model.ObjectLayoutColumn serviceBuilderObjectLayoutColumn) {
        if (serviceBuilderObjectLayoutColumn == null) {
            return null;
        }
        final ObjectField objectField = objectFieldLocalService.fetchObjectField(serviceBuilderObjectLayoutColumn.getObjectFieldId());
        return new ObjectLayoutColumn(){
            {
                this.id = serviceBuilderObjectLayoutColumn.getObjectLayoutColumnId();
                this.objectFieldName = objectField.getName();
                this.priority = serviceBuilderObjectLayoutColumn.getPriority();
                this.size = serviceBuilderObjectLayoutColumn.getSize();
            }
        };
    }

    private static ObjectLayoutRow _toObjectLayoutRow(final ObjectFieldLocalService objectFieldLocalService, final com.liferay.object.model.ObjectLayoutRow serviceBuilderObjectLayoutRow) {
        if (serviceBuilderObjectLayoutRow == null) {
            return null;
        }
        return new ObjectLayoutRow(){
            {
                this.id = serviceBuilderObjectLayoutRow.getObjectLayoutRowId();
                this.objectLayoutColumns = (ObjectLayoutColumn[])TransformUtil.transformToArray((Collection)serviceBuilderObjectLayoutRow.getObjectLayoutColumns(), objectLayoutColumn -> ObjectLayoutUtil._toObjectLayoutColumn(objectFieldLocalService, objectLayoutColumn), ObjectLayoutColumn.class);
                this.priority = serviceBuilderObjectLayoutRow.getPriority();
            }
        };
    }
}

