/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.admin.rest.internal.dto.v1_0.util;

import com.liferay.list.type.model.ListTypeDefinition;
import com.liferay.list.type.model.ListTypeEntry;
import com.liferay.list.type.service.ListTypeDefinitionLocalService;
import com.liferay.list.type.service.ListTypeEntryLocalService;
import com.liferay.object.admin.rest.dto.v1_0.ObjectFieldSetting;
import com.liferay.object.admin.rest.internal.dto.v1_0.util.ObjectFieldSettingUtil;
import com.liferay.object.model.ObjectField;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectFieldSettingLocalService;
import com.liferay.object.service.ObjectFilterLocalService;
import com.liferay.object.util.LocalizedMapUtil;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public class ObjectFieldUtil {
    private static final Log _log = LogFactoryUtil.getLog(ObjectFieldUtil.class);

    public static long addListTypeDefinition(long companyId, ListTypeDefinitionLocalService listTypeDefinitionLocalService, ListTypeEntryLocalService listTypeEntryLocalService, com.liferay.object.admin.rest.dto.v1_0.ObjectField objectField, long userId) throws Exception {
        if (Validator.isNull((String)objectField.getListTypeDefinitionExternalReferenceCode())) {
            return 0L;
        }
        ListTypeDefinition listTypeDefinition = listTypeDefinitionLocalService.fetchListTypeDefinitionByExternalReferenceCode(objectField.getListTypeDefinitionExternalReferenceCode(), companyId);
        if (listTypeDefinition == null) {
            listTypeDefinition = listTypeDefinitionLocalService.addListTypeDefinition(objectField.getListTypeDefinitionExternalReferenceCode(), userId);
        }
        if (objectField.getObjectFieldSettings() != null) {
            ObjectFieldUtil._addListTypeEntries(listTypeDefinition, listTypeEntryLocalService, objectField, userId);
        }
        return listTypeDefinition.getListTypeDefinitionId();
    }

    public static String getDBType(String dbType, String type) {
        if (Validator.isNull((String)dbType) && Validator.isNotNull((String)type)) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"The type property is deprecated. Use the DBType property instead.");
            }
            return type;
        }
        return dbType;
    }

    public static long getListTypeDefinitionId(long companyId, ListTypeDefinitionLocalService listTypeDefinitionLocalService, com.liferay.object.admin.rest.dto.v1_0.ObjectField objectField) {
        if (!StringUtil.equals((String)objectField.getBusinessTypeAsString(), (String)"MultiselectPicklist") && !StringUtil.equals((String)objectField.getBusinessTypeAsString(), (String)"Picklist")) {
            return 0L;
        }
        long listTypeDefinitionId = GetterUtil.getLong((Object)objectField.getListTypeDefinitionId());
        if (listTypeDefinitionId != 0L || Validator.isNull((String)objectField.getListTypeDefinitionExternalReferenceCode())) {
            return listTypeDefinitionId;
        }
        ListTypeDefinition listTypeDefinition = listTypeDefinitionLocalService.fetchListTypeDefinitionByExternalReferenceCode(objectField.getListTypeDefinitionExternalReferenceCode(), companyId);
        if (listTypeDefinition == null) {
            return 0L;
        }
        return listTypeDefinition.getListTypeDefinitionId();
    }

    public static ObjectField toObjectField(ListTypeDefinitionLocalService listTypeDefinitionLocalService, com.liferay.object.admin.rest.dto.v1_0.ObjectField objectField, ObjectFieldLocalService objectFieldLocalService, ObjectFieldSettingLocalService objectFieldSettingLocalService, ObjectFilterLocalService objectFilterLocalService) {
        if (!GetterUtil.getBoolean((String)PropsUtil.get((String)"feature.flag.LPS-164948")) && Objects.equals(objectField.getBusinessTypeAsString(), "Formula")) {
            throw new UnsupportedOperationException();
        }
        ObjectField serviceBuilderObjectField = objectFieldLocalService.createObjectField(0L);
        serviceBuilderObjectField.setExternalReferenceCode(objectField.getExternalReferenceCode());
        long listTypeDefinitionId = ObjectFieldUtil.getListTypeDefinitionId(serviceBuilderObjectField.getCompanyId(), listTypeDefinitionLocalService, objectField);
        serviceBuilderObjectField.setListTypeDefinitionId(listTypeDefinitionId);
        serviceBuilderObjectField.setBusinessType(objectField.getBusinessTypeAsString());
        serviceBuilderObjectField.setDBType(ObjectFieldUtil.getDBType(objectField.getDBTypeAsString(), objectField.getTypeAsString()));
        if (Validator.isNotNull((String)objectField.getDefaultValue())) {
            serviceBuilderObjectField.setDefaultValue(objectField.getDefaultValue());
        }
        serviceBuilderObjectField.setIndexed(GetterUtil.getBoolean((Object)objectField.getIndexed()));
        serviceBuilderObjectField.setIndexedAsKeyword(GetterUtil.getBoolean((Object)objectField.getIndexedAsKeyword()));
        serviceBuilderObjectField.setIndexedLanguageId(objectField.getIndexedLanguageId());
        serviceBuilderObjectField.setLabelMap(LocalizedMapUtil.getLocalizedMap((Map)objectField.getLabel()));
        serviceBuilderObjectField.setName(objectField.getName());
        serviceBuilderObjectField.setObjectFieldSettings(TransformUtil.transformToList((Object[])objectField.getObjectFieldSettings(), objectFieldSetting -> ObjectFieldSettingUtil.toObjectFieldSetting(objectField.getBusinessTypeAsString(), listTypeDefinitionId, objectFieldSetting, objectFieldSettingLocalService, objectFilterLocalService)));
        serviceBuilderObjectField.setRequired(GetterUtil.getBoolean((Object)objectField.getRequired()));
        if (Validator.isNotNull((Object)objectField.getState())) {
            serviceBuilderObjectField.setState(objectField.getState().booleanValue());
        }
        serviceBuilderObjectField.setSystem(GetterUtil.getBoolean((Object)objectField.getSystem()));
        return serviceBuilderObjectField;
    }

    private static void _addListTypeEntries(ListTypeDefinition listTypeDefinition, ListTypeEntryLocalService listTypeEntryLocalService, com.liferay.object.admin.rest.dto.v1_0.ObjectField objectField, long userId) throws Exception {
        for (ObjectFieldSetting objectFieldSetting : objectField.getObjectFieldSettings()) {
            if (!StringUtil.equals((String)objectFieldSetting.getName(), (String)"stateFlow")) continue;
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)JSONFactoryUtil.looseSerializeDeep((Object)objectFieldSetting.getValue()));
            JSONArray objectStatesJSONArray = jsonObject.getJSONArray("objectStates");
            for (int i = 0; i < objectStatesJSONArray.length(); ++i) {
                JSONObject objectStateJSONObject = objectStatesJSONArray.getJSONObject(i);
                String key = objectStateJSONObject.getString("key");
                ListTypeEntry listTypeEntry = listTypeEntryLocalService.fetchListTypeEntry(listTypeDefinition.getListTypeDefinitionId(), key);
                if (listTypeEntry != null) continue;
                listTypeEntryLocalService.addListTypeEntry(userId, listTypeDefinition.getListTypeDefinitionId(), key, Collections.singletonMap(LocaleUtil.getDefault(), key));
            }
        }
    }
}

