/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.admin.rest.internal.dto.v1_0.converter;

import com.liferay.object.admin.rest.dto.v1_0.ObjectView;
import com.liferay.object.admin.rest.dto.v1_0.ObjectViewColumn;
import com.liferay.object.admin.rest.dto.v1_0.ObjectViewFilterColumn;
import com.liferay.object.admin.rest.dto.v1_0.ObjectViewSortColumn;
import com.liferay.object.field.filter.parser.ObjectFieldFilterContext;
import com.liferay.object.field.filter.parser.ObjectFieldFilterContributor;
import com.liferay.object.field.filter.parser.ObjectFieldFilterContributorRegistry;
import com.liferay.object.model.ObjectViewSortColumn;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.util.LocalizedMapUtil;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.object.model.ObjectView"}, service={DTOConverter.class, ObjectViewDTOConverter.class})
public class ObjectViewDTOConverter
implements DTOConverter<com.liferay.object.model.ObjectView, ObjectView> {
    @Reference
    private ObjectFieldFilterContributorRegistry _objectFieldFilterContributorRegistry;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;

    public String getContentType() {
        return ObjectView.class.getSimpleName();
    }

    public ObjectView toDTO(final DTOConverterContext dtoConverterContext, final com.liferay.object.model.ObjectView objectView) throws Exception {
        if (objectView == null) {
            return null;
        }
        return new ObjectView(){
            {
                this.actions = dtoConverterContext.getActions();
                this.dateCreated = objectView.getCreateDate();
                this.dateModified = objectView.getModifiedDate();
                this.defaultObjectView = objectView.getDefaultObjectView();
                this.id = objectView.getObjectViewId();
                this.name = LocalizedMapUtil.getLanguageIdMap((Map)objectView.getNameMap());
                this.objectDefinitionId = objectView.getObjectDefinitionId();
                this.objectViewColumns = (ObjectViewColumn[])TransformUtil.transformToArray((Collection)objectView.getObjectViewColumns(), objectViewColumn -> ObjectViewDTOConverter.this._toObjectViewColumn(objectViewColumn), ObjectViewColumn.class);
                this.objectViewFilterColumns = (ObjectViewFilterColumn[])TransformUtil.transformToArray((Collection)objectView.getObjectViewFilterColumns(), objectViewFilterColumn -> ObjectViewDTOConverter.this._toObjectViewFilterColumn(dtoConverterContext.getLocale(), objectView.getObjectDefinitionId(), objectViewFilterColumn), ObjectViewFilterColumn.class);
                this.objectViewSortColumns = (com.liferay.object.admin.rest.dto.v1_0.ObjectViewSortColumn[])TransformUtil.transformToArray((Collection)objectView.getObjectViewSortColumns(), objectViewSortColumn -> ObjectViewDTOConverter.this._toObjectViewSortColumn(objectViewSortColumn), com.liferay.object.admin.rest.dto.v1_0.ObjectViewSortColumn.class);
            }
        };
    }

    private ObjectViewColumn _toObjectViewColumn(final com.liferay.object.model.ObjectViewColumn objectViewColumn) {
        if (objectViewColumn == null) {
            return null;
        }
        return new ObjectViewColumn(){
            {
                this.id = objectViewColumn.getObjectViewColumnId();
                this.label = LocalizedMapUtil.getLanguageIdMap((Map)objectViewColumn.getLabelMap());
                this.objectFieldName = objectViewColumn.getObjectFieldName();
                this.priority = objectViewColumn.getPriority();
            }
        };
    }

    private ObjectViewFilterColumn _toObjectViewFilterColumn(Locale locale, long objectDefinitionId, final com.liferay.object.model.ObjectViewFilterColumn serviceBuilderObjectViewFilterColumn) {
        if (serviceBuilderObjectViewFilterColumn == null) {
            return null;
        }
        ObjectViewFilterColumn objectViewFilterColumn = new ObjectViewFilterColumn(){
            {
                this.id = serviceBuilderObjectViewFilterColumn.getObjectViewFilterColumnId();
                this.objectFieldName = serviceBuilderObjectViewFilterColumn.getObjectFieldName();
            }
        };
        if (Validator.isNull((String)serviceBuilderObjectViewFilterColumn.getFilterType())) {
            return objectViewFilterColumn;
        }
        objectViewFilterColumn.setFilterType(ObjectViewFilterColumn.FilterType.create((String)serviceBuilderObjectViewFilterColumn.getFilterType()));
        objectViewFilterColumn.setJson(serviceBuilderObjectViewFilterColumn.getJSON());
        objectViewFilterColumn.setValueSummary(() -> {
            ObjectFieldFilterContributor objectFieldFilterContributor = this._objectFieldFilterContributorRegistry.getObjectFieldFilterContributor(new ObjectFieldFilterContext(locale, objectDefinitionId, serviceBuilderObjectViewFilterColumn));
            return objectFieldFilterContributor.toValueSummary();
        });
        return objectViewFilterColumn;
    }

    private com.liferay.object.admin.rest.dto.v1_0.ObjectViewSortColumn _toObjectViewSortColumn(final ObjectViewSortColumn objectViewSortColumn) {
        if (objectViewSortColumn == null) {
            return null;
        }
        return new com.liferay.object.admin.rest.dto.v1_0.ObjectViewSortColumn(){
            {
                this.id = objectViewSortColumn.getObjectViewSortColumnId();
                this.objectFieldName = objectViewSortColumn.getObjectFieldName();
                this.priority = objectViewSortColumn.getPriority();
                this.sortOrder = ObjectViewSortColumn.SortOrder.create((String)objectViewSortColumn.getSortOrder());
            }
        };
    }
}

