/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.web.internal.portlet.action;

import com.liferay.document.library.util.DLURLHelper;
import com.liferay.oauth2.provider.exception.NoSuchOAuth2ApplicationException;
import com.liferay.oauth2.provider.model.OAuth2Application;
import com.liferay.oauth2.provider.model.OAuth2ApplicationScopeAliases;
import com.liferay.oauth2.provider.scope.liferay.ApplicationDescriptorLocator;
import com.liferay.oauth2.provider.scope.liferay.ScopeDescriptorLocator;
import com.liferay.oauth2.provider.scope.liferay.ScopeLocator;
import com.liferay.oauth2.provider.service.OAuth2ApplicationScopeAliasesLocalService;
import com.liferay.oauth2.provider.service.OAuth2ApplicationService;
import com.liferay.oauth2.provider.service.OAuth2ScopeGrantLocalService;
import com.liferay.oauth2.provider.web.internal.AssignableScopes;
import com.liferay.oauth2.provider.web.internal.display.context.OAuth2AuthorizePortletDisplayContext;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCRenderCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Stream;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_oauth2_provider_web_internal_portlet_OAuth2AuthorizePortlet", "mvc.command.name=/", "mvc.command.name=/authorize/view_authorization_request"}, service={MVCRenderCommand.class})
public class ViewAuthorizationRequestMVCRenderCommand
implements MVCRenderCommand {
    private static final Log _log = LogFactoryUtil.getLog(ViewAuthorizationRequestMVCRenderCommand.class);
    @Reference
    private ApplicationDescriptorLocator _applicationDescriptorLocator;
    @Reference
    private DLURLHelper _dlURLHelper;
    @Reference
    private OAuth2ApplicationScopeAliasesLocalService _oAuth2ApplicationScopeAliasesLocalService;
    @Reference
    private OAuth2ApplicationService _oAuth2ApplicationService;
    @Reference
    private OAuth2ScopeGrantLocalService _oAuth2ScopeGrantLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private ScopeDescriptorLocator _scopeDescriptorLocator;
    @Reference
    private ScopeLocator _scopeLocator;

    public String render(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException {
        ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        HttpServletRequest httpServletRequest = this._portal.getOriginalServletRequest(this._portal.getHttpServletRequest((PortletRequest)renderRequest));
        Map<String, String> oAuth2Parameters = this.getOAuth2Parameters(httpServletRequest);
        String error = oAuth2Parameters.get("error");
        if (StringUtil.equals((String)error, (String)"invalid_client")) {
            SessionErrors.add((PortletRequest)renderRequest, (String)"clientIdInvalid");
            return "/authorize/error.jsp";
        }
        String redirectURI = oAuth2Parameters.get("redirect_uri");
        if (Validator.isBlank((String)redirectURI)) {
            SessionErrors.add((PortletRequest)renderRequest, (String)"redirectURIMissing");
            return "/authorize/error.jsp";
        }
        String clientId = oAuth2Parameters.get("client_id");
        try {
            OAuth2Application oAuth2Application = this._oAuth2ApplicationService.getOAuth2Application(themeDisplay.getCompanyId(), clientId);
            OAuth2AuthorizePortletDisplayContext oAuth2AuthorizePortletDisplayContext = new OAuth2AuthorizePortletDisplayContext(themeDisplay, this._dlURLHelper);
            oAuth2AuthorizePortletDisplayContext.setOAuth2Application(oAuth2Application);
            oAuth2AuthorizePortletDisplayContext.setOAuth2Parameters(oAuth2Parameters);
            AssignableScopes assignableScopes = new AssignableScopes(this._applicationDescriptorLocator, themeDisplay.getLocale(), this._scopeDescriptorLocator);
            if (oAuth2Application.getOAuth2ApplicationScopeAliasesId() > 0L) {
                OAuth2ApplicationScopeAliases oAuth2ApplicationScopeAliases = this._oAuth2ApplicationScopeAliasesLocalService.getOAuth2ApplicationScopeAliases(oAuth2Application.getOAuth2ApplicationScopeAliasesId());
                String[] requestedScopeAliases = StringUtil.split((String)oAuth2Parameters.get("scope"), (String)" ");
                this.populateAssignableScopes(assignableScopes, oAuth2ApplicationScopeAliases, requestedScopeAliases);
            }
            oAuth2AuthorizePortletDisplayContext.setAssignableScopes(assignableScopes);
            renderRequest.setAttribute("OAUTH2_AUTHORIZE_PORTLET_DISPLAY_CONTEXT", (Object)oAuth2AuthorizePortletDisplayContext);
        }
        catch (NoSuchOAuth2ApplicationException nsoaae) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)nsoaae, (Throwable)nsoaae);
            }
            SessionErrors.add((PortletRequest)renderRequest, (String)"clientIdInvalid");
            return "/authorize/error.jsp";
        }
        catch (PrincipalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            SessionErrors.add((PortletRequest)renderRequest, ((Object)((Object)pe)).getClass());
            return "/authorize/error.jsp";
        }
        catch (PortalException pe) {
            throw new PortletException((Throwable)pe);
        }
        return "/authorize/authorize.jsp";
    }

    protected Map<String, String> getOAuth2Parameters(HttpServletRequest httpServletRequest) {
        HashMap<String, String> oAuth2Parameters = new HashMap<String, String>();
        Enumeration names = httpServletRequest.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.startsWith("oauth2_")) continue;
            oAuth2Parameters.put(name.substring("oauth2_".length()), ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)name));
        }
        return oAuth2Parameters;
    }

    protected void populateAssignableScopes(AssignableScopes assignableScopes, OAuth2ApplicationScopeAliases oAuth2ApplicationScopeAliases, String[] requestedScopeAliases) {
        HashSet<String> requestedScopeAliasesSet = new HashSet<String>(Arrays.asList(requestedScopeAliases));
        Collection oAuth2ScopeGrants = this._oAuth2ScopeGrantLocalService.getOAuth2ScopeGrants(oAuth2ApplicationScopeAliases.getOAuth2ApplicationScopeAliasesId(), -1, -1, null);
        Stream stream = oAuth2ScopeGrants.stream();
        Collection liferayOAuth2Scopes = this._scopeLocator.getLiferayOAuth2Scopes(oAuth2ApplicationScopeAliases.getCompanyId());
        stream.filter(oAuth2ScopeGrant -> !Collections.disjoint(oAuth2ScopeGrant.getScopeAliasesList(), requestedScopeAliasesSet)).map(oAuth2ScopeGrant -> this._scopeLocator.getLiferayOAuth2Scope(oAuth2ScopeGrant.getCompanyId(), oAuth2ScopeGrant.getApplicationName(), oAuth2ScopeGrant.getScope())).filter(liferayOAuth2Scopes::contains).forEach(assignableScopes::addLiferayOAuth2Scope);
    }
}

