/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.web.internal.display.context;

import com.liferay.document.library.kernel.service.DLAppLocalServiceUtil;
import com.liferay.document.library.util.DLURLHelper;
import com.liferay.oauth2.provider.model.OAuth2Application;
import com.liferay.oauth2.provider.service.OAuth2ApplicationService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import javax.portlet.PortletRequest;

public abstract class BaseOAuth2PortletDisplayContext {
    protected DLURLHelper dlURLHelper;
    protected OAuth2Application oAuth2Application;
    protected OAuth2ApplicationService oAuth2ApplicationService;
    protected PortletRequest portletRequest;
    protected ThemeDisplay themeDisplay;
    private static final Log _log = LogFactoryUtil.getLog(BaseOAuth2PortletDisplayContext.class);

    public String getDefaultIconURL() {
        return this.themeDisplay.getPathThemeImages() + "/common/portlet.png";
    }

    public OAuth2Application getOAuth2Application() throws PortalException {
        if (this.oAuth2Application != null) {
            return this.oAuth2Application;
        }
        long oAuth2ApplicationId = ParamUtil.getLong((PortletRequest)this.portletRequest, (String)"oAuth2ApplicationId", (long)0L);
        if (oAuth2ApplicationId > 0L) {
            this.oAuth2Application = this.oAuth2ApplicationService.getOAuth2Application(oAuth2ApplicationId);
        }
        return this.oAuth2Application;
    }

    public String getThumbnailURL() throws Exception {
        return this.getThumbnailURL(this.getOAuth2Application());
    }

    public String getThumbnailURL(OAuth2Application oAuth2Application) throws Exception {
        if (oAuth2Application.getIconFileEntryId() <= 0L) {
            return this.getDefaultIconURL();
        }
        FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntry((long)oAuth2Application.getIconFileEntryId());
        return this.dlURLHelper.getThumbnailSrc(fileEntry, this.themeDisplay);
    }

    public boolean hasAddApplicationPermission() {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        return permissionChecker.hasPermission(0L, "com.liferay.oauth2.provider", "com.liferay.oauth2.provider", "ADD_APPLICATION");
    }

    public boolean hasDeletePermission(OAuth2Application oAuth2Application) {
        return this.hasPermission(oAuth2Application, "DELETE");
    }

    public boolean hasPermission(OAuth2Application oAuth2Application, String actionId) {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker.hasOwnerPermission(oAuth2Application.getCompanyId(), OAuth2Application.class.getName(), oAuth2Application.getOAuth2ApplicationId(), oAuth2Application.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(0L, OAuth2Application.class.getName(), oAuth2Application.getOAuth2ApplicationId(), actionId);
    }

    public boolean hasPermissionsPermission(OAuth2Application oAuth2Application) {
        return this.hasPermission(oAuth2Application, "PERMISSIONS");
    }

    public boolean hasRevokeTokenPermission(OAuth2Application oAuth2Application) {
        return this.hasPermission(oAuth2Application, "REVOKE_TOKEN");
    }

    public boolean hasUpdatePermission(OAuth2Application oAuth2Application) {
        return this.hasPermission(oAuth2Application, "UPDATE");
    }

    public boolean hasViewGrantedAuthorizationsPermission() {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        try {
            return PortletPermissionUtil.contains((PermissionChecker)permissionChecker, (String)"com_liferay_oauth2_provider_web_internal_portlet_OAuth2AdminPortlet", (String)"VIEW_GRANTED_AUTHORIZATIONS");
        }
        catch (PortalException pe) {
            _log.error((Object)pe, (Throwable)pe);
            return false;
        }
    }
}

