/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.web.internal.portlet.action;

import com.liferay.document.library.util.DLURLHelper;
import com.liferay.oauth2.provider.model.OAuth2Authorization;
import com.liferay.oauth2.provider.scope.liferay.ApplicationDescriptorLocator;
import com.liferay.oauth2.provider.scope.liferay.ScopeDescriptorLocator;
import com.liferay.oauth2.provider.scope.liferay.ScopeLocator;
import com.liferay.oauth2.provider.service.OAuth2ApplicationScopeAliasesLocalService;
import com.liferay.oauth2.provider.service.OAuth2ApplicationService;
import com.liferay.oauth2.provider.service.OAuth2AuthorizationService;
import com.liferay.oauth2.provider.service.OAuth2ScopeGrantLocalService;
import com.liferay.oauth2.provider.web.internal.AssignableScopes;
import com.liferay.oauth2.provider.web.internal.display.context.OAuth2ConnectedApplicationsPortletDisplayContext;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCRenderCommand;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_oauth2_provider_web_internal_portlet_OAuth2ConnectedApplicationsPortlet", "mvc.command.name=/", "mvc.command.name=/connected_applications/view"}, service={MVCRenderCommand.class})
public class ViewConnectedApplicationsMVCRenderCommand
implements MVCRenderCommand {
    private static final Log _log = LogFactoryUtil.getLog(ViewConnectedApplicationsMVCRenderCommand.class);
    @Reference
    private ApplicationDescriptorLocator _applicationDescriptorLocator;
    @Reference
    private DLURLHelper _dlURLHelper;
    @Reference
    private OAuth2ApplicationScopeAliasesLocalService _oAuth2ApplicationScopeAliasesLocalService;
    @Reference
    private OAuth2ApplicationService _oAuth2ApplicationService;
    @Reference
    private OAuth2AuthorizationService _oAuth2AuthorizationService;
    @Reference
    private OAuth2ScopeGrantLocalService _oAuth2ScopeGrantLocalService;
    @Reference
    private ScopeDescriptorLocator _scopeDescriptorLocator;
    @Reference
    private ScopeLocator _scopeLocator;

    public String render(RenderRequest renderRequest, RenderResponse renderResponse) {
        ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        List userOAuth2Authorizations = Collections.emptyList();
        try {
            userOAuth2Authorizations = this._oAuth2AuthorizationService.getUserOAuth2Authorizations(-1, -1, null);
        }
        catch (PortalException pe) {
            _log.error((Object)"Unable to load user OAuth 2 authorizations", (Throwable)pe);
        }
        long oAuth2AuthorizationId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"oAuth2AuthorizationId");
        if (!ListUtil.exists((List)userOAuth2Authorizations, userOAuth2Authorization -> userOAuth2Authorization.getOAuth2AuthorizationId() == oAuth2AuthorizationId)) {
            OAuth2ConnectedApplicationsPortletDisplayContext oAuth2ConnectedApplicationsPortletDisplayContext = new OAuth2ConnectedApplicationsPortletDisplayContext((PortletRequest)renderRequest, this._dlURLHelper);
            renderRequest.setAttribute("OAUTH2_CONNECTED_APPLICATIONS_PORTLET_DISPLAY_CONTEXT", (Object)oAuth2ConnectedApplicationsPortletDisplayContext);
            return "/connected_applications/view.jsp";
        }
        OAuth2Authorization oAuth2Authorization = null;
        for (OAuth2Authorization userOAuth2Authorization2 : userOAuth2Authorizations) {
            if (userOAuth2Authorization2.getOAuth2AuthorizationId() != oAuth2AuthorizationId) continue;
            oAuth2Authorization = userOAuth2Authorization2;
            break;
        }
        AssignableScopes assignableScopes = new AssignableScopes(this._applicationDescriptorLocator, themeDisplay.getLocale(), this._scopeDescriptorLocator);
        Collection oAuth2ScopeGrants = this._oAuth2ScopeGrantLocalService.getOAuth2ScopeGrants(oAuth2Authorization.getOAuth2ApplicationScopeAliasesId(), -1, -1, null);
        Stream stream = oAuth2ScopeGrants.stream();
        stream.map(oAuth2ScopeGrant -> this._scopeLocator.getLiferayOAuth2Scope(oAuth2ScopeGrant.getCompanyId(), oAuth2ScopeGrant.getApplicationName(), oAuth2ScopeGrant.getScope())).forEach(assignableScopes::addLiferayOAuth2Scope);
        OAuth2ConnectedApplicationsPortletDisplayContext oAuth2ConnectedApplicationsPortletDisplayContext = new OAuth2ConnectedApplicationsPortletDisplayContext(assignableScopes, (PortletRequest)renderRequest, this._oAuth2ApplicationService, oAuth2Authorization, this._dlURLHelper);
        renderRequest.setAttribute("OAUTH2_CONNECTED_APPLICATIONS_PORTLET_DISPLAY_CONTEXT", (Object)oAuth2ConnectedApplicationsPortletDisplayContext);
        return "/connected_applications/view_application.jsp";
    }
}

