/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.web.internal.portlet.action;

import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.util.DLURLHelper;
import com.liferay.oauth2.provider.configuration.OAuth2ProviderConfiguration;
import com.liferay.oauth2.provider.constants.ClientProfile;
import com.liferay.oauth2.provider.constants.GrantType;
import com.liferay.oauth2.provider.model.OAuth2Application;
import com.liferay.oauth2.provider.service.OAuth2ApplicationScopeAliasesLocalService;
import com.liferay.oauth2.provider.service.OAuth2ApplicationService;
import com.liferay.oauth2.provider.util.OAuth2SecureRandomGenerator;
import com.liferay.oauth2.provider.web.internal.display.context.OAuth2AdminPortletDisplayContext;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.oauth2.provider.configuration.OAuth2ProviderConfiguration"}, property={"javax.portlet.name=com_liferay_oauth2_provider_web_internal_portlet_OAuth2AdminPortlet", "mvc.command.name=/admin/update_oauth2_application"}, service={MVCActionCommand.class})
public class UpdateOAuth2ApplicationMVCActionCommand
implements MVCActionCommand {
    private static final Log _log = LogFactoryUtil.getLog(UpdateOAuth2ApplicationMVCActionCommand.class);
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private DLURLHelper _dlurlHelper;
    @Reference
    private OAuth2ApplicationScopeAliasesLocalService _oAuth2ApplicationScopeAliasesLocalService;
    @Reference
    private OAuth2ApplicationService _oAuth2ApplicationService;
    private OAuth2ProviderConfiguration _oAuth2ProviderConfiguration;

    public boolean processAction(ActionRequest request, ActionResponse response) {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long oAuth2ApplicationId = ParamUtil.getLong((PortletRequest)request, (String)"oAuth2ApplicationId");
        int clientProfileId = ParamUtil.getInteger((PortletRequest)request, (String)"clientProfile");
        ClientProfile clientProfile = this.getClientProfile(clientProfileId);
        PortletPreferences portletPreferences = request.getPreferences();
        OAuth2AdminPortletDisplayContext oAuth2AdminPortletDisplayContext = new OAuth2AdminPortletDisplayContext(this._oAuth2ApplicationService, this._oAuth2ApplicationScopeAliasesLocalService, this._oAuth2ProviderConfiguration, (PortletRequest)request, null, this._dlurlHelper);
        String[] oAuth2Features = oAuth2AdminPortletDisplayContext.getOAuth2Features(portletPreferences);
        ArrayList<String> featuresList = new ArrayList<String>();
        for (String feature : oAuth2Features) {
            if (!ParamUtil.getBoolean((PortletRequest)request, (String)("feature-" + feature), (boolean)false)) continue;
            featuresList.add(feature);
        }
        ArrayList<GrantType> allowedGrantTypesList = new ArrayList<GrantType>();
        List<GrantType> grantTypes = oAuth2AdminPortletDisplayContext.getGrantTypes(portletPreferences);
        for (GrantType grantType : clientProfile.grantTypes()) {
            if (!grantTypes.contains(grantType) || !ParamUtil.getBoolean((PortletRequest)request, (String)("grant-" + grantType.name()))) continue;
            allowedGrantTypesList.add(grantType);
        }
        String clientId = ParamUtil.get((PortletRequest)request, (String)"clientId", (String)"");
        String clientSecret = ParamUtil.get((PortletRequest)request, (String)"clientSecret", (String)"");
        String description = ParamUtil.get((PortletRequest)request, (String)"description", (String)"");
        String homePageURL = ParamUtil.get((PortletRequest)request, (String)"homePageURL", (String)"");
        String name = ParamUtil.get((PortletRequest)request, (String)"name", (String)"");
        String privacyPolicyURL = ParamUtil.get((PortletRequest)request, (String)"privacyPolicyURL", (String)"");
        List<String> redirectURIsList = Arrays.asList(StringUtil.splitLines((String)ParamUtil.get((PortletRequest)request, (String)"redirectURIs", (String)"")));
        List scopeAliasesList = Collections.emptyList();
        long clientCredentialUserId = ParamUtil.get((PortletRequest)request, (String)"clientCredentialUserId", (long)themeDisplay.getUserId());
        try {
            ServiceContext serviceContext = ServiceContextFactory.getInstance((String)OAuth2Application.class.getName(), (PortletRequest)request);
            if (oAuth2ApplicationId == 0L) {
                if (Validator.isBlank((String)clientId)) {
                    clientId = OAuth2SecureRandomGenerator.generateClientId();
                }
                for (GrantType grantType : allowedGrantTypesList) {
                    if (grantType.isSupportsPublicClients()) continue;
                    clientSecret = OAuth2SecureRandomGenerator.generateClientSecret();
                }
                OAuth2Application oAuth2Application = this._oAuth2ApplicationService.addOAuth2Application(allowedGrantTypesList, clientCredentialUserId, clientId, clientProfile.id(), clientSecret, description, featuresList, homePageURL, 0L, name, privacyPolicyURL, redirectURIsList, scopeAliasesList, serviceContext);
                response.setRenderParameter("oAuth2ApplicationId", String.valueOf(oAuth2Application.getOAuth2ApplicationId()));
            } else {
                OAuth2Application oAuth2Application = this._oAuth2ApplicationService.getOAuth2Application(oAuth2ApplicationId);
                long iconFileEntryId = oAuth2Application.getIconFileEntryId();
                long oAuth2ApplicationScopeAliasesId = oAuth2Application.getOAuth2ApplicationScopeAliasesId();
                this._oAuth2ApplicationService.updateOAuth2Application(oAuth2ApplicationId, allowedGrantTypesList, clientCredentialUserId, clientId, clientProfile.id(), clientSecret, description, featuresList, homePageURL, iconFileEntryId, name, privacyPolicyURL, redirectURIsList, oAuth2ApplicationScopeAliasesId, serviceContext);
                long fileEntryId = ParamUtil.getLong((PortletRequest)request, (String)"fileEntryId");
                if (ParamUtil.getBoolean((PortletRequest)request, (String)"deleteLogo")) {
                    this._oAuth2ApplicationService.updateIcon(oAuth2ApplicationId, null);
                } else if (fileEntryId > 0L) {
                    FileEntry fileEntry = this._dlAppService.getFileEntry(fileEntryId);
                    InputStream inputStream = fileEntry.getContentStream();
                    this._oAuth2ApplicationService.updateIcon(oAuth2ApplicationId, inputStream);
                    this._dlAppService.deleteFileEntry(fileEntryId);
                }
            }
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            Class<?> peClass = ((Object)((Object)pe)).getClass();
            SessionErrors.add((PortletRequest)request, (String)peClass.getName(), (Object)((Object)pe));
        }
        String backURL = ParamUtil.get((PortletRequest)request, (String)"backURL", (String)"");
        response.setRenderParameter("redirect", backURL);
        return true;
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._oAuth2ProviderConfiguration = (OAuth2ProviderConfiguration)ConfigurableUtil.createConfigurable(OAuth2ProviderConfiguration.class, properties);
    }

    protected ClientProfile getClientProfile(int clientProfileId) {
        for (ClientProfile clientProfile : ClientProfile.values()) {
            if (clientProfile.id() != clientProfileId) continue;
            return clientProfile;
        }
        throw new IllegalArgumentException("No client profile found for " + clientProfileId);
    }
}

