/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.web.internal.display.context;

import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.UserPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.usersadmin.search.UserSearch;
import com.liferay.portlet.usersadmin.search.UserSearchTerms;
import java.util.LinkedHashMap;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowStateException;
import javax.servlet.http.HttpServletRequest;

public class SelectUsersDisplayContext {
    private static final Log _log = LogFactoryUtil.getLog(SelectUsersDisplayContext.class);
    private String _displayStyle;
    private String _eventName;
    private Long _groupId;
    private final HttpServletRequest _httpServletRequest;
    private String _keywords;
    private String _orderByCol;
    private String _orderByType;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;
    private final ThemeDisplay _themeDisplay;
    private UserSearch _userSearch;

    public SelectUsersDisplayContext(HttpServletRequest httpServletRequest, RenderRequest renderRequest, RenderResponse renderResponse) {
        this._httpServletRequest = httpServletRequest;
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
        this._themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public String getDisplayStyle() {
        if (Validator.isNotNull((String)this._displayStyle)) {
            return this._displayStyle;
        }
        this._displayStyle = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"displayStyle", (String)"list");
        return this._displayStyle;
    }

    public String getEventName() {
        if (Validator.isNotNull((String)this._eventName)) {
            return this._eventName;
        }
        this._eventName = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"eventName", (String)(this._renderResponse.getNamespace() + "selectUsers"));
        return this._eventName;
    }

    public long getGroupId() {
        if (this._groupId != null) {
            return this._groupId;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._groupId = ParamUtil.getLong((HttpServletRequest)this._httpServletRequest, (String)"groupId", (long)themeDisplay.getSiteGroupIdOrLiveGroupId());
        return this._groupId;
    }

    public String getKeywords() {
        if (this._keywords != null) {
            return this._keywords;
        }
        this._keywords = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"keywords");
        return this._keywords;
    }

    public String getOrderByCol() {
        if (this._orderByCol != null) {
            return this._orderByCol;
        }
        this._orderByCol = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"orderByCol", (String)"first-name");
        return this._orderByCol;
    }

    public String getOrderByType() {
        if (this._orderByType != null) {
            return this._orderByType;
        }
        this._orderByType = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"orderByType", (String)"asc");
        return this._orderByType;
    }

    public PortletURL getPortletURL() {
        String orderByType;
        String orderByCol;
        PortletURL portletURL = this._renderResponse.createRenderURL();
        portletURL.setParameter("mvcPath", "/admin/select_users.jsp");
        portletURL.setParameter("groupId", String.valueOf(this.getGroupId()));
        String displayStyle = this.getDisplayStyle();
        if (Validator.isNotNull((String)displayStyle)) {
            portletURL.setParameter("displayStyle", displayStyle);
        }
        portletURL.setParameter("eventName", this.getEventName());
        String keywords = this.getKeywords();
        if (Validator.isNotNull((String)keywords)) {
            portletURL.setParameter("keywords", keywords);
        }
        if (Validator.isNotNull((String)(orderByCol = this.getOrderByCol()))) {
            portletURL.setParameter("orderByCol", orderByCol);
        }
        if (Validator.isNotNull((String)(orderByType = this.getOrderByType()))) {
            portletURL.setParameter("orderByType", orderByType);
        }
        try {
            portletURL.setWindowState(LiferayWindowState.POP_UP);
        }
        catch (WindowStateException windowStateException) {
            // empty catch block
        }
        return portletURL;
    }

    public SearchContainer<User> getUserSearchContainer() {
        if (this._userSearch != null) {
            return this._userSearch;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        UserSearch userSearch = new UserSearch((PortletRequest)this._renderRequest, this.getPortletURL());
        Group group = GroupLocalServiceUtil.fetchGroup((long)this.getGroupId());
        UserSearchTerms searchTerms = (UserSearchTerms)userSearch.getSearchTerms();
        LinkedHashMap<String, Comparable<Boolean>> userParams = new LinkedHashMap<String, Comparable<Boolean>>();
        if (group.isLimitedToParentSiteMembers()) {
            userParams.put("inherit", Boolean.TRUE);
            userParams.put("usersGroups", Long.valueOf(group.getParentGroupId()));
        }
        int usersCount = UserLocalServiceUtil.searchCount((long)themeDisplay.getCompanyId(), (String)searchTerms.getKeywords(), (int)searchTerms.getStatus(), userParams);
        userSearch.setTotal(usersCount);
        List users = UserLocalServiceUtil.search((long)themeDisplay.getCompanyId(), (String)searchTerms.getKeywords(), (int)searchTerms.getStatus(), userParams, (int)userSearch.getStart(), (int)userSearch.getEnd(), (OrderByComparator)userSearch.getOrderByComparator());
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)this._themeDisplay.getUser());
        users.removeIf(user -> {
            try {
                return !UserPermissionUtil.contains((PermissionChecker)permissionChecker, (long)user.getUserId(), (long[])user.getOrganizationIds(), (String)"IMPERSONATE");
            }
            catch (PortalException pe) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)pe.getMessage());
                }
                return false;
            }
        });
        userSearch.setResults(users);
        this._userSearch = userSearch;
        return this._userSearch;
    }
}

