/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.web.internal.display.context;

import com.liferay.document.library.util.DLURLHelper;
import com.liferay.oauth2.provider.configuration.OAuth2ProviderConfiguration;
import com.liferay.oauth2.provider.constants.ClientProfile;
import com.liferay.oauth2.provider.constants.GrantType;
import com.liferay.oauth2.provider.model.OAuth2Application;
import com.liferay.oauth2.provider.service.OAuth2ApplicationScopeAliasesLocalService;
import com.liferay.oauth2.provider.service.OAuth2ApplicationService;
import com.liferay.oauth2.provider.service.OAuth2AuthorizationServiceUtil;
import com.liferay.oauth2.provider.web.internal.display.context.BaseOAuth2PortletDisplayContext;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;

public class OAuth2AdminPortletDisplayContext
extends BaseOAuth2PortletDisplayContext {
    protected final OAuth2ApplicationScopeAliasesLocalService oAuth2ApplicationScopeAliasesLocalService;
    private final OAuth2ProviderConfiguration _oAuth2ProviderConfiguration;

    public OAuth2AdminPortletDisplayContext(OAuth2ApplicationService oAuth2ApplicationService, OAuth2ApplicationScopeAliasesLocalService oAuth2ApplicationScopeAliasesLocalService, OAuth2ProviderConfiguration oAuth2ProviderConfiguration, PortletRequest portletRequest, ThemeDisplay themeDisplay, DLURLHelper dlURLHelper) {
        this._oAuth2ProviderConfiguration = oAuth2ProviderConfiguration;
        this.oAuth2ApplicationService = oAuth2ApplicationService;
        this.portletRequest = portletRequest;
        this.themeDisplay = themeDisplay;
        this.dlURLHelper = dlURLHelper;
        this.oAuth2ApplicationScopeAliasesLocalService = oAuth2ApplicationScopeAliasesLocalService;
    }

    public List<GrantType> getGrantTypes(PortletPreferences portletPreferences) {
        String[] oAuth2Grants = StringUtil.split((String)portletPreferences.getValue("oAuth2Grants", ""));
        ArrayList<GrantType> grantTypes = new ArrayList<GrantType>();
        for (String oAuth2Grant : oAuth2Grants) {
            grantTypes.add(GrantType.valueOf((String)oAuth2Grant));
        }
        if (grantTypes.isEmpty()) {
            Collections.addAll(grantTypes, GrantType.values());
        }
        if (!this._oAuth2ProviderConfiguration.allowAuthorizationCodeGrant()) {
            grantTypes.remove(GrantType.AUTHORIZATION_CODE);
        }
        if (!this._oAuth2ProviderConfiguration.allowAuthorizationCodePKCEGrant()) {
            grantTypes.remove(GrantType.AUTHORIZATION_CODE_PKCE);
        }
        if (!this._oAuth2ProviderConfiguration.allowClientCredentialsGrant()) {
            grantTypes.remove(GrantType.CLIENT_CREDENTIALS);
        }
        if (!this._oAuth2ProviderConfiguration.allowRefreshTokenGrant()) {
            grantTypes.remove(GrantType.REFRESH_TOKEN);
        }
        if (!this._oAuth2ProviderConfiguration.allowResourceOwnerPasswordCredentialsGrant()) {
            grantTypes.remove(GrantType.RESOURCE_OWNER_PASSWORD);
        }
        return grantTypes;
    }

    public int getOAuth2AuthorizationsCount(OAuth2Application oAuth2Application) throws PortalException {
        return OAuth2AuthorizationServiceUtil.getApplicationOAuth2AuthorizationsCount((long)oAuth2Application.getOAuth2ApplicationId());
    }

    public String[] getOAuth2Features(PortletPreferences portletPreferences) {
        return StringUtil.split((String)portletPreferences.getValue("oAuth2Features", ""));
    }

    public int getScopeAliasesSize(OAuth2Application oAuth2Application) throws PortalException {
        List scopeAliasesList = this.oAuth2ApplicationScopeAliasesLocalService.getScopeAliasesList(oAuth2Application.getOAuth2ApplicationScopeAliasesId());
        return scopeAliasesList.size();
    }

    public ClientProfile[] getSortedClientProfiles() {
        ClientProfile[] clientProfiles = ClientProfile.values();
        Arrays.sort(clientProfiles, Comparator.comparingInt(ClientProfile::id));
        return clientProfiles;
    }
}

