/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.web.internal.portlet.action;

import com.liferay.oauth2.provider.model.OAuth2Application;
import com.liferay.oauth2.provider.model.OAuth2ApplicationScopeAliases;
import com.liferay.oauth2.provider.scope.liferay.ApplicationDescriptorLocator;
import com.liferay.oauth2.provider.scope.liferay.LiferayOAuth2Scope;
import com.liferay.oauth2.provider.scope.liferay.ScopeDescriptorLocator;
import com.liferay.oauth2.provider.scope.liferay.ScopeLocator;
import com.liferay.oauth2.provider.service.OAuth2ApplicationScopeAliasesLocalService;
import com.liferay.oauth2.provider.service.OAuth2ApplicationService;
import com.liferay.oauth2.provider.service.OAuth2ScopeGrantLocalService;
import com.liferay.oauth2.provider.web.internal.AssignableScopes;
import com.liferay.oauth2.provider.web.internal.display.context.OAuth2AuthorizePortletDisplayContext;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCRenderCommand;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_oauth2_provider_web_internal_portlet_OAuth2AuthorizePortlet", "mvc.command.name=/", "mvc.command.name=/authorize/view_authorization_request"}, service={MVCRenderCommand.class})
public class ViewAuthorizationRequestMVCRenderCommand
implements MVCRenderCommand {
    @Reference
    private ApplicationDescriptorLocator _applicationDescriptorLocator;
    @Reference
    private OAuth2ApplicationScopeAliasesLocalService _oAuth2ApplicationScopeAliasesLocalService;
    @Reference
    private OAuth2ApplicationService _oAuth2ApplicationService;
    @Reference
    private OAuth2ScopeGrantLocalService _oAuth2ScopeGrantLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private ScopeDescriptorLocator _scopeDescriptorLocator;
    @Reference
    private ScopeLocator _scopeFinderLocator;

    public String render(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException {
        ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        HttpServletRequest request = this._portal.getOriginalServletRequest(this._portal.getHttpServletRequest((PortletRequest)renderRequest));
        Map<String, String> oAuth2Parameters = this.getOAuth2Parameters(request);
        String error = oAuth2Parameters.get("error");
        if (StringUtil.equals((String)error, (String)"invalid_client")) {
            SessionErrors.add((PortletRequest)renderRequest, (String)"clientIdInvalid");
            return "/authorize/error.jsp";
        }
        String redirectURI = oAuth2Parameters.get("redirect_uri");
        if (Validator.isBlank((String)redirectURI)) {
            SessionErrors.add((PortletRequest)renderRequest, (String)"redirectURIMissing");
            return "/authorize/error.jsp";
        }
        String clientId = oAuth2Parameters.get("client_id");
        try {
            OAuth2Application oAuth2Application = this._oAuth2ApplicationService.getOAuth2Application(themeDisplay.getCompanyId(), clientId);
            OAuth2AuthorizePortletDisplayContext oAuth2AuthorizePortletDisplayContext = new OAuth2AuthorizePortletDisplayContext(themeDisplay);
            oAuth2AuthorizePortletDisplayContext.setOAuth2Application(oAuth2Application);
            oAuth2AuthorizePortletDisplayContext.setOAuth2Parameters(oAuth2Parameters);
            AssignableScopes assignableScopes = new AssignableScopes(this._applicationDescriptorLocator, themeDisplay.getLocale(), this._scopeDescriptorLocator);
            if (oAuth2Application.getOAuth2ApplicationScopeAliasesId() > 0L) {
                OAuth2ApplicationScopeAliases oAuth2ApplicationScopeAliases = this._oAuth2ApplicationScopeAliasesLocalService.getOAuth2ApplicationScopeAliases(oAuth2Application.getOAuth2ApplicationScopeAliasesId());
                String[] requestedScopeAliases = StringUtil.split((String)oAuth2Parameters.get("scope"), (String)" ");
                this.populateAssignableScopes(assignableScopes, oAuth2ApplicationScopeAliases, requestedScopeAliases);
            }
            oAuth2AuthorizePortletDisplayContext.setAssignableScopes(assignableScopes);
            renderRequest.setAttribute("OAUTH2_AUTHORIZE_PORTLET_DISPLAY_CONTEXT", (Object)oAuth2AuthorizePortletDisplayContext);
        }
        catch (PortalException pe) {
            throw new PortletException((Throwable)pe);
        }
        return "/authorize/authorize.jsp";
    }

    protected Map<String, String> getOAuth2Parameters(HttpServletRequest request) {
        HashMap<String, String> oAuth2Parameters = new HashMap<String, String>();
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.startsWith("oauth2_")) continue;
            oAuth2Parameters.put(name.substring("oauth2_".length()), ParamUtil.getString((HttpServletRequest)request, (String)name));
        }
        return oAuth2Parameters;
    }

    protected void populateAssignableScopes(AssignableScopes assignableScopes, OAuth2ApplicationScopeAliases oAuth2ApplicationScopeAliases, String[] requestedScopeAliases) {
        HashSet<LiferayOAuth2Scope> liferayOAuth2Scopes = new HashSet();
        List scopeAliasesList = oAuth2ApplicationScopeAliases.getScopeAliasesList();
        for (String requestedScopeAlias : requestedScopeAliases) {
            if (!scopeAliasesList.contains(requestedScopeAlias)) continue;
            liferayOAuth2Scopes.addAll(this._scopeFinderLocator.getLiferayOAuth2Scopes(oAuth2ApplicationScopeAliases.getCompanyId(), requestedScopeAlias));
        }
        liferayOAuth2Scopes = this._oAuth2ScopeGrantLocalService.getFilteredLiferayOAuth2Scopes(oAuth2ApplicationScopeAliases.getOAuth2ApplicationScopeAliasesId(), liferayOAuth2Scopes);
        assignableScopes.addLiferayOAuth2Scopes(liferayOAuth2Scopes);
    }
}

