/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.web.internal.portlet.action;

import com.liferay.oauth2.provider.service.OAuth2ApplicationService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.oauth2.provider.configuration.OAuth2ProviderConfiguration"}, property={"javax.portlet.name=com_liferay_oauth2_provider_web_internal_portlet_OAuth2AdminPortlet", "mvc.command.name=/admin/delete_oauth2_applications"}, service={MVCActionCommand.class})
public class DeleteOAuth2ApplicationsMVCActionCommand
implements MVCActionCommand {
    private static final Log _log = LogFactoryUtil.getLog(DeleteOAuth2ApplicationsMVCActionCommand.class);
    @Reference
    private OAuth2ApplicationService _oAuth2ApplicationService;

    public boolean processAction(ActionRequest actionRequest, ActionResponse actionResponse) {
        long[] oAuth2ApplicationIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"oAuth2ApplicationIds"), (long)0L);
        try {
            for (long oAuth2ApplicationId : oAuth2ApplicationIds) {
                this._oAuth2ApplicationService.deleteOAuth2Application(oAuth2ApplicationId);
            }
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            SessionErrors.add((PortletRequest)actionRequest, ((Object)((Object)pe)).getClass());
        }
        return true;
    }
}

