/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.web.internal.display.context;

import com.liferay.oauth2.provider.configuration.OAuth2ProviderConfiguration;
import com.liferay.oauth2.provider.scope.liferay.ApplicationDescriptorLocator;
import com.liferay.oauth2.provider.scope.liferay.ScopeDescriptorLocator;
import com.liferay.oauth2.provider.scope.liferay.ScopeLocator;
import com.liferay.oauth2.provider.scope.spi.application.descriptor.ApplicationDescriptor;
import com.liferay.oauth2.provider.service.OAuth2ApplicationService;
import com.liferay.oauth2.provider.web.internal.AssignableScopes;
import com.liferay.oauth2.provider.web.internal.display.context.OAuth2AdminPortletDisplayContext;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.portlet.PortletRequest;

public class AssignScopesDisplayContext
extends OAuth2AdminPortletDisplayContext {
    private final ApplicationDescriptorLocator _applicationDescriptorLocator;
    private Map<AssignableScopes, Relations> _assignableScopesRelations = new HashMap<AssignableScopes, Relations>();
    private Map<String, Set<AssignableScopes>> _globalAssignableScopesByApplicationName = new HashMap<String, Set<AssignableScopes>>();
    private Map<String, Set<AssignableScopes>> _localAssignableScopesByApplicationName = new HashMap<String, Set<AssignableScopes>>();
    private final Locale _locale;

    public AssignScopesDisplayContext(OAuth2ApplicationService oAuth2ApplicationService, OAuth2ProviderConfiguration oAuth2ProviderConfiguration, PortletRequest portletRequest, ThemeDisplay themeDisplay, ApplicationDescriptorLocator applicationDescriptorLocator, ScopeDescriptorLocator scopeDescriptorLocator, ScopeLocator scopeLocator) {
        super(oAuth2ApplicationService, oAuth2ProviderConfiguration, portletRequest, themeDisplay);
        this._applicationDescriptorLocator = applicationDescriptorLocator;
        this._locale = themeDisplay.getLocale();
        HashSet scopeAliases = new HashSet(scopeLocator.getScopeAliases(themeDisplay.getCompanyId()));
        for (String scopeAlias : scopeAliases) {
            Set assignableScopesSet;
            String applicationName2;
            AssignableScopes assignableScopes = new AssignableScopes(applicationDescriptorLocator, this._locale, scopeDescriptorLocator);
            assignableScopes.addLiferayOAuth2Scopes(scopeLocator.getLiferayOAuth2Scopes(themeDisplay.getCompanyId(), scopeAlias));
            this._assignableScopesRelations.compute(assignableScopes, (key, existingValue) -> {
                if (existingValue != null) {
                    ((Relations)existingValue)._scopeAliases.add(scopeAlias);
                    return existingValue;
                }
                return new Relations(Collections.singleton(scopeAlias));
            });
            Set<String> applicationNames = assignableScopes.getApplicationNames();
            if (applicationNames.size() > 1) {
                for (String applicationName2 : applicationNames) {
                    assignableScopesSet = this._globalAssignableScopesByApplicationName.computeIfAbsent(applicationName2, a -> new HashSet());
                    assignableScopesSet.add(assignableScopes);
                }
                continue;
            }
            if (applicationNames.size() != 1) continue;
            Iterator<String> iterator = applicationNames.iterator();
            applicationName2 = iterator.next();
            assignableScopesSet = this._localAssignableScopesByApplicationName.computeIfAbsent(applicationName2, a -> new HashSet());
            assignableScopesSet.add(assignableScopes);
        }
    }

    public String getApplicationDescription(String applicationName) {
        ApplicationDescriptor applicationDescriptor = this._applicationDescriptorLocator.getApplicationDescriptor(applicationName);
        if (applicationDescriptor == null) {
            return applicationName;
        }
        return applicationDescriptor.describeApplication(this._locale);
    }

    public Set<String> getApplicationNames() {
        HashSet<String> applicationNames = new HashSet<String>();
        applicationNames.addAll(this._globalAssignableScopesByApplicationName.keySet());
        applicationNames.addAll(this._localAssignableScopesByApplicationName.keySet());
        return applicationNames;
    }

    public Map<String, String> getApplicationNamesDescriptions() {
        HashMap<String, String> applicationNamesDescriptions = new HashMap<String, String>();
        for (String applicationName : this.getApplicationNames()) {
            applicationNamesDescriptions.put(applicationName, this.getApplicationDescription(applicationName));
        }
        return applicationNamesDescriptions;
    }

    public String getApplicationScopeDescription(String applicationName, AssignableScopes assignableScopes, String delimiter) {
        Set<String> applicationScopeDescription = assignableScopes.getApplicationScopeDescription(applicationName);
        Stream stream = applicationScopeDescription.stream();
        List scopesList = stream.sorted().map(HtmlUtil::escape).collect(Collectors.toList());
        if (ListUtil.isEmpty(scopesList)) {
            return "";
        }
        return StringUtil.merge(scopesList, (String)delimiter);
    }

    public Map<AssignableScopes, Relations> getAssignableScopesRelations(String applicationName) {
        Set<AssignableScopes> globalAssignableScopes;
        Set<AssignableScopes> localAssignableScopes = this._localAssignableScopesByApplicationName.get(applicationName);
        HashMap<AssignableScopes, Relations> localRelations = new HashMap<AssignableScopes, Relations>();
        if (localAssignableScopes != null) {
            localRelations.putAll(this.getAssignableScopesRelations(localAssignableScopes));
        }
        if ((globalAssignableScopes = this._globalAssignableScopesByApplicationName.get(applicationName)) == null) {
            return localRelations;
        }
        HashMap<AssignableScopes, Relations> assignableScopesRelations = new HashMap<AssignableScopes, Relations>(localRelations);
        for (AssignableScopes assignableScopes : globalAssignableScopes) {
            AssignableScopes applicationAssignableScopes = assignableScopes.getApplicationAssignableScopes(applicationName);
            for (Map.Entry entry : localRelations.entrySet()) {
                if (assignableScopes.contains((AssignableScopes)entry.getKey())) {
                    Relations relations = (Relations)entry.getValue();
                    relations._globalAssignableScopes.add(assignableScopes);
                }
                applicationAssignableScopes = applicationAssignableScopes.subtract((AssignableScopes)entry.getKey());
            }
            Relations relations = assignableScopesRelations.computeIfAbsent(applicationAssignableScopes, a -> new Relations());
            relations._globalAssignableScopes.add(assignableScopes);
        }
        return this._normalize(assignableScopesRelations);
    }

    public Map<AssignableScopes, Relations> getGlobalAssignableScopesRelations() {
        Collection<Set<AssignableScopes>> assignableScopesCollection = this._globalAssignableScopesByApplicationName.values();
        Stream<Set<AssignableScopes>> stream = assignableScopesCollection.stream();
        return stream.flatMap(Collection::stream).collect(Collectors.toSet()).stream().filter(this._assignableScopesRelations::containsKey).collect(Collectors.toMap(Function.identity(), this._assignableScopesRelations::get));
    }

    public List<Map.Entry<String, String>> getSortedApplicationNamesDescriptions() {
        Map<String, String> applicationNamesDescriptions = this.getApplicationNamesDescriptions();
        ArrayList<Map.Entry<String, String>> applicationsNamesDescriptionsList = new ArrayList<Map.Entry<String, String>>(applicationNamesDescriptions.entrySet());
        applicationsNamesDescriptionsList.sort(Comparator.comparing(Map.Entry::getValue));
        return applicationsNamesDescriptionsList;
    }

    protected Map<AssignableScopes, Relations> getAssignableScopesRelations(Set<AssignableScopes> assignableScopes) {
        Stream assignableScopesStream = assignableScopes.stream();
        return assignableScopesStream.filter(this._assignableScopesRelations::containsKey).collect(Collectors.toMap(Function.identity(), this._assignableScopesRelations::get));
    }

    private static <K, V> Map<V, K> _invertMap(Map<K, V> map) {
        HashMap<V, K> ret = new HashMap<V, K>(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            ret.put(entry.getValue(), entry.getKey());
        }
        return ret;
    }

    private Map<AssignableScopes, Relations> _normalize(Map<AssignableScopes, Relations> assignableScopesRelations) {
        HashMap<AssignableScopes, Relations> combinedAssignableScopesRelations = new HashMap<AssignableScopes, Relations>();
        for (Map.Entry<AssignableScopes, Relations> assignableScopesRelationsEntry : assignableScopesRelations.entrySet()) {
            Relations relations = assignableScopesRelationsEntry.getValue();
            Set<String> scopeAliases = relations.getScopeAliases();
            AssignableScopes assignableScopes = assignableScopesRelationsEntry.getKey();
            if (scopeAliases != null && !scopeAliases.isEmpty()) {
                combinedAssignableScopesRelations.put(assignableScopes, relations);
                continue;
            }
            Set<AssignableScopes> applicationScopedAssignableScopesSet = assignableScopes.splitByApplicationScopes();
            for (AssignableScopes applicationScopedAssignableScopes : applicationScopedAssignableScopesSet) {
                Relations combinedRelations = combinedAssignableScopesRelations.computeIfAbsent(applicationScopedAssignableScopes, __ -> new Relations());
                combinedRelations._globalAssignableScopes.addAll(relations._globalAssignableScopes);
            }
        }
        HashMap<Relations, AssignableScopes> relationsAssignableScopes = new HashMap<Relations, AssignableScopes>();
        for (Map.Entry entry : combinedAssignableScopesRelations.entrySet()) {
            relationsAssignableScopes.compute((Relations)entry.getValue(), (key, existingValue) -> {
                if (existingValue != null) {
                    return existingValue.add((AssignableScopes)entry.getKey());
                }
                return (AssignableScopes)entry.getKey();
            });
        }
        return AssignScopesDisplayContext._invertMap(relationsAssignableScopes);
    }

    public class Relations {
        private Set<AssignableScopes> _globalAssignableScopes = new HashSet<AssignableScopes>();
        private final Set<String> _scopeAliases;

        public Relations() {
            this._scopeAliases = new HashSet<String>();
        }

        public Relations(Set<String> scopeAliases) {
            this._scopeAliases = new HashSet<String>(scopeAliases);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Relations relations = (Relations)o;
            return Objects.equals(this._globalAssignableScopes, relations._globalAssignableScopes) && Objects.equals(this._scopeAliases, relations._scopeAliases);
        }

        public Set<String> getGlobalScopeAliases() {
            Stream stream = this._globalAssignableScopes.stream();
            return stream.map(AssignScopesDisplayContext.this._assignableScopesRelations::get).flatMap(relations -> {
                Set<String> scopeAliases = relations.getScopeAliases();
                return scopeAliases.stream();
            }).collect(Collectors.toSet());
        }

        public Set<String> getScopeAliases() {
            return this._scopeAliases;
        }

        public int hashCode() {
            return Objects.hash(this._globalAssignableScopes, this._scopeAliases);
        }
    }
}

