/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.web.internal;

import com.liferay.oauth2.provider.scope.liferay.ApplicationDescriptorLocator;
import com.liferay.oauth2.provider.scope.liferay.LiferayOAuth2Scope;
import com.liferay.oauth2.provider.scope.liferay.ScopeDescriptorLocator;
import com.liferay.oauth2.provider.scope.spi.application.descriptor.ApplicationDescriptor;
import com.liferay.oauth2.provider.scope.spi.scope.descriptor.ScopeDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AssignableScopes {
    private final ApplicationDescriptorLocator _applicationDescriptorLocator;
    private Set<LiferayOAuth2Scope> _liferayOAuth2Scopes = new HashSet<LiferayOAuth2Scope>();
    private final Locale _locale;
    private final ScopeDescriptorLocator _scopeDescriptorLocator;

    public AssignableScopes(ApplicationDescriptorLocator applicationDescriptorLocator, Locale locale, ScopeDescriptorLocator scopeDescriptorLocator) {
        this(applicationDescriptorLocator, new HashSet<LiferayOAuth2Scope>(), locale, scopeDescriptorLocator);
    }

    public AssignableScopes(ApplicationDescriptorLocator applicationDescriptorLocator, Set<LiferayOAuth2Scope> liferayOAuth2Scopes, Locale locale, ScopeDescriptorLocator scopeDescriptorLocator) {
        this._applicationDescriptorLocator = applicationDescriptorLocator;
        this._liferayOAuth2Scopes = liferayOAuth2Scopes;
        this._locale = locale;
        this._scopeDescriptorLocator = scopeDescriptorLocator;
    }

    public AssignableScopes add(AssignableScopes assignableScopes) {
        HashSet<LiferayOAuth2Scope> liferayOAuth2Scopes = new HashSet<LiferayOAuth2Scope>();
        liferayOAuth2Scopes.addAll(assignableScopes.getLiferayOAuth2Scopes());
        liferayOAuth2Scopes.addAll(this._liferayOAuth2Scopes);
        return new AssignableScopes(this._applicationDescriptorLocator, liferayOAuth2Scopes, this._locale, this._scopeDescriptorLocator);
    }

    public void addLiferayOAuth2Scopes(Collection<LiferayOAuth2Scope> liferayOAuth2Scopes) {
        this._liferayOAuth2Scopes.addAll(liferayOAuth2Scopes);
    }

    public boolean contains(AssignableScopes assignableScopes) {
        return this._liferayOAuth2Scopes.containsAll(assignableScopes.getLiferayOAuth2Scopes());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AssignableScopes)) {
            return false;
        }
        AssignableScopes assignableScopes = (AssignableScopes)obj;
        return Objects.equals(this._liferayOAuth2Scopes, assignableScopes.getLiferayOAuth2Scopes());
    }

    public AssignableScopes getApplicationAssignableScopes(String applicationName) {
        Stream stream = this._liferayOAuth2Scopes.stream();
        Set<LiferayOAuth2Scope> liferayOAuth2Scopes = stream.filter(liferayOAuth2Scope -> applicationName.equals(liferayOAuth2Scope.getApplicationName())).collect(Collectors.toSet());
        return new AssignableScopes(this._applicationDescriptorLocator, liferayOAuth2Scopes, this._locale, this._scopeDescriptorLocator);
    }

    public String getApplicationDescription(String applicationName) {
        ApplicationDescriptor applicationDescriptor = this._applicationDescriptorLocator.getApplicationDescriptor(applicationName);
        if (applicationDescriptor == null) {
            return applicationName;
        }
        return applicationDescriptor.describeApplication(this._locale);
    }

    public Set<String> getApplicationNames() {
        HashSet<String> applicationNames = new HashSet<String>();
        for (LiferayOAuth2Scope liferayOAuth2Scope : this._liferayOAuth2Scopes) {
            applicationNames.add(liferayOAuth2Scope.getApplicationName());
        }
        return applicationNames;
    }

    public Set<String> getApplicationScopeDescription(String applicationName) {
        Stream stream = this._liferayOAuth2Scopes.stream();
        return stream.filter(liferayOAuth2Scope -> applicationName.equals(liferayOAuth2Scope.getApplicationName())).map(this::getScopeDescription).collect(Collectors.toSet());
    }

    public Set<LiferayOAuth2Scope> getLiferayOAuth2Scopes() {
        return this._liferayOAuth2Scopes;
    }

    public String getScopeDescription(LiferayOAuth2Scope liferayOAuth2Scope) {
        ScopeDescriptor scopeDescriptor = this._scopeDescriptorLocator.getScopeDescriptor(liferayOAuth2Scope.getApplicationName());
        if (scopeDescriptor == null) {
            return liferayOAuth2Scope.getScope();
        }
        return scopeDescriptor.describeScope(liferayOAuth2Scope.getScope(), this._locale);
    }

    public int hashCode() {
        return this._liferayOAuth2Scopes.hashCode();
    }

    public Set<AssignableScopes> splitByApplicationScopes() {
        Stream stream = this._liferayOAuth2Scopes.stream();
        return stream.map(liferayOAuth2Scope -> new AssignableScopes(this._applicationDescriptorLocator, Collections.singleton(liferayOAuth2Scope), this._locale, this._scopeDescriptorLocator)).collect(Collectors.toSet());
    }

    public AssignableScopes subtract(AssignableScopes assignableScopes) {
        HashSet<LiferayOAuth2Scope> liferayOAuth2Scopes = new HashSet<LiferayOAuth2Scope>(this._liferayOAuth2Scopes);
        liferayOAuth2Scopes.removeAll(assignableScopes.getLiferayOAuth2Scopes());
        return new AssignableScopes(this._applicationDescriptorLocator, liferayOAuth2Scopes, this._locale, this._scopeDescriptorLocator);
    }
}

