/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.web.internal.portlet.action;

import com.liferay.oauth2.provider.service.OAuth2AuthorizationService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_oauth2_provider_web_internal_portlet_OAuth2AdminPortlet", "javax.portlet.name=com_liferay_oauth2_provider_web_internal_portlet_OAuth2ConnectedApplicationsPortlet", "mvc.command.name=/admin/revoke_oauth2_authorizations", "mvc.command.name=/connected_applications/revoke_oauth2_authorizations"})
public class RevokeOAuth2AuthorizationsMVCActionCommand
implements MVCActionCommand {
    private static final Log _log = LogFactoryUtil.getLog(RevokeOAuth2AuthorizationsMVCActionCommand.class);
    @Reference
    private OAuth2AuthorizationService _oAuth2AuthorizationService;

    public boolean processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException {
        long[] oAuth2AuthorizationIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"oAuth2AuthorizationIds"), (long)0L);
        try {
            for (long oAuth2AuthorizationId : oAuth2AuthorizationIds) {
                this._oAuth2AuthorizationService.revokeOAuth2Authorization(oAuth2AuthorizationId);
            }
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            SessionErrors.add((PortletRequest)actionRequest, ((Object)((Object)pe)).getClass());
        }
        String backURL = ParamUtil.get((PortletRequest)actionRequest, (String)"backURL", (String)"");
        if (Validator.isNotNull((String)backURL)) {
            actionResponse.setRenderParameter("redirect", backURL);
        }
        return true;
    }
}

