/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.web.internal.portlet.action;

import com.liferay.oauth2.provider.service.OAuth2ApplicationService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.util.ParamUtil;
import java.util.Arrays;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_oauth2_provider_web_internal_portlet_OAuth2AdminPortlet", "mvc.command.name=/admin/assign_scopes"})
public class AssignScopesMVCActionCommand
implements MVCActionCommand {
    private static final Log _log = LogFactoryUtil.getLog(AssignScopesMVCActionCommand.class);
    @Reference
    private OAuth2ApplicationService _oAuth2ApplicationService;

    public boolean processAction(ActionRequest actionRequest, ActionResponse actionResponse) {
        block2: {
            long oAuth2ApplicationId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"oAuth2ApplicationId");
            String[] scopeAliases = ParamUtil.getStringValues((PortletRequest)actionRequest, (String)"scopeAliases");
            List<String> scopeAliasesList = Arrays.asList(scopeAliases);
            try {
                this._oAuth2ApplicationService.updateScopeAliases(oAuth2ApplicationId, scopeAliasesList);
            }
            catch (PortalException pe) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)("Unable to load OAuth 2 application " + oAuth2ApplicationId), (Throwable)pe);
            }
        }
        String backURL = ParamUtil.get((PortletRequest)actionRequest, (String)"backURL", (String)"");
        actionResponse.setRenderParameter("redirect", backURL);
        return true;
    }
}

