/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.service.impl;

import com.liferay.oauth2.provider.model.OAuth2Application;
import com.liferay.oauth2.provider.model.OAuth2ApplicationScopeAliases;
import com.liferay.oauth2.provider.model.OAuth2ScopeGrant;
import com.liferay.oauth2.provider.scope.liferay.LiferayOAuth2Scope;
import com.liferay.oauth2.provider.scope.liferay.ScopeLocator;
import com.liferay.oauth2.provider.service.OAuth2ScopeGrantLocalService;
import com.liferay.oauth2.provider.service.base.OAuth2ApplicationScopeAliasesLocalServiceBaseImpl;
import com.liferay.oauth2.provider.service.persistence.OAuth2ApplicationPersistence;
import com.liferay.oauth2.provider.util.builder.OAuth2ScopeBuilder;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.framework.Bundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.oauth2.provider.model.OAuth2ApplicationScopeAliases"}, service={AopService.class})
public class OAuth2ApplicationScopeAliasesLocalServiceImpl
extends OAuth2ApplicationScopeAliasesLocalServiceBaseImpl {
    @Reference
    private OAuth2ApplicationPersistence _oAuth2ApplicationPersistence;
    @Reference
    private OAuth2ScopeGrantLocalService _oAuth2ScopeGrantLocalService;
    @Reference
    private ScopeLocator _scopeLocator;

    public OAuth2ApplicationScopeAliases addOAuth2ApplicationScopeAliases(long companyId, long userId, String userName, long oAuth2ApplicationId, Consumer<OAuth2ScopeBuilder> builderConsumer) throws PortalException {
        HashMap<Map.Entry<ScopeNamespace, String>, List<String>> simpleEntryScopeAliases = new HashMap<Map.Entry<ScopeNamespace, String>, List<String>>();
        builderConsumer.accept(new OAuth2ScopeBuilderImpl(simpleEntryScopeAliases));
        long oAuth2ApplicationScopeAliasesId = this.counterLocalService.increment(OAuth2ApplicationScopeAliases.class.getName());
        OAuth2ApplicationScopeAliases oAuth2ApplicationScopeAliases = this.createOAuth2ApplicationScopeAliases(oAuth2ApplicationScopeAliasesId);
        oAuth2ApplicationScopeAliases.setCompanyId(companyId);
        oAuth2ApplicationScopeAliases.setUserId(userId);
        oAuth2ApplicationScopeAliases.setUserName(userName);
        oAuth2ApplicationScopeAliases.setCreateDate(new Date());
        oAuth2ApplicationScopeAliases.setOAuth2ApplicationId(oAuth2ApplicationId);
        oAuth2ApplicationScopeAliases = (OAuth2ApplicationScopeAliases)this.oAuth2ApplicationScopeAliasesPersistence.update((BaseModel)oAuth2ApplicationScopeAliases);
        for (Map.Entry entry : simpleEntryScopeAliases.entrySet()) {
            Map.Entry key = (Map.Entry)entry.getKey();
            ScopeNamespace scopeNamespace = (ScopeNamespace)key.getKey();
            this._oAuth2ScopeGrantLocalService.createOAuth2ScopeGrant(companyId, oAuth2ApplicationScopeAliasesId, scopeNamespace.getApplicationName(), scopeNamespace.getBundleSymbolicName(), (String)key.getValue(), (List)entry.getValue());
        }
        return oAuth2ApplicationScopeAliases;
    }

    public OAuth2ApplicationScopeAliases addOAuth2ApplicationScopeAliases(long companyId, long userId, String userName, long oAuth2ApplicationId, List<String> scopeAliasesList) throws PortalException {
        for (String scopeAlias : scopeAliasesList) {
            if (!scopeAlias.contains(" ")) continue;
            throw new PortalException("Scope aliases cannot contain spaces");
        }
        Map<LiferayOAuth2Scope, List<String>> liferayOAuth2ScopesScopeAliases = this._getLiferayOAuth2ScopesScopeAliases(companyId, scopeAliasesList);
        return this._addOAuth2ApplicationScopeAliases(companyId, userId, userName, oAuth2ApplicationId, liferayOAuth2ScopesScopeAliases);
    }

    @Override
    public OAuth2ApplicationScopeAliases deleteOAuth2ApplicationScopeAliases(long oAuth2ApplicationScopeAliasesId) throws PortalException {
        Collection oAuth2ScopeGrants = this._oAuth2ScopeGrantLocalService.getOAuth2ScopeGrants(oAuth2ApplicationScopeAliasesId, -1, -1, null);
        for (OAuth2ScopeGrant oAuth2ScopeGrant : oAuth2ScopeGrants) {
            long[] oAuth2AuthorizationPrimaryKeys = this._oAuth2ScopeGrantLocalService.getOAuth2AuthorizationPrimaryKeys(oAuth2ScopeGrant.getOAuth2ScopeGrantId());
            if (oAuth2AuthorizationPrimaryKeys.length <= 0) continue;
            throw new PortalException(StringBundler.concat((Object[])new Object[]{"Unable to delete required OAuth2 application scope ", "aliases ", oAuth2ApplicationScopeAliasesId, "because there exists at least one OAuth2 ", "authorization which references its OAuth2 scope ", "grants"}));
        }
        for (OAuth2ScopeGrant oAuth2ScopeGrant : oAuth2ScopeGrants) {
            this._oAuth2ScopeGrantLocalService.deleteOAuth2ScopeGrant(oAuth2ScopeGrant.getOAuth2ScopeGrantId());
        }
        return this.oAuth2ApplicationScopeAliasesPersistence.remove(oAuth2ApplicationScopeAliasesId);
    }

    public OAuth2ApplicationScopeAliases fetchOAuth2ApplicationScopeAliases(long oAuth2ApplicationId, List<String> scopeAliasesList) {
        OAuth2Application oAuth2Application = this._oAuth2ApplicationPersistence.fetchByPrimaryKey(oAuth2ApplicationId);
        if (oAuth2Application == null) {
            return null;
        }
        HashSet<String> scopeAliases = new HashSet<String>(scopeAliasesList);
        long oAuth2ApplicationScopeAliasesId = oAuth2Application.getOAuth2ApplicationScopeAliasesId();
        List<String> assignedScopeAliases = this.getScopeAliasesList(oAuth2ApplicationScopeAliasesId);
        if (scopeAliases.size() == assignedScopeAliases.size() && assignedScopeAliases.containsAll(scopeAliases)) {
            return this.fetchOAuth2ApplicationScopeAliases(oAuth2ApplicationScopeAliasesId);
        }
        return null;
    }

    public List<OAuth2ApplicationScopeAliases> getOAuth2ApplicationScopeAliaseses(long oAuth2ApplicationId, int start, int end, OrderByComparator<OAuth2ApplicationScopeAliases> orderByComparator) {
        return this.oAuth2ApplicationScopeAliasesPersistence.findByOAuth2ApplicationId(oAuth2ApplicationId, start, end, orderByComparator);
    }

    public List<String> getScopeAliasesList(long oAuth2ApplicationScopeAliasesId) {
        return this._getScopeAliasesList(this._oAuth2ScopeGrantLocalService.getOAuth2ScopeGrants(oAuth2ApplicationScopeAliasesId, -1, -1, null));
    }

    @Override
    public OAuth2ApplicationScopeAliases updateOAuth2ApplicationScopeAliases(OAuth2ApplicationScopeAliases oAuth2ApplicationScopeAliases) {
        Map<LiferayOAuth2Scope, List<String>> liferayOAuth2ScopesScopeAliases;
        Collection oAuth2ScopeGrants = this._oAuth2ScopeGrantLocalService.getOAuth2ScopeGrants(oAuth2ApplicationScopeAliases.getOAuth2ApplicationScopeAliasesId(), -1, -1, null);
        if (this._hasUpToDateScopeGrants(oAuth2ScopeGrants, liferayOAuth2ScopesScopeAliases = this._getLiferayOAuth2ScopesScopeAliases(oAuth2ApplicationScopeAliases.getCompanyId(), this._getScopeAliasesList(oAuth2ScopeGrants)))) {
            return oAuth2ApplicationScopeAliases;
        }
        try {
            return this._addOAuth2ApplicationScopeAliases(oAuth2ApplicationScopeAliases.getCompanyId(), oAuth2ApplicationScopeAliases.getUserId(), oAuth2ApplicationScopeAliases.getUserName(), oAuth2ApplicationScopeAliases.getOAuth2ApplicationId(), liferayOAuth2ScopesScopeAliases);
        }
        catch (PortalException portalException) {
            throw new IllegalArgumentException(portalException);
        }
    }

    private OAuth2ApplicationScopeAliases _addOAuth2ApplicationScopeAliases(long companyId, long userId, String userName, long oAuth2ApplicationId, Map<LiferayOAuth2Scope, List<String>> liferayOAuth2ScopesScopeAliases) throws PortalException {
        long oAuth2ApplicationScopeAliasesId = this.counterLocalService.increment(OAuth2ApplicationScopeAliases.class.getName());
        OAuth2ApplicationScopeAliases oAuth2ApplicationScopeAliases = this.createOAuth2ApplicationScopeAliases(oAuth2ApplicationScopeAliasesId);
        oAuth2ApplicationScopeAliases.setCompanyId(companyId);
        oAuth2ApplicationScopeAliases.setUserId(userId);
        oAuth2ApplicationScopeAliases.setUserName(userName);
        oAuth2ApplicationScopeAliases.setCreateDate(new Date());
        oAuth2ApplicationScopeAliases.setOAuth2ApplicationId(oAuth2ApplicationId);
        oAuth2ApplicationScopeAliases = (OAuth2ApplicationScopeAliases)this.oAuth2ApplicationScopeAliasesPersistence.update((BaseModel)oAuth2ApplicationScopeAliases);
        for (Map.Entry<LiferayOAuth2Scope, List<String>> entry : liferayOAuth2ScopesScopeAliases.entrySet()) {
            LiferayOAuth2Scope liferayOAuth2Scope = entry.getKey();
            Bundle bundle = liferayOAuth2Scope.getBundle();
            this._oAuth2ScopeGrantLocalService.createOAuth2ScopeGrant(companyId, oAuth2ApplicationScopeAliasesId, liferayOAuth2Scope.getApplicationName(), bundle.getSymbolicName(), liferayOAuth2Scope.getScope(), entry.getValue());
        }
        return oAuth2ApplicationScopeAliases;
    }

    private Map<LiferayOAuth2Scope, List<String>> _getLiferayOAuth2ScopesScopeAliases(long companyId, List<String> scopeAliasesList) {
        HashMap<LiferayOAuth2Scope, List<String>> liferayOAuth2ScopesScopeAliases = new HashMap<LiferayOAuth2Scope, List<String>>();
        for (String scopeAlias : ListUtil.sort(scopeAliasesList)) {
            for (LiferayOAuth2Scope liferayOAuth2Scope : this._scopeLocator.getLiferayOAuth2Scopes(companyId, scopeAlias)) {
                List scopeAliases = liferayOAuth2ScopesScopeAliases.computeIfAbsent(liferayOAuth2Scope, x -> new ArrayList());
                scopeAliases.add(scopeAlias);
            }
        }
        return liferayOAuth2ScopesScopeAliases;
    }

    private List<String> _getScopeAliasesList(Collection<OAuth2ScopeGrant> oAuth2ScopeGrants) {
        Stream<OAuth2ScopeGrant> stream = oAuth2ScopeGrants.stream();
        Set scopeAliases = stream.flatMap(oa2sg -> oa2sg.getScopeAliasesList().stream()).collect(Collectors.toSet());
        return new ArrayList<String>(scopeAliases);
    }

    private boolean _hasUpToDateScopeGrants(Collection<OAuth2ScopeGrant> oAuth2ScopeGrants, Map<LiferayOAuth2Scope, List<String>> liferayOAuth2ScopesScopeAliases) {
        if (liferayOAuth2ScopesScopeAliases.size() != oAuth2ScopeGrants.size()) {
            return false;
        }
        oAuth2ScopeGrants = new ArrayList<OAuth2ScopeGrant>(oAuth2ScopeGrants);
        for (Map.Entry<LiferayOAuth2Scope, List<String>> entry : liferayOAuth2ScopesScopeAliases.entrySet()) {
            LiferayOAuth2Scope liferayOAuth2Scope = entry.getKey();
            List<String> scopeAliases = entry.getValue();
            Bundle bundle = liferayOAuth2Scope.getBundle();
            boolean found = oAuth2ScopeGrants.removeIf(oAuth2ScopeGrant -> {
                if (Objects.equals(liferayOAuth2Scope.getApplicationName(), oAuth2ScopeGrant.getApplicationName()) && Objects.equals(bundle.getSymbolicName(), oAuth2ScopeGrant.getBundleSymbolicName()) && Objects.equals(liferayOAuth2Scope.getScope(), oAuth2ScopeGrant.getScope())) {
                    List oAuth2ScopeGrantScopeAliases = oAuth2ScopeGrant.getScopeAliasesList();
                    return oAuth2ScopeGrantScopeAliases.equals(scopeAliases);
                }
                return false;
            });
            if (found) continue;
            return false;
        }
        return true;
    }

    protected static class ScopeNamespace {
        private final String _applicationName;
        private final String _bundleSymbolicName;

        public ScopeNamespace(String applicationName, String bundleSymbolicName) {
            this._applicationName = applicationName;
            this._bundleSymbolicName = bundleSymbolicName;
        }

        public boolean equals(Object object) {
            ScopeNamespace scopeNamespace = (ScopeNamespace)object;
            return Objects.equals(this._applicationName, scopeNamespace._applicationName) && Objects.equals(this._bundleSymbolicName, scopeNamespace._bundleSymbolicName);
        }

        public String getApplicationName() {
            return this._applicationName;
        }

        public String getBundleSymbolicName() {
            return this._bundleSymbolicName;
        }

        public int hashCode() {
            return Objects.hash(this._applicationName, this._bundleSymbolicName);
        }
    }

    protected static class OAuth2ScopeBuilderImpl
    implements OAuth2ScopeBuilder,
    OAuth2ScopeBuilder.ApplicationScope,
    OAuth2ScopeBuilder.ApplicationScopeAssigner {
        private Collection<String> _scopeAliases = new ArrayList<String>();
        private ScopeNamespace _scopeNamespace;
        private final Collection<String> _scopes = new ArrayList<String>();
        private final Map<Map.Entry<ScopeNamespace, String>, List<String>> _simpleEntryScopeAliases;

        public OAuth2ScopeBuilderImpl(Map<Map.Entry<ScopeNamespace, String>, List<String>> simpleEntryScopeAliases) {
            this._simpleEntryScopeAliases = simpleEntryScopeAliases;
        }

        public OAuth2ScopeBuilder.ApplicationScope assignScope(Collection<String> scope) {
            this._flushScopes();
            this._scopes.addAll(scope);
            return this;
        }

        public void forApplication(String applicationName, String bundleSymbolicName, Consumer<OAuth2ScopeBuilder.ApplicationScopeAssigner> applicationScopeAssignerConsumer) {
            this._scopeNamespace = new ScopeNamespace(applicationName, bundleSymbolicName);
            applicationScopeAssignerConsumer.accept(this);
            this._flushScopes();
        }

        public void mapToScopeAlias(Collection<String> scopeAliases) {
            this._scopeAliases = scopeAliases;
        }

        private void _flushScopes() {
            for (String scope : this._scopes) {
                List scopeAliasList = this._simpleEntryScopeAliases.computeIfAbsent(new AbstractMap.SimpleEntry<ScopeNamespace, String>(this._scopeNamespace, scope), s -> new ArrayList());
                for (String scopeAlias : this._scopeAliases) {
                    if (scopeAliasList.contains(scopeAlias)) continue;
                    scopeAliasList.add(scopeAlias);
                }
            }
            this._scopes.clear();
            this._scopeAliases = this._scopes;
        }
    }
}

