/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.internal.upgrade.v4_2_1;

import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;

public class OAuth2ScopeGrantRemoveCompanyIdFromObjectsRelatedUpgradeProcess
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement = this.connection.prepareStatement("select oauth2ScopeGrantId, companyId, applicationName, scopeAliases from OAuth2ScopeGrant where bundleSymbolicName = ?");){
            preparedStatement.setString(1, "com.liferay.object.rest.impl");
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String companyId = String.valueOf(resultSet.getLong("companyId"));
                String applicationName = resultSet.getString("applicationName");
                if (!StringUtil.endsWith((String)applicationName, (String)companyId)) continue;
                String newApplicationName = applicationName.substring(0, applicationName.length() - companyId.length());
                this._updateOAuth2ScopeGrant(newApplicationName, resultSet.getLong("oauth2ScopeGrantId"), TransformUtil.transformToList((Object[])StringUtil.split((String)resultSet.getString("scopeAliases"), (String)" "), scopeAlias -> StringUtil.replace((String)scopeAlias, (String)applicationName, (String)newApplicationName)));
            }
        }
    }

    private void _updateOAuth2ScopeGrant(String applicationName, long oAuth2ScopeGrantId, List<String> scopeAliasesList) throws SQLException {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("update OAuth2ScopeGrant set applicationName = ?,scopeAliases = ? where oAuth2ScopeGrantId = ?");){
            preparedStatement.setString(1, applicationName);
            preparedStatement.setString(2, StringUtil.merge((Collection)ListUtil.sort(scopeAliasesList), (String)" "));
            preparedStatement.setLong(3, oAuth2ScopeGrantId);
            preparedStatement.execute();
        }
    }
}

