/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.internal.upgrade.v3_2_0;

import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class OAuth2ApplicationFeatureUpgradeProcess
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement = this.connection.prepareStatement("select oAuth2ApplicationId, features from OAuth2Application where features is not NULL");
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                Object[] features = StringUtil.split((String)resultSet.getString("features"));
                if (!ArrayUtil.contains((Object[])features, (Object)"token_introspection")) continue;
                long oAuth2ApplicationId = resultSet.getLong("oAuth2ApplicationId");
                this._updateTokenIntrospectionFeature(oAuth2ApplicationId, (String[])features);
            }
        }
    }

    private void _updateTokenIntrospectionFeature(long oAuth2ApplicationId, String[] features) throws SQLException {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("update OAuth2Application set features = ? where oAuth2ApplicationId = ?");){
            for (int i = 0; i < features.length; ++i) {
                if (!features[i].equals("token_introspection")) continue;
                features[i] = "token.introspection";
            }
            preparedStatement.setString(1, StringUtil.merge((Object[])features));
            preparedStatement.setLong(2, oAuth2ApplicationId);
            preparedStatement.execute();
        }
    }
}

