/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.internal.servlet.taglib;

import com.liferay.oauth2.provider.constants.ClientProfile;
import com.liferay.oauth2.provider.model.OAuth2Application;
import com.liferay.oauth2.provider.service.OAuth2ApplicationLocalService;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.servlet.taglib.DynamicInclude;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringBundler;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DynamicInclude.class})
public class OAuth2ProviderTopJSDynamicInclude
implements DynamicInclude {
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private OAuth2ApplicationLocalService _oAuth2ApplicationLocalService;
    @Reference
    private Portal _portal;

    public void include(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String key) throws IOException {
        PrintWriter printWriter = httpServletResponse.getWriter();
        String url = this._portal.getPortalURL(httpServletRequest) + this._portal.getPathContext();
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        List oAuth2Applications = this._oAuth2ApplicationLocalService.getOAuth2Applications(this._portal.getCompanyId(httpServletRequest), ClientProfile.USER_AGENT_APPLICATION.id());
        for (OAuth2Application oAuth2Application : oAuth2Applications) {
            jsonObject.put(oAuth2Application.getExternalReferenceCode(), this._jsonFactory.createJSONObject().put("clientId", oAuth2Application.getClientId()).put("homePageURL", oAuth2Application.getHomePageURL()).put("redirectURIs", this._jsonFactory.createJSONArray((Collection)oAuth2Application.getRedirectURIsList())));
        }
        String string = StringBundler.concat((String[])new String[]{"<script data-senna-track=\"temporary\" type=\"", "text/javascript", "\">window.Liferay = Liferay || {}; window.Liferay.OAuth2 = ", "{getAuthorizeURL: function() {return '", url, "/o/oauth2/authorize';}, getBuiltInRedirectURL: function() ", "{return '", url, "/o/oauth2/redirect';}, getIntrospectURL: function() { return '", url, "/o/oauth2/introspect';}, getTokenURL: function() {return '", url, "/o/oauth2/token';}, getUserAgentApplication: ", "function(externalReferenceCode) {return ", "Liferay.OAuth2._userAgentApplications[externalReferenceCode];}, ", "_userAgentApplications: ", jsonObject.toString(), "}</script>"});
        printWriter.write(string);
    }

    public void register(DynamicInclude.DynamicIncludeRegistry dynamicIncludeRegistry) {
        dynamicIncludeRegistry.register("/html/common/themes/top_js.jspf#resources");
    }
}

