/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.internal.configuration;

import com.liferay.oauth2.provider.configuration.OAuth2ProviderApplicationUserAgentConfiguration;
import com.liferay.oauth2.provider.constants.ClientProfile;
import com.liferay.oauth2.provider.constants.GrantType;
import com.liferay.oauth2.provider.internal.configuration.BaseConfigurationFactory;
import com.liferay.oauth2.provider.model.OAuth2Application;
import com.liferay.oauth2.provider.util.OAuth2SecureRandomGenerator;
import com.liferay.osgi.util.configuration.ConfigurationFactoryUtil;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@Component(configurationPid={"com.liferay.oauth2.provider.configuration.OAuth2ProviderApplicationUserAgentConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true, property={"_portalK8sConfigMapModifier.cardinality.minimum=1"}, service={})
public class OAuth2ProviderApplicationUserAgentConfigurationFactory
extends BaseConfigurationFactory {
    private static final Log _log = LogFactoryUtil.getLog(OAuth2ProviderApplicationUserAgentConfigurationFactory.class);

    @Activate
    protected void activate(Map<String, Object> properties) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Activate " + properties));
        }
        long companyId = ConfigurationFactoryUtil.getCompanyId((CompanyLocalService)this.companyLocalService, properties);
        String externalReferenceCode = ConfigurationFactoryUtil.getExternalReferenceCode(properties);
        OAuth2ProviderApplicationUserAgentConfiguration oAuth2ProviderApplicationUserAgentConfiguration = (OAuth2ProviderApplicationUserAgentConfiguration)ConfigurableUtil.createConfigurable(OAuth2ProviderApplicationUserAgentConfiguration.class, properties);
        Company company = this.companyLocalService.getCompanyById(companyId);
        String serviceAddress = this.getServiceAddress(company);
        List<String> redirectURIsList = Collections.singletonList(serviceAddress.concat("/o/oauth2/redirect"));
        List scopeAliasesList = ListUtil.fromArray((Object[])oAuth2ProviderApplicationUserAgentConfiguration.scopes());
        this.oAuth2Application = this._addOrUpdateOAuth2Application(companyId, externalReferenceCode, oAuth2ProviderApplicationUserAgentConfiguration, redirectURIsList, scopeAliasesList);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("OAuth 2 application " + this.oAuth2Application));
        }
        this.modifyConfigMap(company, HashMapBuilder.put((Object)(externalReferenceCode + ".oauth2.authorization.uri"), (Object)serviceAddress.concat("/o/oauth2/authorize")).put((Object)(externalReferenceCode + ".oauth2.introspection.uri"), (Object)serviceAddress.concat("/o/oauth2/introspect")).put((Object)(externalReferenceCode + ".oauth2.jwks.uri"), (Object)serviceAddress.concat("/o/oauth2/jwks")).put((Object)(externalReferenceCode + ".oauth2.redirect.uris"), (Object)StringUtil.merge(redirectURIsList, (String)"\n")).put((Object)(externalReferenceCode + ".oauth2.token.uri"), (Object)serviceAddress.concat("/o/oauth2/token")).put((Object)(externalReferenceCode + ".oauth2.user.agent.audience"), (Object)this.oAuth2Application.getHomePageURL()).put((Object)(externalReferenceCode + ".oauth2.user.agent.client.id"), (Object)this.oAuth2Application.getClientId()).put((Object)(externalReferenceCode + ".oauth2.user.agent.scopes"), (Object)StringUtil.merge((Collection)scopeAliasesList, (String)"\n")).build(), properties);
    }

    @Override
    protected Log getLog() {
        return _log;
    }

    private OAuth2Application _addOrUpdateOAuth2Application(long companyId, String externalReferenceCode, OAuth2ProviderApplicationUserAgentConfiguration oAuth2ProviderApplicationUserAgentConfiguration, List<String> redirectURIsList, List<String> scopeAliasesList) throws Exception {
        User user = this.userLocalService.getDefaultUser(companyId);
        OAuth2Application oAuth2Application = this.oAuth2ApplicationLocalService.addOrUpdateOAuth2Application(externalReferenceCode, user.getUserId(), user.getScreenName(), ListUtil.fromArray((Object[])new GrantType[]{GrantType.AUTHORIZATION_CODE_PKCE, GrantType.JWT_BEARER}), "none", user.getUserId(), OAuth2SecureRandomGenerator.generateClientId(), ClientProfile.USER_AGENT_APPLICATION.id(), null, oAuth2ProviderApplicationUserAgentConfiguration.description(), Arrays.asList("token.introspection"), oAuth2ProviderApplicationUserAgentConfiguration.homePageURL(), 0L, null, externalReferenceCode, oAuth2ProviderApplicationUserAgentConfiguration.privacyPolicyURL(), redirectURIsList, false, true, null, new ServiceContext());
        oAuth2Application = this.oAuth2ApplicationLocalService.updateScopeAliases(oAuth2Application.getUserId(), oAuth2Application.getUserName(), oAuth2Application.getOAuth2ApplicationId(), scopeAliasesList);
        Class<?> clazz = this.getClass();
        return this.oAuth2ApplicationLocalService.updateIcon(oAuth2Application.getOAuth2ApplicationId(), clazz.getResourceAsStream("dependencies/logo.png"));
    }
}

