/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.internal.configuration;

import com.liferay.oauth2.provider.configuration.OAuth2ProviderApplicationHeadlessServerConfiguration;
import com.liferay.oauth2.provider.constants.ClientProfile;
import com.liferay.oauth2.provider.constants.GrantType;
import com.liferay.oauth2.provider.internal.configuration.BaseConfigurationFactory;
import com.liferay.oauth2.provider.model.OAuth2Application;
import com.liferay.oauth2.provider.util.OAuth2SecureRandomGenerator;
import com.liferay.osgi.util.configuration.ConfigurationFactoryUtil;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@Component(configurationPid={"com.liferay.oauth2.provider.configuration.OAuth2ProviderApplicationHeadlessServerConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true, property={"_portalK8sConfigMapModifier.cardinality.minimum=1"}, service={})
public class OAuth2ProviderApplicationHeadlessServerConfigurationFactory
extends BaseConfigurationFactory {
    private static final String _COMPANY_DEFAULT_USER_TOKEN = "<company.default.user>";
    private static final Log _log = LogFactoryUtil.getLog(OAuth2ProviderApplicationHeadlessServerConfigurationFactory.class);

    @Activate
    protected void activate(Map<String, Object> properties) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Activate " + properties));
        }
        long companyId = ConfigurationFactoryUtil.getCompanyId((CompanyLocalService)this.companyLocalService, properties);
        String externalReferenceCode = ConfigurationFactoryUtil.getExternalReferenceCode(properties);
        OAuth2ProviderApplicationHeadlessServerConfiguration oAuth2ProviderApplicationHeadlessServerConfiguration = (OAuth2ProviderApplicationHeadlessServerConfiguration)ConfigurableUtil.createConfigurable(OAuth2ProviderApplicationHeadlessServerConfiguration.class, properties);
        List scopeAliasesList = ListUtil.fromArray((Object[])oAuth2ProviderApplicationHeadlessServerConfiguration.scopes());
        this.oAuth2Application = this._addOrUpdateOAuth2Application(companyId, externalReferenceCode, oAuth2ProviderApplicationHeadlessServerConfiguration, scopeAliasesList);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("OAuth 2 application " + this.oAuth2Application));
        }
        Company company = this.companyLocalService.getCompanyById(companyId);
        String serviceAddress = this.getServiceAddress(company);
        this.modifyConfigMap(company, HashMapBuilder.put((Object)(externalReferenceCode + ".oauth2.authorization.uri"), (Object)serviceAddress.concat("/o/oauth2/authorize")).put((Object)(externalReferenceCode + ".oauth2.headless.server.audience"), (Object)this.oAuth2Application.getHomePageURL()).put((Object)(externalReferenceCode + ".oauth2.headless.server.client.id"), (Object)this.oAuth2Application.getClientId()).put((Object)(externalReferenceCode + ".oauth2.headless.server.client.secret"), (Object)this.oAuth2Application.getClientSecret()).put((Object)(externalReferenceCode + ".oauth2.headless.server.scopes"), (Object)StringUtil.merge((Collection)scopeAliasesList, (String)"\n")).put((Object)(externalReferenceCode + ".oauth2.introspection.uri"), (Object)serviceAddress.concat("/o/oauth2/introspect")).put((Object)(externalReferenceCode + ".oauth2.jwks.uri"), (Object)serviceAddress.concat("/o/oauth2/jwks")).put((Object)(externalReferenceCode + ".oauth2.token.uri"), (Object)serviceAddress.concat("/o/oauth2/token")).build(), properties);
    }

    @Override
    protected Log getLog() {
        return _log;
    }

    private OAuth2Application _addOrUpdateOAuth2Application(long companyId, String externalReferenceCode, OAuth2ProviderApplicationHeadlessServerConfiguration oAuth2ProviderApplicationHeadlessServerConfiguration, List<String> scopeAliasesList) throws Exception {
        String userAccountEmailAddress = oAuth2ProviderApplicationHeadlessServerConfiguration.userAccountEmailAddress();
        if (!Objects.equals(_COMPANY_DEFAULT_USER_TOKEN, userAccountEmailAddress) && !Validator.isEmailAddress((String)userAccountEmailAddress)) {
            throw new IllegalArgumentException("User account email address must be a valid email address or <company.default.user>");
        }
        User user = this.userLocalService.getDefaultUser(companyId);
        User serviceUser = null;
        serviceUser = Objects.equals(_COMPANY_DEFAULT_USER_TOKEN, userAccountEmailAddress) ? user : this.userLocalService.getUserByEmailAddress(companyId, userAccountEmailAddress);
        OAuth2Application oAuth2Application = this.oAuth2ApplicationLocalService.addOrUpdateOAuth2Application(externalReferenceCode, user.getUserId(), user.getScreenName(), ListUtil.fromArray((Object[])new GrantType[]{GrantType.CLIENT_CREDENTIALS, GrantType.JWT_BEARER}), "client_secret_post", serviceUser.getUserId(), OAuth2SecureRandomGenerator.generateClientId(), ClientProfile.HEADLESS_SERVER.id(), OAuth2SecureRandomGenerator.generateClientSecret(), oAuth2ProviderApplicationHeadlessServerConfiguration.description(), Arrays.asList("token.introspection"), oAuth2ProviderApplicationHeadlessServerConfiguration.homePageURL(), 0L, null, externalReferenceCode, oAuth2ProviderApplicationHeadlessServerConfiguration.privacyPolicyURL(), Collections.emptyList(), false, true, null, new ServiceContext());
        oAuth2Application = this.oAuth2ApplicationLocalService.updateScopeAliases(oAuth2Application.getUserId(), oAuth2Application.getUserName(), oAuth2Application.getOAuth2ApplicationId(), scopeAliasesList);
        Class<?> clazz = this.getClass();
        return this.oAuth2ApplicationLocalService.updateIcon(oAuth2Application.getOAuth2ApplicationId(), clazz.getResourceAsStream("dependencies/logo.png"));
    }
}

