/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.internal.configuration;

import com.liferay.oauth2.provider.model.OAuth2Application;
import com.liferay.oauth2.provider.service.OAuth2ApplicationLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.k8s.agent.PortalK8sConfigMapModifier;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Map;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

public abstract class BaseConfigurationFactory {
    @Reference
    protected CompanyLocalService companyLocalService;
    @Reference(target="(module.service.lifecycle=portal.initialized)")
    protected ModuleServiceLifecycle moduleServiceLifecycle;
    protected volatile OAuth2Application oAuth2Application;
    @Reference
    protected OAuth2ApplicationLocalService oAuth2ApplicationLocalService;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL)
    protected PortalK8sConfigMapModifier portalK8sConfigMapModifier;
    @Reference
    protected UserLocalService userLocalService;
    private volatile String _configMapName;
    private volatile Map<String, String> _extensionProperties;

    @Deactivate
    protected void deactivate(Integer reason) throws PortalException {
        if (reason != 4) {
            return;
        }
        Log log = this.getLog();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deactivating " + this.oAuth2Application));
        }
        this.oAuth2ApplicationLocalService.deleteOAuth2Application(this.oAuth2Application);
        if (Validator.isNotNull((String)this._configMapName)) {
            this.portalK8sConfigMapModifier.modifyConfigMap(configMapModel -> this._extensionProperties.forEach(configMapModel.data()::remove), this._configMapName);
        }
    }

    protected abstract Log getLog();

    protected String getServiceAddress(Company company) {
        return "https://".concat(company.getVirtualHostname());
    }

    protected void modifyConfigMap(Company company, Map<String, String> extensionProperties, Map<String, Object> properties) {
        this._extensionProperties = extensionProperties;
        String serviceId = GetterUtil.getString((Object)properties.get("ext.lxc.liferay.com.serviceId"));
        if (this.portalK8sConfigMapModifier == null || Validator.isNull((String)serviceId)) {
            return;
        }
        this._configMapName = StringBundler.concat((String[])new String[]{serviceId, "-", company.getWebId(), "-lxc-ext-init-metadata"});
        this.portalK8sConfigMapModifier.modifyConfigMap(configMapModel -> {
            Map data = configMapModel.data();
            extensionProperties.forEach(data::put);
            Map labels = configMapModel.labels();
            labels.put("dxp.lxc.liferay.com/virtualInstanceId", company.getWebId());
            labels.put("ext.lxc.liferay.com/projectId", GetterUtil.getString(properties.get("ext.lxc.liferay.com.projectId")));
            labels.put("ext.lxc.liferay.com/projectUid", GetterUtil.getString(properties.get("ext.lxc.liferay.com.projectUid")));
            labels.put("ext.lxc.liferay.com/serviceId", GetterUtil.getString(properties.get("ext.lxc.liferay.com.serviceId")));
            labels.put("ext.lxc.liferay.com/serviceUid", GetterUtil.getString(properties.get("ext.lxc.liferay.com.serviceUid")));
            labels.put("lxc.liferay.com/metadataType", "ext-init");
        }, this._configMapName);
    }
}

