/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.oauth2.provider.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.oauth2.provider.model.OAuth2ScopeGrant;
import com.liferay.oauth2.provider.model.OAuth2ScopeGrantModel;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;

import java.io.Serializable;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;

import java.sql.Types;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model implementation for the OAuth2ScopeGrant service. Represents a row in the &quot;OAuth2ScopeGrant&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface </code>OAuth2ScopeGrantModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link OAuth2ScopeGrantImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see OAuth2ScopeGrantImpl
 * @generated
 */
@ProviderType
public class OAuth2ScopeGrantModelImpl
	extends BaseModelImpl<OAuth2ScopeGrant> implements OAuth2ScopeGrantModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a o auth2 scope grant model instance should use the <code>OAuth2ScopeGrant</code> interface instead.
	 */
	public static final String TABLE_NAME = "OAuth2ScopeGrant";

	public static final Object[][] TABLE_COLUMNS = {
		{"oAuth2ScopeGrantId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"oA2AScopeAliasesId", Types.BIGINT},
		{"applicationName", Types.VARCHAR},
		{"bundleSymbolicName", Types.VARCHAR}, {"scope", Types.VARCHAR},
		{"scopeAliases", Types.CLOB}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("oAuth2ScopeGrantId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("oA2AScopeAliasesId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("applicationName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("bundleSymbolicName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("scope", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("scopeAliases", Types.CLOB);
	}

	public static final String TABLE_SQL_CREATE =
		"create table OAuth2ScopeGrant (oAuth2ScopeGrantId LONG not null primary key,companyId LONG,oA2AScopeAliasesId LONG,applicationName VARCHAR(255) null,bundleSymbolicName VARCHAR(255) null,scope VARCHAR(240) null,scopeAliases TEXT null)";

	public static final String TABLE_SQL_DROP = "drop table OAuth2ScopeGrant";

	public static final String ORDER_BY_JPQL =
		" ORDER BY oAuth2ScopeGrant.oAuth2ScopeGrantId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY OAuth2ScopeGrant.oAuth2ScopeGrantId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	public static final long APPLICATIONNAME_COLUMN_BITMASK = 1L;

	public static final long BUNDLESYMBOLICNAME_COLUMN_BITMASK = 2L;

	public static final long COMPANYID_COLUMN_BITMASK = 4L;

	public static final long OAUTH2APPLICATIONSCOPEALIASESID_COLUMN_BITMASK =
		8L;

	public static final long SCOPE_COLUMN_BITMASK = 16L;

	public static final long OAUTH2SCOPEGRANTID_COLUMN_BITMASK = 32L;

	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
		_entityCacheEnabled = entityCacheEnabled;
	}

	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
		_finderCacheEnabled = finderCacheEnabled;
	}

	public static final String MAPPING_TABLE_OA2AUTHS_OA2SCOPEGRANTS_NAME =
		"OA2Auths_OA2ScopeGrants";

	public static final Object[][]
		MAPPING_TABLE_OA2AUTHS_OA2SCOPEGRANTS_COLUMNS = {
			{"companyId", Types.BIGINT},
			{"oAuth2AuthorizationId", Types.BIGINT},
			{"oAuth2ScopeGrantId", Types.BIGINT}
		};

	public static final String
		MAPPING_TABLE_OA2AUTHS_OA2SCOPEGRANTS_SQL_CREATE =
			"create table OA2Auths_OA2ScopeGrants (companyId LONG not null,oAuth2AuthorizationId LONG not null,oAuth2ScopeGrantId LONG not null,primary key (oAuth2AuthorizationId, oAuth2ScopeGrantId))";

	public OAuth2ScopeGrantModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _oAuth2ScopeGrantId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setOAuth2ScopeGrantId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _oAuth2ScopeGrantId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return OAuth2ScopeGrant.class;
	}

	@Override
	public String getModelClassName() {
		return OAuth2ScopeGrant.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<OAuth2ScopeGrant, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<OAuth2ScopeGrant, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<OAuth2ScopeGrant, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((OAuth2ScopeGrant)this));
		}

		attributes.put("entityCacheEnabled", isEntityCacheEnabled());
		attributes.put("finderCacheEnabled", isFinderCacheEnabled());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<OAuth2ScopeGrant, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<OAuth2ScopeGrant, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(OAuth2ScopeGrant)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<OAuth2ScopeGrant, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<OAuth2ScopeGrant, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static Function<InvocationHandler, OAuth2ScopeGrant>
		_getProxyProviderFunction() {

		Class<?> proxyClass = ProxyUtil.getProxyClass(
			OAuth2ScopeGrant.class.getClassLoader(), OAuth2ScopeGrant.class,
			ModelWrapper.class);

		try {
			Constructor<OAuth2ScopeGrant> constructor =
				(Constructor<OAuth2ScopeGrant>)proxyClass.getConstructor(
					InvocationHandler.class);

			return invocationHandler -> {
				try {
					return constructor.newInstance(invocationHandler);
				}
				catch (ReflectiveOperationException roe) {
					throw new InternalError(roe);
				}
			};
		}
		catch (NoSuchMethodException nsme) {
			throw new InternalError(nsme);
		}
	}

	private static final Map<String, Function<OAuth2ScopeGrant, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<OAuth2ScopeGrant, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<OAuth2ScopeGrant, Object>>
			attributeGetterFunctions =
				new LinkedHashMap<String, Function<OAuth2ScopeGrant, Object>>();
		Map<String, BiConsumer<OAuth2ScopeGrant, ?>>
			attributeSetterBiConsumers =
				new LinkedHashMap<String, BiConsumer<OAuth2ScopeGrant, ?>>();

		attributeGetterFunctions.put(
			"oAuth2ScopeGrantId", OAuth2ScopeGrant::getOAuth2ScopeGrantId);
		attributeSetterBiConsumers.put(
			"oAuth2ScopeGrantId",
			(BiConsumer<OAuth2ScopeGrant, Long>)
				OAuth2ScopeGrant::setOAuth2ScopeGrantId);
		attributeGetterFunctions.put(
			"companyId", OAuth2ScopeGrant::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<OAuth2ScopeGrant, Long>)OAuth2ScopeGrant::setCompanyId);
		attributeGetterFunctions.put(
			"oAuth2ApplicationScopeAliasesId",
			OAuth2ScopeGrant::getOAuth2ApplicationScopeAliasesId);
		attributeSetterBiConsumers.put(
			"oAuth2ApplicationScopeAliasesId",
			(BiConsumer<OAuth2ScopeGrant, Long>)
				OAuth2ScopeGrant::setOAuth2ApplicationScopeAliasesId);
		attributeGetterFunctions.put(
			"applicationName", OAuth2ScopeGrant::getApplicationName);
		attributeSetterBiConsumers.put(
			"applicationName",
			(BiConsumer<OAuth2ScopeGrant, String>)
				OAuth2ScopeGrant::setApplicationName);
		attributeGetterFunctions.put(
			"bundleSymbolicName", OAuth2ScopeGrant::getBundleSymbolicName);
		attributeSetterBiConsumers.put(
			"bundleSymbolicName",
			(BiConsumer<OAuth2ScopeGrant, String>)
				OAuth2ScopeGrant::setBundleSymbolicName);
		attributeGetterFunctions.put("scope", OAuth2ScopeGrant::getScope);
		attributeSetterBiConsumers.put(
			"scope",
			(BiConsumer<OAuth2ScopeGrant, String>)OAuth2ScopeGrant::setScope);
		attributeGetterFunctions.put(
			"scopeAliases", OAuth2ScopeGrant::getScopeAliases);
		attributeSetterBiConsumers.put(
			"scopeAliases",
			(BiConsumer<OAuth2ScopeGrant, String>)
				OAuth2ScopeGrant::setScopeAliases);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@Override
	public long getOAuth2ScopeGrantId() {
		return _oAuth2ScopeGrantId;
	}

	@Override
	public void setOAuth2ScopeGrantId(long oAuth2ScopeGrantId) {
		_oAuth2ScopeGrantId = oAuth2ScopeGrantId;
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		_columnBitmask |= COMPANYID_COLUMN_BITMASK;

		if (!_setOriginalCompanyId) {
			_setOriginalCompanyId = true;

			_originalCompanyId = _companyId;
		}

		_companyId = companyId;
	}

	public long getOriginalCompanyId() {
		return _originalCompanyId;
	}

	@Override
	public long getOAuth2ApplicationScopeAliasesId() {
		return _oAuth2ApplicationScopeAliasesId;
	}

	@Override
	public void setOAuth2ApplicationScopeAliasesId(
		long oAuth2ApplicationScopeAliasesId) {

		_columnBitmask |= OAUTH2APPLICATIONSCOPEALIASESID_COLUMN_BITMASK;

		if (!_setOriginalOAuth2ApplicationScopeAliasesId) {
			_setOriginalOAuth2ApplicationScopeAliasesId = true;

			_originalOAuth2ApplicationScopeAliasesId =
				_oAuth2ApplicationScopeAliasesId;
		}

		_oAuth2ApplicationScopeAliasesId = oAuth2ApplicationScopeAliasesId;
	}

	public long getOriginalOAuth2ApplicationScopeAliasesId() {
		return _originalOAuth2ApplicationScopeAliasesId;
	}

	@Override
	public String getApplicationName() {
		if (_applicationName == null) {
			return "";
		}
		else {
			return _applicationName;
		}
	}

	@Override
	public void setApplicationName(String applicationName) {
		_columnBitmask |= APPLICATIONNAME_COLUMN_BITMASK;

		if (_originalApplicationName == null) {
			_originalApplicationName = _applicationName;
		}

		_applicationName = applicationName;
	}

	public String getOriginalApplicationName() {
		return GetterUtil.getString(_originalApplicationName);
	}

	@Override
	public String getBundleSymbolicName() {
		if (_bundleSymbolicName == null) {
			return "";
		}
		else {
			return _bundleSymbolicName;
		}
	}

	@Override
	public void setBundleSymbolicName(String bundleSymbolicName) {
		_columnBitmask |= BUNDLESYMBOLICNAME_COLUMN_BITMASK;

		if (_originalBundleSymbolicName == null) {
			_originalBundleSymbolicName = _bundleSymbolicName;
		}

		_bundleSymbolicName = bundleSymbolicName;
	}

	public String getOriginalBundleSymbolicName() {
		return GetterUtil.getString(_originalBundleSymbolicName);
	}

	@Override
	public String getScope() {
		if (_scope == null) {
			return "";
		}
		else {
			return _scope;
		}
	}

	@Override
	public void setScope(String scope) {
		_columnBitmask |= SCOPE_COLUMN_BITMASK;

		if (_originalScope == null) {
			_originalScope = _scope;
		}

		_scope = scope;
	}

	public String getOriginalScope() {
		return GetterUtil.getString(_originalScope);
	}

	@Override
	public String getScopeAliases() {
		if (_scopeAliases == null) {
			return "";
		}
		else {
			return _scopeAliases;
		}
	}

	@Override
	public void setScopeAliases(String scopeAliases) {
		_scopeAliases = scopeAliases;
	}

	public long getColumnBitmask() {
		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), OAuth2ScopeGrant.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public OAuth2ScopeGrant toEscapedModel() {
		if (_escapedModel == null) {
			_escapedModel = _escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		OAuth2ScopeGrantImpl oAuth2ScopeGrantImpl = new OAuth2ScopeGrantImpl();

		oAuth2ScopeGrantImpl.setOAuth2ScopeGrantId(getOAuth2ScopeGrantId());
		oAuth2ScopeGrantImpl.setCompanyId(getCompanyId());
		oAuth2ScopeGrantImpl.setOAuth2ApplicationScopeAliasesId(
			getOAuth2ApplicationScopeAliasesId());
		oAuth2ScopeGrantImpl.setApplicationName(getApplicationName());
		oAuth2ScopeGrantImpl.setBundleSymbolicName(getBundleSymbolicName());
		oAuth2ScopeGrantImpl.setScope(getScope());
		oAuth2ScopeGrantImpl.setScopeAliases(getScopeAliases());

		oAuth2ScopeGrantImpl.resetOriginalValues();

		return oAuth2ScopeGrantImpl;
	}

	@Override
	public int compareTo(OAuth2ScopeGrant oAuth2ScopeGrant) {
		long primaryKey = oAuth2ScopeGrant.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}

		if (!(obj instanceof OAuth2ScopeGrant)) {
			return false;
		}

		OAuth2ScopeGrant oAuth2ScopeGrant = (OAuth2ScopeGrant)obj;

		long primaryKey = oAuth2ScopeGrant.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	@Override
	public boolean isEntityCacheEnabled() {
		return _entityCacheEnabled;
	}

	@Override
	public boolean isFinderCacheEnabled() {
		return _finderCacheEnabled;
	}

	@Override
	public void resetOriginalValues() {
		OAuth2ScopeGrantModelImpl oAuth2ScopeGrantModelImpl = this;

		oAuth2ScopeGrantModelImpl._originalCompanyId =
			oAuth2ScopeGrantModelImpl._companyId;

		oAuth2ScopeGrantModelImpl._setOriginalCompanyId = false;

		oAuth2ScopeGrantModelImpl._originalOAuth2ApplicationScopeAliasesId =
			oAuth2ScopeGrantModelImpl._oAuth2ApplicationScopeAliasesId;

		oAuth2ScopeGrantModelImpl._setOriginalOAuth2ApplicationScopeAliasesId =
			false;

		oAuth2ScopeGrantModelImpl._originalApplicationName =
			oAuth2ScopeGrantModelImpl._applicationName;

		oAuth2ScopeGrantModelImpl._originalBundleSymbolicName =
			oAuth2ScopeGrantModelImpl._bundleSymbolicName;

		oAuth2ScopeGrantModelImpl._originalScope =
			oAuth2ScopeGrantModelImpl._scope;

		oAuth2ScopeGrantModelImpl._columnBitmask = 0;
	}

	@Override
	public CacheModel<OAuth2ScopeGrant> toCacheModel() {
		OAuth2ScopeGrantCacheModel oAuth2ScopeGrantCacheModel =
			new OAuth2ScopeGrantCacheModel();

		oAuth2ScopeGrantCacheModel.oAuth2ScopeGrantId = getOAuth2ScopeGrantId();

		oAuth2ScopeGrantCacheModel.companyId = getCompanyId();

		oAuth2ScopeGrantCacheModel.oAuth2ApplicationScopeAliasesId =
			getOAuth2ApplicationScopeAliasesId();

		oAuth2ScopeGrantCacheModel.applicationName = getApplicationName();

		String applicationName = oAuth2ScopeGrantCacheModel.applicationName;

		if ((applicationName != null) && (applicationName.length() == 0)) {
			oAuth2ScopeGrantCacheModel.applicationName = null;
		}

		oAuth2ScopeGrantCacheModel.bundleSymbolicName = getBundleSymbolicName();

		String bundleSymbolicName =
			oAuth2ScopeGrantCacheModel.bundleSymbolicName;

		if ((bundleSymbolicName != null) &&
			(bundleSymbolicName.length() == 0)) {

			oAuth2ScopeGrantCacheModel.bundleSymbolicName = null;
		}

		oAuth2ScopeGrantCacheModel.scope = getScope();

		String scope = oAuth2ScopeGrantCacheModel.scope;

		if ((scope != null) && (scope.length() == 0)) {
			oAuth2ScopeGrantCacheModel.scope = null;
		}

		oAuth2ScopeGrantCacheModel.scopeAliases = getScopeAliases();

		String scopeAliases = oAuth2ScopeGrantCacheModel.scopeAliases;

		if ((scopeAliases != null) && (scopeAliases.length() == 0)) {
			oAuth2ScopeGrantCacheModel.scopeAliases = null;
		}

		return oAuth2ScopeGrantCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<OAuth2ScopeGrant, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			4 * attributeGetterFunctions.size() + 2);

		sb.append("{");

		for (Map.Entry<String, Function<OAuth2ScopeGrant, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<OAuth2ScopeGrant, Object> attributeGetterFunction =
				entry.getValue();

			sb.append(attributeName);
			sb.append("=");
			sb.append(attributeGetterFunction.apply((OAuth2ScopeGrant)this));
			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<OAuth2ScopeGrant, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			5 * attributeGetterFunctions.size() + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<OAuth2ScopeGrant, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<OAuth2ScopeGrant, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(attributeGetterFunction.apply((OAuth2ScopeGrant)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static final Function<InvocationHandler, OAuth2ScopeGrant>
		_escapedModelProxyProviderFunction = _getProxyProviderFunction();
	private static boolean _entityCacheEnabled;
	private static boolean _finderCacheEnabled;

	private long _oAuth2ScopeGrantId;
	private long _companyId;
	private long _originalCompanyId;
	private boolean _setOriginalCompanyId;
	private long _oAuth2ApplicationScopeAliasesId;
	private long _originalOAuth2ApplicationScopeAliasesId;
	private boolean _setOriginalOAuth2ApplicationScopeAliasesId;
	private String _applicationName;
	private String _originalApplicationName;
	private String _bundleSymbolicName;
	private String _originalBundleSymbolicName;
	private String _scope;
	private String _originalScope;
	private String _scopeAliases;
	private long _columnBitmask;
	private OAuth2ScopeGrant _escapedModel;

}