/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.service.impl;

import com.liferay.oauth2.provider.model.OAuth2ApplicationScopeAliases;
import com.liferay.oauth2.provider.model.OAuth2ScopeGrant;
import com.liferay.oauth2.provider.scope.liferay.LiferayOAuth2Scope;
import com.liferay.oauth2.provider.scope.liferay.ScopeLocator;
import com.liferay.oauth2.provider.service.base.OAuth2ApplicationScopeAliasesLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.osgi.framework.Bundle;

public class OAuth2ApplicationScopeAliasesLocalServiceImpl
extends OAuth2ApplicationScopeAliasesLocalServiceBaseImpl {
    @ServiceReference(type=ScopeLocator.class)
    private ScopeLocator _scopeLocator;

    public OAuth2ApplicationScopeAliases addOAuth2ApplicationScopeAliases(long companyId, long userId, String userName, long oAuth2ApplicationId, List<String> scopeAliasesList) throws PortalException {
        long oAuth2ApplicationScopeAliasesId = this.counterLocalService.increment(OAuth2ApplicationScopeAliases.class.getName());
        OAuth2ApplicationScopeAliases oAuth2ApplicationScopeAliases = this.createOAuth2ApplicationScopeAliases(oAuth2ApplicationScopeAliasesId);
        oAuth2ApplicationScopeAliases.setCompanyId(companyId);
        oAuth2ApplicationScopeAliases.setUserId(userId);
        oAuth2ApplicationScopeAliases.setUserName(userName);
        oAuth2ApplicationScopeAliases.setCreateDate(new Date());
        oAuth2ApplicationScopeAliases.setOAuth2ApplicationId(oAuth2ApplicationId);
        oAuth2ApplicationScopeAliases.setScopeAliasesList(scopeAliasesList);
        oAuth2ApplicationScopeAliases = (OAuth2ApplicationScopeAliases)this.oAuth2ApplicationScopeAliasesPersistence.update((BaseModel)oAuth2ApplicationScopeAliases);
        this.createScopeGrants(companyId, oAuth2ApplicationScopeAliasesId, scopeAliasesList);
        return oAuth2ApplicationScopeAliases;
    }

    @Override
    public OAuth2ApplicationScopeAliases deleteOAuth2ApplicationScopeAliases(long oAuth2ApplicationScopeAliasesId) throws PortalException {
        Collection oAuth2ScopeGrants = this.oAuth2ScopeGrantLocalService.getOAuth2ScopeGrants(oAuth2ApplicationScopeAliasesId, -1, -1, null);
        for (OAuth2ScopeGrant oAuth2ScopeGrant : oAuth2ScopeGrants) {
            this.oAuth2ScopeGrantLocalService.deleteOAuth2ScopeGrant(oAuth2ScopeGrant.getOAuth2ScopeGrantId());
        }
        return this.oAuth2ApplicationScopeAliasesPersistence.remove(oAuth2ApplicationScopeAliasesId);
    }

    public OAuth2ApplicationScopeAliases fetchOAuth2ApplicationScopeAliases(long oAuth2ApplicationId, List<String> scopeAliasesList) {
        String scopeAliases = StringUtil.merge((Collection)ListUtil.sort(scopeAliasesList), (String)" ");
        List oAuth2ApplicationScopeAliasesList = this.oAuth2ApplicationScopeAliasesPersistence.findByO_S(oAuth2ApplicationId, (long)scopeAliases.hashCode());
        for (OAuth2ApplicationScopeAliases oAuth2ApplicationScopeAliases : oAuth2ApplicationScopeAliasesList) {
            if (!scopeAliases.equals(oAuth2ApplicationScopeAliases.getScopeAliases())) continue;
            return oAuth2ApplicationScopeAliases;
        }
        return null;
    }

    public List<OAuth2ApplicationScopeAliases> getOAuth2ApplicationScopeAliaseses(long oAuth2ApplicationId, int start, int end, OrderByComparator<OAuth2ApplicationScopeAliases> orderByComparator) {
        return this.oAuth2ApplicationScopeAliasesPersistence.findByOAuth2ApplicationId(oAuth2ApplicationId, start, end, orderByComparator);
    }

    protected void createScopeGrants(long companyId, long oAuth2ApplicationScopeAliasesId, List<String> scopeAliasesList) throws PortalException {
        HashSet liferayOAuth2Scopes = new HashSet();
        for (String scopeAlias : scopeAliasesList) {
            liferayOAuth2Scopes.addAll(this._scopeLocator.getLiferayOAuth2Scopes(companyId, scopeAlias));
        }
        for (LiferayOAuth2Scope liferayOAuth2Scope : liferayOAuth2Scopes) {
            Bundle bundle = liferayOAuth2Scope.getBundle();
            this.oAuth2ScopeGrantLocalService.createOAuth2ScopeGrant(companyId, oAuth2ApplicationScopeAliasesId, liferayOAuth2Scope.getApplicationName(), bundle.getSymbolicName(), liferayOAuth2Scope.getScope());
        }
    }
}

