/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.model.impl;

import aQute.bnd.annotation.ProviderType;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.oauth2.provider.model.OAuth2Authorization;
import com.liferay.oauth2.provider.model.OAuth2AuthorizationModel;
import com.liferay.oauth2.provider.model.OAuth2AuthorizationSoap;
import com.liferay.oauth2.provider.model.impl.OAuth2AuthorizationCacheModel;
import com.liferay.oauth2.provider.model.impl.OAuth2AuthorizationImpl;
import com.liferay.oauth2.provider.service.util.ServiceProps;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@ProviderType
public class OAuth2AuthorizationModelImpl
extends BaseModelImpl<OAuth2Authorization>
implements OAuth2AuthorizationModel {
    public static final String TABLE_NAME = "OAuth2Authorization";
    public static final Object[][] TABLE_COLUMNS = new Object[][]{{"oAuth2AuthorizationId", -5}, {"companyId", -5}, {"userId", -5}, {"userName", 12}, {"createDate", 93}, {"oAuth2ApplicationId", -5}, {"oA2AScopeAliasesId", -5}, {"accessTokenContent", 2005}, {"accessTokenContentHash", -5}, {"accessTokenCreateDate", 93}, {"accessTokenExpirationDate", 93}, {"remoteIPInfo", 12}, {"refreshTokenContent", 2005}, {"refreshTokenContentHash", -5}, {"refreshTokenCreateDate", 93}, {"refreshTokenExpirationDate", 93}};
    public static final Map<String, Integer> TABLE_COLUMNS_MAP = new HashMap<String, Integer>();
    public static final String TABLE_SQL_CREATE = "create table OAuth2Authorization (oAuth2AuthorizationId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,oAuth2ApplicationId LONG,oA2AScopeAliasesId LONG,accessTokenContent TEXT null,accessTokenContentHash LONG,accessTokenCreateDate DATE null,accessTokenExpirationDate DATE null,remoteIPInfo VARCHAR(75) null,refreshTokenContent TEXT null,refreshTokenContentHash LONG,refreshTokenCreateDate DATE null,refreshTokenExpirationDate DATE null)";
    public static final String TABLE_SQL_DROP = "drop table OAuth2Authorization";
    public static final String ORDER_BY_JPQL = " ORDER BY oAuth2Authorization.oAuth2AuthorizationId ASC";
    public static final String ORDER_BY_SQL = " ORDER BY OAuth2Authorization.oAuth2AuthorizationId ASC";
    public static final String DATA_SOURCE = "liferayDataSource";
    public static final String SESSION_FACTORY = "liferaySessionFactory";
    public static final String TX_MANAGER = "liferayTransactionManager";
    public static final boolean ENTITY_CACHE_ENABLED;
    public static final boolean FINDER_CACHE_ENABLED;
    public static final boolean COLUMN_BITMASK_ENABLED;
    public static final long ACCESSTOKENCONTENTHASH_COLUMN_BITMASK = 1L;
    public static final long OAUTH2APPLICATIONID_COLUMN_BITMASK = 2L;
    public static final long REFRESHTOKENCONTENTHASH_COLUMN_BITMASK = 4L;
    public static final long USERID_COLUMN_BITMASK = 8L;
    public static final long OAUTH2AUTHORIZATIONID_COLUMN_BITMASK = 16L;
    public static final String MAPPING_TABLE_OA2AUTHS_OA2SCOPEGRANTS_NAME = "OA2Auths_OA2ScopeGrants";
    public static final Object[][] MAPPING_TABLE_OA2AUTHS_OA2SCOPEGRANTS_COLUMNS;
    public static final String MAPPING_TABLE_OA2AUTHS_OA2SCOPEGRANTS_SQL_CREATE = "create table OA2Auths_OA2ScopeGrants (companyId LONG not null,oAuth2AuthorizationId LONG not null,oAuth2ScopeGrantId LONG not null,primary key (oAuth2AuthorizationId, oAuth2ScopeGrantId))";
    public static final boolean FINDER_CACHE_ENABLED_OA2AUTHS_OA2SCOPEGRANTS;
    public static final long LOCK_EXPIRATION_TIME;
    private static final ClassLoader _classLoader;
    private static final Class<?>[] _escapedModelInterfaces;
    private long _oAuth2AuthorizationId;
    private long _companyId;
    private long _userId;
    private long _originalUserId;
    private boolean _setOriginalUserId;
    private String _userName;
    private Date _createDate;
    private long _oAuth2ApplicationId;
    private long _originalOAuth2ApplicationId;
    private boolean _setOriginalOAuth2ApplicationId;
    private long _oAuth2ApplicationScopeAliasesId;
    private String _accessTokenContent;
    private long _accessTokenContentHash;
    private long _originalAccessTokenContentHash;
    private boolean _setOriginalAccessTokenContentHash;
    private Date _accessTokenCreateDate;
    private Date _accessTokenExpirationDate;
    private String _remoteIPInfo;
    private String _refreshTokenContent;
    private long _refreshTokenContentHash;
    private long _originalRefreshTokenContentHash;
    private boolean _setOriginalRefreshTokenContentHash;
    private Date _refreshTokenCreateDate;
    private Date _refreshTokenExpirationDate;
    private long _columnBitmask;
    private OAuth2Authorization _escapedModel;

    public static OAuth2Authorization toModel(OAuth2AuthorizationSoap soapModel) {
        if (soapModel == null) {
            return null;
        }
        OAuth2AuthorizationImpl model = new OAuth2AuthorizationImpl();
        model.setOAuth2AuthorizationId(soapModel.getOAuth2AuthorizationId());
        model.setCompanyId(soapModel.getCompanyId());
        model.setUserId(soapModel.getUserId());
        model.setUserName(soapModel.getUserName());
        model.setCreateDate(soapModel.getCreateDate());
        model.setOAuth2ApplicationId(soapModel.getOAuth2ApplicationId());
        model.setOAuth2ApplicationScopeAliasesId(soapModel.getOAuth2ApplicationScopeAliasesId());
        model.setAccessTokenContent(soapModel.getAccessTokenContent());
        model.setAccessTokenContentHash(soapModel.getAccessTokenContentHash());
        model.setAccessTokenCreateDate(soapModel.getAccessTokenCreateDate());
        model.setAccessTokenExpirationDate(soapModel.getAccessTokenExpirationDate());
        model.setRemoteIPInfo(soapModel.getRemoteIPInfo());
        model.setRefreshTokenContent(soapModel.getRefreshTokenContent());
        model.setRefreshTokenContentHash(soapModel.getRefreshTokenContentHash());
        model.setRefreshTokenCreateDate(soapModel.getRefreshTokenCreateDate());
        model.setRefreshTokenExpirationDate(soapModel.getRefreshTokenExpirationDate());
        return model;
    }

    public static List<OAuth2Authorization> toModels(OAuth2AuthorizationSoap[] soapModels) {
        if (soapModels == null) {
            return null;
        }
        ArrayList<OAuth2Authorization> models = new ArrayList<OAuth2Authorization>(soapModels.length);
        for (OAuth2AuthorizationSoap soapModel : soapModels) {
            models.add(OAuth2AuthorizationModelImpl.toModel(soapModel));
        }
        return models;
    }

    public long getPrimaryKey() {
        return this._oAuth2AuthorizationId;
    }

    public void setPrimaryKey(long primaryKey) {
        this.setOAuth2AuthorizationId(primaryKey);
    }

    public Serializable getPrimaryKeyObj() {
        return Long.valueOf(this._oAuth2AuthorizationId);
    }

    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        this.setPrimaryKey((Long)primaryKeyObj);
    }

    public Class<?> getModelClass() {
        return OAuth2Authorization.class;
    }

    public String getModelClassName() {
        return OAuth2Authorization.class.getName();
    }

    public Map<String, Object> getModelAttributes() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("oAuth2AuthorizationId", this.getOAuth2AuthorizationId());
        attributes.put("companyId", this.getCompanyId());
        attributes.put("userId", this.getUserId());
        attributes.put("userName", this.getUserName());
        attributes.put("createDate", this.getCreateDate());
        attributes.put("oAuth2ApplicationId", this.getOAuth2ApplicationId());
        attributes.put("oAuth2ApplicationScopeAliasesId", this.getOAuth2ApplicationScopeAliasesId());
        attributes.put("accessTokenContent", this.getAccessTokenContent());
        attributes.put("accessTokenContentHash", this.getAccessTokenContentHash());
        attributes.put("accessTokenCreateDate", this.getAccessTokenCreateDate());
        attributes.put("accessTokenExpirationDate", this.getAccessTokenExpirationDate());
        attributes.put("remoteIPInfo", this.getRemoteIPInfo());
        attributes.put("refreshTokenContent", this.getRefreshTokenContent());
        attributes.put("refreshTokenContentHash", this.getRefreshTokenContentHash());
        attributes.put("refreshTokenCreateDate", this.getRefreshTokenCreateDate());
        attributes.put("refreshTokenExpirationDate", this.getRefreshTokenExpirationDate());
        attributes.put("entityCacheEnabled", this.isEntityCacheEnabled());
        attributes.put("finderCacheEnabled", this.isFinderCacheEnabled());
        return attributes;
    }

    public void setModelAttributes(Map<String, Object> attributes) {
        Date refreshTokenExpirationDate;
        Date refreshTokenCreateDate;
        Long refreshTokenContentHash;
        String refreshTokenContent;
        String remoteIPInfo;
        Date accessTokenExpirationDate;
        Date accessTokenCreateDate;
        Long accessTokenContentHash;
        String accessTokenContent;
        Long oAuth2ApplicationScopeAliasesId;
        Long oAuth2ApplicationId;
        Date createDate;
        String userName;
        Long userId;
        Long companyId;
        Long oAuth2AuthorizationId = (Long)attributes.get("oAuth2AuthorizationId");
        if (oAuth2AuthorizationId != null) {
            this.setOAuth2AuthorizationId(oAuth2AuthorizationId);
        }
        if ((companyId = (Long)attributes.get("companyId")) != null) {
            this.setCompanyId(companyId);
        }
        if ((userId = (Long)attributes.get("userId")) != null) {
            this.setUserId(userId);
        }
        if ((userName = (String)attributes.get("userName")) != null) {
            this.setUserName(userName);
        }
        if ((createDate = (Date)attributes.get("createDate")) != null) {
            this.setCreateDate(createDate);
        }
        if ((oAuth2ApplicationId = (Long)attributes.get("oAuth2ApplicationId")) != null) {
            this.setOAuth2ApplicationId(oAuth2ApplicationId);
        }
        if ((oAuth2ApplicationScopeAliasesId = (Long)attributes.get("oAuth2ApplicationScopeAliasesId")) != null) {
            this.setOAuth2ApplicationScopeAliasesId(oAuth2ApplicationScopeAliasesId);
        }
        if ((accessTokenContent = (String)attributes.get("accessTokenContent")) != null) {
            this.setAccessTokenContent(accessTokenContent);
        }
        if ((accessTokenContentHash = (Long)attributes.get("accessTokenContentHash")) != null) {
            this.setAccessTokenContentHash(accessTokenContentHash);
        }
        if ((accessTokenCreateDate = (Date)attributes.get("accessTokenCreateDate")) != null) {
            this.setAccessTokenCreateDate(accessTokenCreateDate);
        }
        if ((accessTokenExpirationDate = (Date)attributes.get("accessTokenExpirationDate")) != null) {
            this.setAccessTokenExpirationDate(accessTokenExpirationDate);
        }
        if ((remoteIPInfo = (String)attributes.get("remoteIPInfo")) != null) {
            this.setRemoteIPInfo(remoteIPInfo);
        }
        if ((refreshTokenContent = (String)attributes.get("refreshTokenContent")) != null) {
            this.setRefreshTokenContent(refreshTokenContent);
        }
        if ((refreshTokenContentHash = (Long)attributes.get("refreshTokenContentHash")) != null) {
            this.setRefreshTokenContentHash(refreshTokenContentHash);
        }
        if ((refreshTokenCreateDate = (Date)attributes.get("refreshTokenCreateDate")) != null) {
            this.setRefreshTokenCreateDate(refreshTokenCreateDate);
        }
        if ((refreshTokenExpirationDate = (Date)attributes.get("refreshTokenExpirationDate")) != null) {
            this.setRefreshTokenExpirationDate(refreshTokenExpirationDate);
        }
    }

    public long getOAuth2AuthorizationId() {
        return this._oAuth2AuthorizationId;
    }

    public void setOAuth2AuthorizationId(long oAuth2AuthorizationId) {
        this._oAuth2AuthorizationId = oAuth2AuthorizationId;
    }

    public long getCompanyId() {
        return this._companyId;
    }

    public void setCompanyId(long companyId) {
        this._companyId = companyId;
    }

    public long getUserId() {
        return this._userId;
    }

    public void setUserId(long userId) {
        this._columnBitmask |= 8L;
        if (!this._setOriginalUserId) {
            this._setOriginalUserId = true;
            this._originalUserId = this._userId;
        }
        this._userId = userId;
    }

    public String getUserUuid() {
        try {
            User user = UserLocalServiceUtil.getUserById((long)this.getUserId());
            return user.getUuid();
        }
        catch (PortalException pe) {
            return "";
        }
    }

    public void setUserUuid(String userUuid) {
    }

    public long getOriginalUserId() {
        return this._originalUserId;
    }

    public String getUserName() {
        if (this._userName == null) {
            return "";
        }
        return this._userName;
    }

    public void setUserName(String userName) {
        this._userName = userName;
    }

    public Date getCreateDate() {
        return this._createDate;
    }

    public void setCreateDate(Date createDate) {
        this._createDate = createDate;
    }

    public long getOAuth2ApplicationId() {
        return this._oAuth2ApplicationId;
    }

    public void setOAuth2ApplicationId(long oAuth2ApplicationId) {
        this._columnBitmask |= 2L;
        if (!this._setOriginalOAuth2ApplicationId) {
            this._setOriginalOAuth2ApplicationId = true;
            this._originalOAuth2ApplicationId = this._oAuth2ApplicationId;
        }
        this._oAuth2ApplicationId = oAuth2ApplicationId;
    }

    public long getOriginalOAuth2ApplicationId() {
        return this._originalOAuth2ApplicationId;
    }

    public long getOAuth2ApplicationScopeAliasesId() {
        return this._oAuth2ApplicationScopeAliasesId;
    }

    public void setOAuth2ApplicationScopeAliasesId(long oAuth2ApplicationScopeAliasesId) {
        this._oAuth2ApplicationScopeAliasesId = oAuth2ApplicationScopeAliasesId;
    }

    public String getAccessTokenContent() {
        if (this._accessTokenContent == null) {
            return "";
        }
        return this._accessTokenContent;
    }

    public void setAccessTokenContent(String accessTokenContent) {
        this._accessTokenContent = accessTokenContent;
    }

    public long getAccessTokenContentHash() {
        return this._accessTokenContentHash;
    }

    public void setAccessTokenContentHash(long accessTokenContentHash) {
        this._columnBitmask |= 1L;
        if (!this._setOriginalAccessTokenContentHash) {
            this._setOriginalAccessTokenContentHash = true;
            this._originalAccessTokenContentHash = this._accessTokenContentHash;
        }
        this._accessTokenContentHash = accessTokenContentHash;
    }

    public long getOriginalAccessTokenContentHash() {
        return this._originalAccessTokenContentHash;
    }

    public Date getAccessTokenCreateDate() {
        return this._accessTokenCreateDate;
    }

    public void setAccessTokenCreateDate(Date accessTokenCreateDate) {
        this._accessTokenCreateDate = accessTokenCreateDate;
    }

    public Date getAccessTokenExpirationDate() {
        return this._accessTokenExpirationDate;
    }

    public void setAccessTokenExpirationDate(Date accessTokenExpirationDate) {
        this._accessTokenExpirationDate = accessTokenExpirationDate;
    }

    public String getRemoteIPInfo() {
        if (this._remoteIPInfo == null) {
            return "";
        }
        return this._remoteIPInfo;
    }

    public void setRemoteIPInfo(String remoteIPInfo) {
        this._remoteIPInfo = remoteIPInfo;
    }

    public String getRefreshTokenContent() {
        if (this._refreshTokenContent == null) {
            return "";
        }
        return this._refreshTokenContent;
    }

    public void setRefreshTokenContent(String refreshTokenContent) {
        this._refreshTokenContent = refreshTokenContent;
    }

    public long getRefreshTokenContentHash() {
        return this._refreshTokenContentHash;
    }

    public void setRefreshTokenContentHash(long refreshTokenContentHash) {
        this._columnBitmask |= 4L;
        if (!this._setOriginalRefreshTokenContentHash) {
            this._setOriginalRefreshTokenContentHash = true;
            this._originalRefreshTokenContentHash = this._refreshTokenContentHash;
        }
        this._refreshTokenContentHash = refreshTokenContentHash;
    }

    public long getOriginalRefreshTokenContentHash() {
        return this._originalRefreshTokenContentHash;
    }

    public Date getRefreshTokenCreateDate() {
        return this._refreshTokenCreateDate;
    }

    public void setRefreshTokenCreateDate(Date refreshTokenCreateDate) {
        this._refreshTokenCreateDate = refreshTokenCreateDate;
    }

    public Date getRefreshTokenExpirationDate() {
        return this._refreshTokenExpirationDate;
    }

    public void setRefreshTokenExpirationDate(Date refreshTokenExpirationDate) {
        this._refreshTokenExpirationDate = refreshTokenExpirationDate;
    }

    public long getColumnBitmask() {
        return this._columnBitmask;
    }

    public ExpandoBridge getExpandoBridge() {
        return ExpandoBridgeFactoryUtil.getExpandoBridge((long)this.getCompanyId(), (String)OAuth2Authorization.class.getName(), (long)this.getPrimaryKey());
    }

    public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
        ExpandoBridge expandoBridge = this.getExpandoBridge();
        expandoBridge.setAttributes(serviceContext);
    }

    public OAuth2Authorization toEscapedModel() {
        if (this._escapedModel == null) {
            this._escapedModel = (OAuth2Authorization)ProxyUtil.newProxyInstance((ClassLoader)_classLoader, (Class[])_escapedModelInterfaces, (InvocationHandler)new AutoEscapeBeanHandler((Object)this));
        }
        return this._escapedModel;
    }

    public Object clone() {
        OAuth2AuthorizationImpl oAuth2AuthorizationImpl = new OAuth2AuthorizationImpl();
        oAuth2AuthorizationImpl.setOAuth2AuthorizationId(this.getOAuth2AuthorizationId());
        oAuth2AuthorizationImpl.setCompanyId(this.getCompanyId());
        oAuth2AuthorizationImpl.setUserId(this.getUserId());
        oAuth2AuthorizationImpl.setUserName(this.getUserName());
        oAuth2AuthorizationImpl.setCreateDate(this.getCreateDate());
        oAuth2AuthorizationImpl.setOAuth2ApplicationId(this.getOAuth2ApplicationId());
        oAuth2AuthorizationImpl.setOAuth2ApplicationScopeAliasesId(this.getOAuth2ApplicationScopeAliasesId());
        oAuth2AuthorizationImpl.setAccessTokenContent(this.getAccessTokenContent());
        oAuth2AuthorizationImpl.setAccessTokenContentHash(this.getAccessTokenContentHash());
        oAuth2AuthorizationImpl.setAccessTokenCreateDate(this.getAccessTokenCreateDate());
        oAuth2AuthorizationImpl.setAccessTokenExpirationDate(this.getAccessTokenExpirationDate());
        oAuth2AuthorizationImpl.setRemoteIPInfo(this.getRemoteIPInfo());
        oAuth2AuthorizationImpl.setRefreshTokenContent(this.getRefreshTokenContent());
        oAuth2AuthorizationImpl.setRefreshTokenContentHash(this.getRefreshTokenContentHash());
        oAuth2AuthorizationImpl.setRefreshTokenCreateDate(this.getRefreshTokenCreateDate());
        oAuth2AuthorizationImpl.setRefreshTokenExpirationDate(this.getRefreshTokenExpirationDate());
        oAuth2AuthorizationImpl.resetOriginalValues();
        return oAuth2AuthorizationImpl;
    }

    public int compareTo(OAuth2Authorization oAuth2Authorization) {
        long primaryKey = oAuth2Authorization.getPrimaryKey();
        if (this.getPrimaryKey() < primaryKey) {
            return -1;
        }
        if (this.getPrimaryKey() > primaryKey) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OAuth2Authorization)) {
            return false;
        }
        OAuth2Authorization oAuth2Authorization = (OAuth2Authorization)obj;
        long primaryKey = oAuth2Authorization.getPrimaryKey();
        return this.getPrimaryKey() == primaryKey;
    }

    public int hashCode() {
        return (int)this.getPrimaryKey();
    }

    public boolean isEntityCacheEnabled() {
        return ENTITY_CACHE_ENABLED;
    }

    public boolean isFinderCacheEnabled() {
        return FINDER_CACHE_ENABLED;
    }

    public void resetOriginalValues() {
        OAuth2AuthorizationModelImpl oAuth2AuthorizationModelImpl = this;
        oAuth2AuthorizationModelImpl._originalUserId = oAuth2AuthorizationModelImpl._userId;
        oAuth2AuthorizationModelImpl._setOriginalUserId = false;
        oAuth2AuthorizationModelImpl._originalOAuth2ApplicationId = oAuth2AuthorizationModelImpl._oAuth2ApplicationId;
        oAuth2AuthorizationModelImpl._setOriginalOAuth2ApplicationId = false;
        oAuth2AuthorizationModelImpl._originalAccessTokenContentHash = oAuth2AuthorizationModelImpl._accessTokenContentHash;
        oAuth2AuthorizationModelImpl._setOriginalAccessTokenContentHash = false;
        oAuth2AuthorizationModelImpl._originalRefreshTokenContentHash = oAuth2AuthorizationModelImpl._refreshTokenContentHash;
        oAuth2AuthorizationModelImpl._setOriginalRefreshTokenContentHash = false;
        oAuth2AuthorizationModelImpl._columnBitmask = 0L;
    }

    public CacheModel<OAuth2Authorization> toCacheModel() {
        String refreshTokenContent;
        Date createDate;
        OAuth2AuthorizationCacheModel oAuth2AuthorizationCacheModel = new OAuth2AuthorizationCacheModel();
        oAuth2AuthorizationCacheModel.oAuth2AuthorizationId = this.getOAuth2AuthorizationId();
        oAuth2AuthorizationCacheModel.companyId = this.getCompanyId();
        oAuth2AuthorizationCacheModel.userId = this.getUserId();
        oAuth2AuthorizationCacheModel.userName = this.getUserName();
        String userName = oAuth2AuthorizationCacheModel.userName;
        if (userName != null && userName.length() == 0) {
            oAuth2AuthorizationCacheModel.userName = null;
        }
        oAuth2AuthorizationCacheModel.createDate = (createDate = this.getCreateDate()) != null ? createDate.getTime() : Long.MIN_VALUE;
        oAuth2AuthorizationCacheModel.oAuth2ApplicationId = this.getOAuth2ApplicationId();
        oAuth2AuthorizationCacheModel.oAuth2ApplicationScopeAliasesId = this.getOAuth2ApplicationScopeAliasesId();
        oAuth2AuthorizationCacheModel.accessTokenContent = this.getAccessTokenContent();
        String accessTokenContent = oAuth2AuthorizationCacheModel.accessTokenContent;
        if (accessTokenContent != null && accessTokenContent.length() == 0) {
            oAuth2AuthorizationCacheModel.accessTokenContent = null;
        }
        oAuth2AuthorizationCacheModel.accessTokenContentHash = this.getAccessTokenContentHash();
        Date accessTokenCreateDate = this.getAccessTokenCreateDate();
        oAuth2AuthorizationCacheModel.accessTokenCreateDate = accessTokenCreateDate != null ? accessTokenCreateDate.getTime() : Long.MIN_VALUE;
        Date accessTokenExpirationDate = this.getAccessTokenExpirationDate();
        oAuth2AuthorizationCacheModel.accessTokenExpirationDate = accessTokenExpirationDate != null ? accessTokenExpirationDate.getTime() : Long.MIN_VALUE;
        oAuth2AuthorizationCacheModel.remoteIPInfo = this.getRemoteIPInfo();
        String remoteIPInfo = oAuth2AuthorizationCacheModel.remoteIPInfo;
        if (remoteIPInfo != null && remoteIPInfo.length() == 0) {
            oAuth2AuthorizationCacheModel.remoteIPInfo = null;
        }
        if ((refreshTokenContent = (oAuth2AuthorizationCacheModel.refreshTokenContent = this.getRefreshTokenContent())) != null && refreshTokenContent.length() == 0) {
            oAuth2AuthorizationCacheModel.refreshTokenContent = null;
        }
        oAuth2AuthorizationCacheModel.refreshTokenContentHash = this.getRefreshTokenContentHash();
        Date refreshTokenCreateDate = this.getRefreshTokenCreateDate();
        oAuth2AuthorizationCacheModel.refreshTokenCreateDate = refreshTokenCreateDate != null ? refreshTokenCreateDate.getTime() : Long.MIN_VALUE;
        Date refreshTokenExpirationDate = this.getRefreshTokenExpirationDate();
        oAuth2AuthorizationCacheModel.refreshTokenExpirationDate = refreshTokenExpirationDate != null ? refreshTokenExpirationDate.getTime() : Long.MIN_VALUE;
        return oAuth2AuthorizationCacheModel;
    }

    public String toString() {
        StringBundler sb = new StringBundler(33);
        sb.append("{oAuth2AuthorizationId=");
        sb.append(this.getOAuth2AuthorizationId());
        sb.append(", companyId=");
        sb.append(this.getCompanyId());
        sb.append(", userId=");
        sb.append(this.getUserId());
        sb.append(", userName=");
        sb.append(this.getUserName());
        sb.append(", createDate=");
        sb.append((Object)this.getCreateDate());
        sb.append(", oAuth2ApplicationId=");
        sb.append(this.getOAuth2ApplicationId());
        sb.append(", oAuth2ApplicationScopeAliasesId=");
        sb.append(this.getOAuth2ApplicationScopeAliasesId());
        sb.append(", accessTokenContent=");
        sb.append(this.getAccessTokenContent());
        sb.append(", accessTokenContentHash=");
        sb.append(this.getAccessTokenContentHash());
        sb.append(", accessTokenCreateDate=");
        sb.append((Object)this.getAccessTokenCreateDate());
        sb.append(", accessTokenExpirationDate=");
        sb.append((Object)this.getAccessTokenExpirationDate());
        sb.append(", remoteIPInfo=");
        sb.append(this.getRemoteIPInfo());
        sb.append(", refreshTokenContent=");
        sb.append(this.getRefreshTokenContent());
        sb.append(", refreshTokenContentHash=");
        sb.append(this.getRefreshTokenContentHash());
        sb.append(", refreshTokenCreateDate=");
        sb.append((Object)this.getRefreshTokenCreateDate());
        sb.append(", refreshTokenExpirationDate=");
        sb.append((Object)this.getRefreshTokenExpirationDate());
        sb.append("}");
        return sb.toString();
    }

    public String toXmlString() {
        StringBundler sb = new StringBundler(52);
        sb.append("<model><model-name>");
        sb.append("com.liferay.oauth2.provider.model.OAuth2Authorization");
        sb.append("</model-name>");
        sb.append("<column><column-name>oAuth2AuthorizationId</column-name><column-value><![CDATA[");
        sb.append(this.getOAuth2AuthorizationId());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>companyId</column-name><column-value><![CDATA[");
        sb.append(this.getCompanyId());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>userId</column-name><column-value><![CDATA[");
        sb.append(this.getUserId());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>userName</column-name><column-value><![CDATA[");
        sb.append(this.getUserName());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>createDate</column-name><column-value><![CDATA[");
        sb.append((Object)this.getCreateDate());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>oAuth2ApplicationId</column-name><column-value><![CDATA[");
        sb.append(this.getOAuth2ApplicationId());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>oAuth2ApplicationScopeAliasesId</column-name><column-value><![CDATA[");
        sb.append(this.getOAuth2ApplicationScopeAliasesId());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>accessTokenContent</column-name><column-value><![CDATA[");
        sb.append(this.getAccessTokenContent());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>accessTokenContentHash</column-name><column-value><![CDATA[");
        sb.append(this.getAccessTokenContentHash());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>accessTokenCreateDate</column-name><column-value><![CDATA[");
        sb.append((Object)this.getAccessTokenCreateDate());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>accessTokenExpirationDate</column-name><column-value><![CDATA[");
        sb.append((Object)this.getAccessTokenExpirationDate());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>remoteIPInfo</column-name><column-value><![CDATA[");
        sb.append(this.getRemoteIPInfo());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>refreshTokenContent</column-name><column-value><![CDATA[");
        sb.append(this.getRefreshTokenContent());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>refreshTokenContentHash</column-name><column-value><![CDATA[");
        sb.append(this.getRefreshTokenContentHash());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>refreshTokenCreateDate</column-name><column-value><![CDATA[");
        sb.append((Object)this.getRefreshTokenCreateDate());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>refreshTokenExpirationDate</column-name><column-value><![CDATA[");
        sb.append((Object)this.getRefreshTokenExpirationDate());
        sb.append("]]></column-value></column>");
        sb.append("</model>");
        return sb.toString();
    }

    static {
        TABLE_COLUMNS_MAP.put("oAuth2AuthorizationId", -5);
        TABLE_COLUMNS_MAP.put("companyId", -5);
        TABLE_COLUMNS_MAP.put("userId", -5);
        TABLE_COLUMNS_MAP.put("userName", 12);
        TABLE_COLUMNS_MAP.put("createDate", 93);
        TABLE_COLUMNS_MAP.put("oAuth2ApplicationId", -5);
        TABLE_COLUMNS_MAP.put("oA2AScopeAliasesId", -5);
        TABLE_COLUMNS_MAP.put("accessTokenContent", 2005);
        TABLE_COLUMNS_MAP.put("accessTokenContentHash", -5);
        TABLE_COLUMNS_MAP.put("accessTokenCreateDate", 93);
        TABLE_COLUMNS_MAP.put("accessTokenExpirationDate", 93);
        TABLE_COLUMNS_MAP.put("remoteIPInfo", 12);
        TABLE_COLUMNS_MAP.put("refreshTokenContent", 2005);
        TABLE_COLUMNS_MAP.put("refreshTokenContentHash", -5);
        TABLE_COLUMNS_MAP.put("refreshTokenCreateDate", 93);
        TABLE_COLUMNS_MAP.put("refreshTokenExpirationDate", 93);
        ENTITY_CACHE_ENABLED = GetterUtil.getBoolean((String)ServiceProps.get("value.object.entity.cache.enabled.com.liferay.oauth2.provider.model.OAuth2Authorization"), (boolean)true);
        FINDER_CACHE_ENABLED = GetterUtil.getBoolean((String)ServiceProps.get("value.object.finder.cache.enabled.com.liferay.oauth2.provider.model.OAuth2Authorization"), (boolean)true);
        COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean((String)ServiceProps.get("value.object.column.bitmask.enabled.com.liferay.oauth2.provider.model.OAuth2Authorization"), (boolean)true);
        MAPPING_TABLE_OA2AUTHS_OA2SCOPEGRANTS_COLUMNS = new Object[][]{{"companyId", -5}, {"oAuth2AuthorizationId", -5}, {"oAuth2ScopeGrantId", -5}};
        FINDER_CACHE_ENABLED_OA2AUTHS_OA2SCOPEGRANTS = GetterUtil.getBoolean((String)ServiceProps.get("value.object.finder.cache.enabled.OA2Auths_OA2ScopeGrants"), (boolean)true);
        LOCK_EXPIRATION_TIME = GetterUtil.getLong((String)ServiceProps.get("lock.expiration.time.com.liferay.oauth2.provider.model.OAuth2Authorization"));
        _classLoader = OAuth2Authorization.class.getClassLoader();
        _escapedModelInterfaces = new Class[]{OAuth2Authorization.class, ModelWrapper.class};
    }
}

