/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.oauth2.provider.model.impl;

import aQute.bnd.annotation.ProviderType;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;

import com.liferay.oauth2.provider.model.OAuth2ScopeGrant;
import com.liferay.oauth2.provider.model.OAuth2ScopeGrantModel;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;

import java.io.Serializable;

import java.sql.Types;

import java.util.HashMap;
import java.util.Map;

/**
 * The base model implementation for the OAuth2ScopeGrant service. Represents a row in the &quot;OAuth2ScopeGrant&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link OAuth2ScopeGrantModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link OAuth2ScopeGrantImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see OAuth2ScopeGrantImpl
 * @see OAuth2ScopeGrant
 * @see OAuth2ScopeGrantModel
 * @generated
 */
@ProviderType
public class OAuth2ScopeGrantModelImpl extends BaseModelImpl<OAuth2ScopeGrant>
	implements OAuth2ScopeGrantModel {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a o auth2 scope grant model instance should use the {@link OAuth2ScopeGrant} interface instead.
	 */
	public static final String TABLE_NAME = "OAuth2ScopeGrant";
	public static final Object[][] TABLE_COLUMNS = {
			{ "oAuth2ScopeGrantId", Types.BIGINT },
			{ "companyId", Types.BIGINT },
			{ "oA2AScopeAliasesId", Types.BIGINT },
			{ "applicationName", Types.VARCHAR },
			{ "bundleSymbolicName", Types.VARCHAR },
			{ "scope", Types.VARCHAR }
		};
	public static final Map<String, Integer> TABLE_COLUMNS_MAP = new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("oAuth2ScopeGrantId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("oA2AScopeAliasesId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("applicationName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("bundleSymbolicName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("scope", Types.VARCHAR);
	}

	public static final String TABLE_SQL_CREATE = "create table OAuth2ScopeGrant (oAuth2ScopeGrantId LONG not null primary key,companyId LONG,oA2AScopeAliasesId LONG,applicationName VARCHAR(255) null,bundleSymbolicName VARCHAR(255) null,scope VARCHAR(255) null)";
	public static final String TABLE_SQL_DROP = "drop table OAuth2ScopeGrant";
	public static final String ORDER_BY_JPQL = " ORDER BY oAuth2ScopeGrant.oAuth2ScopeGrantId ASC";
	public static final String ORDER_BY_SQL = " ORDER BY OAuth2ScopeGrant.oAuth2ScopeGrantId ASC";
	public static final String DATA_SOURCE = "liferayDataSource";
	public static final String SESSION_FACTORY = "liferaySessionFactory";
	public static final String TX_MANAGER = "liferayTransactionManager";
	public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.oauth2.provider.service.util.ServiceProps.get(
				"value.object.entity.cache.enabled.com.liferay.oauth2.provider.model.OAuth2ScopeGrant"),
			true);
	public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.oauth2.provider.service.util.ServiceProps.get(
				"value.object.finder.cache.enabled.com.liferay.oauth2.provider.model.OAuth2ScopeGrant"),
			true);
	public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.oauth2.provider.service.util.ServiceProps.get(
				"value.object.column.bitmask.enabled.com.liferay.oauth2.provider.model.OAuth2ScopeGrant"),
			true);
	public static final long APPLICATIONNAME_COLUMN_BITMASK = 1L;
	public static final long BUNDLESYMBOLICNAME_COLUMN_BITMASK = 2L;
	public static final long COMPANYID_COLUMN_BITMASK = 4L;
	public static final long OAUTH2APPLICATIONSCOPEALIASESID_COLUMN_BITMASK = 8L;
	public static final long SCOPE_COLUMN_BITMASK = 16L;
	public static final long OAUTH2SCOPEGRANTID_COLUMN_BITMASK = 32L;
	public static final String MAPPING_TABLE_OA2AUTHS_OA2SCOPEGRANTS_NAME = "OA2Auths_OA2ScopeGrants";
	public static final Object[][] MAPPING_TABLE_OA2AUTHS_OA2SCOPEGRANTS_COLUMNS =
		{
			{ "companyId", Types.BIGINT },
			{ "oAuth2AuthorizationId", Types.BIGINT },
			{ "oAuth2ScopeGrantId", Types.BIGINT }
		};
	public static final String MAPPING_TABLE_OA2AUTHS_OA2SCOPEGRANTS_SQL_CREATE = "create table OA2Auths_OA2ScopeGrants (companyId LONG not null,oAuth2AuthorizationId LONG not null,oAuth2ScopeGrantId LONG not null,primary key (oAuth2AuthorizationId, oAuth2ScopeGrantId))";
	public static final boolean FINDER_CACHE_ENABLED_OA2AUTHS_OA2SCOPEGRANTS = GetterUtil.getBoolean(com.liferay.oauth2.provider.service.util.ServiceProps.get(
				"value.object.finder.cache.enabled.OA2Auths_OA2ScopeGrants"),
			true);
	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.oauth2.provider.service.util.ServiceProps.get(
				"lock.expiration.time.com.liferay.oauth2.provider.model.OAuth2ScopeGrant"));

	public OAuth2ScopeGrantModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _oAuth2ScopeGrantId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setOAuth2ScopeGrantId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _oAuth2ScopeGrantId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return OAuth2ScopeGrant.class;
	}

	@Override
	public String getModelClassName() {
		return OAuth2ScopeGrant.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		attributes.put("oAuth2ScopeGrantId", getOAuth2ScopeGrantId());
		attributes.put("companyId", getCompanyId());
		attributes.put("oAuth2ApplicationScopeAliasesId",
			getOAuth2ApplicationScopeAliasesId());
		attributes.put("applicationName", getApplicationName());
		attributes.put("bundleSymbolicName", getBundleSymbolicName());
		attributes.put("scope", getScope());

		attributes.put("entityCacheEnabled", isEntityCacheEnabled());
		attributes.put("finderCacheEnabled", isFinderCacheEnabled());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Long oAuth2ScopeGrantId = (Long)attributes.get("oAuth2ScopeGrantId");

		if (oAuth2ScopeGrantId != null) {
			setOAuth2ScopeGrantId(oAuth2ScopeGrantId);
		}

		Long companyId = (Long)attributes.get("companyId");

		if (companyId != null) {
			setCompanyId(companyId);
		}

		Long oAuth2ApplicationScopeAliasesId = (Long)attributes.get(
				"oAuth2ApplicationScopeAliasesId");

		if (oAuth2ApplicationScopeAliasesId != null) {
			setOAuth2ApplicationScopeAliasesId(oAuth2ApplicationScopeAliasesId);
		}

		String applicationName = (String)attributes.get("applicationName");

		if (applicationName != null) {
			setApplicationName(applicationName);
		}

		String bundleSymbolicName = (String)attributes.get("bundleSymbolicName");

		if (bundleSymbolicName != null) {
			setBundleSymbolicName(bundleSymbolicName);
		}

		String scope = (String)attributes.get("scope");

		if (scope != null) {
			setScope(scope);
		}
	}

	@Override
	public long getOAuth2ScopeGrantId() {
		return _oAuth2ScopeGrantId;
	}

	@Override
	public void setOAuth2ScopeGrantId(long oAuth2ScopeGrantId) {
		_oAuth2ScopeGrantId = oAuth2ScopeGrantId;
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		_columnBitmask |= COMPANYID_COLUMN_BITMASK;

		if (!_setOriginalCompanyId) {
			_setOriginalCompanyId = true;

			_originalCompanyId = _companyId;
		}

		_companyId = companyId;
	}

	public long getOriginalCompanyId() {
		return _originalCompanyId;
	}

	@Override
	public long getOAuth2ApplicationScopeAliasesId() {
		return _oAuth2ApplicationScopeAliasesId;
	}

	@Override
	public void setOAuth2ApplicationScopeAliasesId(
		long oAuth2ApplicationScopeAliasesId) {
		_columnBitmask |= OAUTH2APPLICATIONSCOPEALIASESID_COLUMN_BITMASK;

		if (!_setOriginalOAuth2ApplicationScopeAliasesId) {
			_setOriginalOAuth2ApplicationScopeAliasesId = true;

			_originalOAuth2ApplicationScopeAliasesId = _oAuth2ApplicationScopeAliasesId;
		}

		_oAuth2ApplicationScopeAliasesId = oAuth2ApplicationScopeAliasesId;
	}

	public long getOriginalOAuth2ApplicationScopeAliasesId() {
		return _originalOAuth2ApplicationScopeAliasesId;
	}

	@Override
	public String getApplicationName() {
		if (_applicationName == null) {
			return "";
		}
		else {
			return _applicationName;
		}
	}

	@Override
	public void setApplicationName(String applicationName) {
		_columnBitmask |= APPLICATIONNAME_COLUMN_BITMASK;

		if (_originalApplicationName == null) {
			_originalApplicationName = _applicationName;
		}

		_applicationName = applicationName;
	}

	public String getOriginalApplicationName() {
		return GetterUtil.getString(_originalApplicationName);
	}

	@Override
	public String getBundleSymbolicName() {
		if (_bundleSymbolicName == null) {
			return "";
		}
		else {
			return _bundleSymbolicName;
		}
	}

	@Override
	public void setBundleSymbolicName(String bundleSymbolicName) {
		_columnBitmask |= BUNDLESYMBOLICNAME_COLUMN_BITMASK;

		if (_originalBundleSymbolicName == null) {
			_originalBundleSymbolicName = _bundleSymbolicName;
		}

		_bundleSymbolicName = bundleSymbolicName;
	}

	public String getOriginalBundleSymbolicName() {
		return GetterUtil.getString(_originalBundleSymbolicName);
	}

	@Override
	public String getScope() {
		if (_scope == null) {
			return "";
		}
		else {
			return _scope;
		}
	}

	@Override
	public void setScope(String scope) {
		_columnBitmask |= SCOPE_COLUMN_BITMASK;

		if (_originalScope == null) {
			_originalScope = _scope;
		}

		_scope = scope;
	}

	public String getOriginalScope() {
		return GetterUtil.getString(_originalScope);
	}

	public long getColumnBitmask() {
		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(getCompanyId(),
			OAuth2ScopeGrant.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public OAuth2ScopeGrant toEscapedModel() {
		if (_escapedModel == null) {
			_escapedModel = (OAuth2ScopeGrant)ProxyUtil.newProxyInstance(_classLoader,
					_escapedModelInterfaces, new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		OAuth2ScopeGrantImpl oAuth2ScopeGrantImpl = new OAuth2ScopeGrantImpl();

		oAuth2ScopeGrantImpl.setOAuth2ScopeGrantId(getOAuth2ScopeGrantId());
		oAuth2ScopeGrantImpl.setCompanyId(getCompanyId());
		oAuth2ScopeGrantImpl.setOAuth2ApplicationScopeAliasesId(getOAuth2ApplicationScopeAliasesId());
		oAuth2ScopeGrantImpl.setApplicationName(getApplicationName());
		oAuth2ScopeGrantImpl.setBundleSymbolicName(getBundleSymbolicName());
		oAuth2ScopeGrantImpl.setScope(getScope());

		oAuth2ScopeGrantImpl.resetOriginalValues();

		return oAuth2ScopeGrantImpl;
	}

	@Override
	public int compareTo(OAuth2ScopeGrant oAuth2ScopeGrant) {
		long primaryKey = oAuth2ScopeGrant.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}

		if (!(obj instanceof OAuth2ScopeGrant)) {
			return false;
		}

		OAuth2ScopeGrant oAuth2ScopeGrant = (OAuth2ScopeGrant)obj;

		long primaryKey = oAuth2ScopeGrant.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		OAuth2ScopeGrantModelImpl oAuth2ScopeGrantModelImpl = this;

		oAuth2ScopeGrantModelImpl._originalCompanyId = oAuth2ScopeGrantModelImpl._companyId;

		oAuth2ScopeGrantModelImpl._setOriginalCompanyId = false;

		oAuth2ScopeGrantModelImpl._originalOAuth2ApplicationScopeAliasesId = oAuth2ScopeGrantModelImpl._oAuth2ApplicationScopeAliasesId;

		oAuth2ScopeGrantModelImpl._setOriginalOAuth2ApplicationScopeAliasesId = false;

		oAuth2ScopeGrantModelImpl._originalApplicationName = oAuth2ScopeGrantModelImpl._applicationName;

		oAuth2ScopeGrantModelImpl._originalBundleSymbolicName = oAuth2ScopeGrantModelImpl._bundleSymbolicName;

		oAuth2ScopeGrantModelImpl._originalScope = oAuth2ScopeGrantModelImpl._scope;

		oAuth2ScopeGrantModelImpl._columnBitmask = 0;
	}

	@Override
	public CacheModel<OAuth2ScopeGrant> toCacheModel() {
		OAuth2ScopeGrantCacheModel oAuth2ScopeGrantCacheModel = new OAuth2ScopeGrantCacheModel();

		oAuth2ScopeGrantCacheModel.oAuth2ScopeGrantId = getOAuth2ScopeGrantId();

		oAuth2ScopeGrantCacheModel.companyId = getCompanyId();

		oAuth2ScopeGrantCacheModel.oAuth2ApplicationScopeAliasesId = getOAuth2ApplicationScopeAliasesId();

		oAuth2ScopeGrantCacheModel.applicationName = getApplicationName();

		String applicationName = oAuth2ScopeGrantCacheModel.applicationName;

		if ((applicationName != null) && (applicationName.length() == 0)) {
			oAuth2ScopeGrantCacheModel.applicationName = null;
		}

		oAuth2ScopeGrantCacheModel.bundleSymbolicName = getBundleSymbolicName();

		String bundleSymbolicName = oAuth2ScopeGrantCacheModel.bundleSymbolicName;

		if ((bundleSymbolicName != null) && (bundleSymbolicName.length() == 0)) {
			oAuth2ScopeGrantCacheModel.bundleSymbolicName = null;
		}

		oAuth2ScopeGrantCacheModel.scope = getScope();

		String scope = oAuth2ScopeGrantCacheModel.scope;

		if ((scope != null) && (scope.length() == 0)) {
			oAuth2ScopeGrantCacheModel.scope = null;
		}

		return oAuth2ScopeGrantCacheModel;
	}

	@Override
	public String toString() {
		StringBundler sb = new StringBundler(13);

		sb.append("{oAuth2ScopeGrantId=");
		sb.append(getOAuth2ScopeGrantId());
		sb.append(", companyId=");
		sb.append(getCompanyId());
		sb.append(", oAuth2ApplicationScopeAliasesId=");
		sb.append(getOAuth2ApplicationScopeAliasesId());
		sb.append(", applicationName=");
		sb.append(getApplicationName());
		sb.append(", bundleSymbolicName=");
		sb.append(getBundleSymbolicName());
		sb.append(", scope=");
		sb.append(getScope());
		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		StringBundler sb = new StringBundler(22);

		sb.append("<model><model-name>");
		sb.append("com.liferay.oauth2.provider.model.OAuth2ScopeGrant");
		sb.append("</model-name>");

		sb.append(
			"<column><column-name>oAuth2ScopeGrantId</column-name><column-value><![CDATA[");
		sb.append(getOAuth2ScopeGrantId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>companyId</column-name><column-value><![CDATA[");
		sb.append(getCompanyId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>oAuth2ApplicationScopeAliasesId</column-name><column-value><![CDATA[");
		sb.append(getOAuth2ApplicationScopeAliasesId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>applicationName</column-name><column-value><![CDATA[");
		sb.append(getApplicationName());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>bundleSymbolicName</column-name><column-value><![CDATA[");
		sb.append(getBundleSymbolicName());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>scope</column-name><column-value><![CDATA[");
		sb.append(getScope());
		sb.append("]]></column-value></column>");

		sb.append("</model>");

		return sb.toString();
	}

	private static final ClassLoader _classLoader = OAuth2ScopeGrant.class.getClassLoader();
	private static final Class<?>[] _escapedModelInterfaces = new Class[] {
			OAuth2ScopeGrant.class, ModelWrapper.class
		};
	private long _oAuth2ScopeGrantId;
	private long _companyId;
	private long _originalCompanyId;
	private boolean _setOriginalCompanyId;
	private long _oAuth2ApplicationScopeAliasesId;
	private long _originalOAuth2ApplicationScopeAliasesId;
	private boolean _setOriginalOAuth2ApplicationScopeAliasesId;
	private String _applicationName;
	private String _originalApplicationName;
	private String _bundleSymbolicName;
	private String _originalBundleSymbolicName;
	private String _scope;
	private String _originalScope;
	private long _columnBitmask;
	private OAuth2ScopeGrant _escapedModel;
}