/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.service.http;

import aQute.bnd.annotation.ProviderType;
import com.liferay.oauth2.provider.model.OAuth2Authorization;
import com.liferay.oauth2.provider.service.OAuth2AuthorizationServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.service.http.TunnelUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;

@ProviderType
public class OAuth2AuthorizationServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(OAuth2AuthorizationServiceHttp.class);
    private static final Class<?>[] _getApplicationOAuth2AuthorizationsParameterTypes0 = new Class[]{Long.TYPE, Integer.TYPE, Integer.TYPE, OrderByComparator.class};
    private static final Class<?>[] _getApplicationOAuth2AuthorizationsCountParameterTypes1 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getUserOAuth2AuthorizationsParameterTypes2 = new Class[]{Integer.TYPE, Integer.TYPE, OrderByComparator.class};
    private static final Class<?>[] _getUserOAuth2AuthorizationsCountParameterTypes3 = new Class[0];
    private static final Class<?>[] _revokeOAuth2AuthorizationParameterTypes4 = new Class[]{Long.TYPE};

    public static List<OAuth2Authorization> getApplicationOAuth2Authorizations(HttpPrincipal httpPrincipal, long oAuth2ApplicationId, int start, int end, OrderByComparator<OAuth2Authorization> orderByComparator) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(OAuth2AuthorizationServiceUtil.class, "getApplicationOAuth2Authorizations", (Class[])_getApplicationOAuth2AuthorizationsParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{oAuth2ApplicationId, start, end, orderByComparator});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static int getApplicationOAuth2AuthorizationsCount(HttpPrincipal httpPrincipal, long oAuth2ApplicationId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(OAuth2AuthorizationServiceUtil.class, "getApplicationOAuth2AuthorizationsCount", (Class[])_getApplicationOAuth2AuthorizationsCountParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{oAuth2ApplicationId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<OAuth2Authorization> getUserOAuth2Authorizations(HttpPrincipal httpPrincipal, int start, int end, OrderByComparator<OAuth2Authorization> orderByComparator) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(OAuth2AuthorizationServiceUtil.class, "getUserOAuth2Authorizations", (Class[])_getUserOAuth2AuthorizationsParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{start, end, orderByComparator});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static int getUserOAuth2AuthorizationsCount(HttpPrincipal httpPrincipal) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(OAuth2AuthorizationServiceUtil.class, "getUserOAuth2AuthorizationsCount", (Class[])_getUserOAuth2AuthorizationsCountParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[0]);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void revokeOAuth2Authorization(HttpPrincipal httpPrincipal, long oAuth2AuthorizationId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(OAuth2AuthorizationServiceUtil.class, "revokeOAuth2Authorization", (Class[])_revokeOAuth2AuthorizationParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{oAuth2AuthorizationId});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

