/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.model.impl;

import aQute.bnd.annotation.ProviderType;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.oauth2.provider.model.OAuth2Application;
import com.liferay.oauth2.provider.model.OAuth2ApplicationModel;
import com.liferay.oauth2.provider.model.OAuth2ApplicationSoap;
import com.liferay.oauth2.provider.model.impl.OAuth2ApplicationCacheModel;
import com.liferay.oauth2.provider.model.impl.OAuth2ApplicationImpl;
import com.liferay.oauth2.provider.service.util.ServiceProps;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JSON(strict=true)
@ProviderType
public class OAuth2ApplicationModelImpl
extends BaseModelImpl<OAuth2Application>
implements OAuth2ApplicationModel {
    public static final String TABLE_NAME = "OAuth2Application";
    public static final Object[][] TABLE_COLUMNS = new Object[][]{{"oAuth2ApplicationId", -5}, {"companyId", -5}, {"userId", -5}, {"userName", 12}, {"createDate", 93}, {"modifiedDate", 93}, {"oA2AScopeAliasesId", -5}, {"allowedGrantTypes", 12}, {"clientId", 12}, {"clientProfile", 4}, {"clientSecret", 12}, {"description", 12}, {"features", 12}, {"homePageURL", 12}, {"iconFileEntryId", -5}, {"name", 12}, {"privacyPolicyURL", 12}, {"redirectURIs", 12}};
    public static final Map<String, Integer> TABLE_COLUMNS_MAP = new HashMap<String, Integer>();
    public static final String TABLE_SQL_CREATE = "create table OAuth2Application (oAuth2ApplicationId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,oA2AScopeAliasesId LONG,allowedGrantTypes VARCHAR(75) null,clientId VARCHAR(75) null,clientProfile INTEGER,clientSecret VARCHAR(75) null,description STRING null,features STRING null,homePageURL STRING null,iconFileEntryId LONG,name VARCHAR(75) null,privacyPolicyURL STRING null,redirectURIs STRING null)";
    public static final String TABLE_SQL_DROP = "drop table OAuth2Application";
    public static final String ORDER_BY_JPQL = " ORDER BY oAuth2Application.oAuth2ApplicationId ASC";
    public static final String ORDER_BY_SQL = " ORDER BY OAuth2Application.oAuth2ApplicationId ASC";
    public static final String DATA_SOURCE = "liferayDataSource";
    public static final String SESSION_FACTORY = "liferaySessionFactory";
    public static final String TX_MANAGER = "liferayTransactionManager";
    public static final boolean ENTITY_CACHE_ENABLED;
    public static final boolean FINDER_CACHE_ENABLED;
    public static final boolean COLUMN_BITMASK_ENABLED;
    public static final long CLIENTID_COLUMN_BITMASK = 1L;
    public static final long COMPANYID_COLUMN_BITMASK = 2L;
    public static final long OAUTH2APPLICATIONID_COLUMN_BITMASK = 4L;
    public static final long LOCK_EXPIRATION_TIME;
    private static final ClassLoader _classLoader;
    private static final Class<?>[] _escapedModelInterfaces;
    private long _oAuth2ApplicationId;
    private long _companyId;
    private long _originalCompanyId;
    private boolean _setOriginalCompanyId;
    private long _userId;
    private String _userName;
    private Date _createDate;
    private Date _modifiedDate;
    private boolean _setModifiedDate;
    private long _oAuth2ApplicationScopeAliasesId;
    private String _allowedGrantTypes;
    private String _clientId;
    private String _originalClientId;
    private int _clientProfile;
    private String _clientSecret;
    private String _description;
    private String _features;
    private String _homePageURL;
    private long _iconFileEntryId;
    private String _name;
    private String _privacyPolicyURL;
    private String _redirectURIs;
    private long _columnBitmask;
    private OAuth2Application _escapedModel;

    public static OAuth2Application toModel(OAuth2ApplicationSoap soapModel) {
        if (soapModel == null) {
            return null;
        }
        OAuth2ApplicationImpl model = new OAuth2ApplicationImpl();
        model.setOAuth2ApplicationId(soapModel.getOAuth2ApplicationId());
        model.setCompanyId(soapModel.getCompanyId());
        model.setUserId(soapModel.getUserId());
        model.setUserName(soapModel.getUserName());
        model.setCreateDate(soapModel.getCreateDate());
        model.setModifiedDate(soapModel.getModifiedDate());
        model.setOAuth2ApplicationScopeAliasesId(soapModel.getOAuth2ApplicationScopeAliasesId());
        model.setAllowedGrantTypes(soapModel.getAllowedGrantTypes());
        model.setClientId(soapModel.getClientId());
        model.setClientProfile(soapModel.getClientProfile());
        model.setClientSecret(soapModel.getClientSecret());
        model.setDescription(soapModel.getDescription());
        model.setFeatures(soapModel.getFeatures());
        model.setHomePageURL(soapModel.getHomePageURL());
        model.setIconFileEntryId(soapModel.getIconFileEntryId());
        model.setName(soapModel.getName());
        model.setPrivacyPolicyURL(soapModel.getPrivacyPolicyURL());
        model.setRedirectURIs(soapModel.getRedirectURIs());
        return model;
    }

    public static List<OAuth2Application> toModels(OAuth2ApplicationSoap[] soapModels) {
        if (soapModels == null) {
            return null;
        }
        ArrayList<OAuth2Application> models = new ArrayList<OAuth2Application>(soapModels.length);
        for (OAuth2ApplicationSoap soapModel : soapModels) {
            models.add(OAuth2ApplicationModelImpl.toModel(soapModel));
        }
        return models;
    }

    public long getPrimaryKey() {
        return this._oAuth2ApplicationId;
    }

    public void setPrimaryKey(long primaryKey) {
        this.setOAuth2ApplicationId(primaryKey);
    }

    public Serializable getPrimaryKeyObj() {
        return Long.valueOf(this._oAuth2ApplicationId);
    }

    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        this.setPrimaryKey((Long)primaryKeyObj);
    }

    public Class<?> getModelClass() {
        return OAuth2Application.class;
    }

    public String getModelClassName() {
        return OAuth2Application.class.getName();
    }

    public Map<String, Object> getModelAttributes() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("oAuth2ApplicationId", this.getOAuth2ApplicationId());
        attributes.put("companyId", this.getCompanyId());
        attributes.put("userId", this.getUserId());
        attributes.put("userName", this.getUserName());
        attributes.put("createDate", this.getCreateDate());
        attributes.put("modifiedDate", this.getModifiedDate());
        attributes.put("oAuth2ApplicationScopeAliasesId", this.getOAuth2ApplicationScopeAliasesId());
        attributes.put("allowedGrantTypes", this.getAllowedGrantTypes());
        attributes.put("clientId", this.getClientId());
        attributes.put("clientProfile", this.getClientProfile());
        attributes.put("clientSecret", this.getClientSecret());
        attributes.put("description", this.getDescription());
        attributes.put("features", this.getFeatures());
        attributes.put("homePageURL", this.getHomePageURL());
        attributes.put("iconFileEntryId", this.getIconFileEntryId());
        attributes.put("name", this.getName());
        attributes.put("privacyPolicyURL", this.getPrivacyPolicyURL());
        attributes.put("redirectURIs", this.getRedirectURIs());
        attributes.put("entityCacheEnabled", this.isEntityCacheEnabled());
        attributes.put("finderCacheEnabled", this.isFinderCacheEnabled());
        return attributes;
    }

    public void setModelAttributes(Map<String, Object> attributes) {
        String redirectURIs;
        String privacyPolicyURL;
        String name;
        Long iconFileEntryId;
        String homePageURL;
        String features;
        String description;
        String clientSecret;
        Integer clientProfile;
        String clientId;
        String allowedGrantTypes;
        Long oAuth2ApplicationScopeAliasesId;
        Date modifiedDate;
        Date createDate;
        String userName;
        Long userId;
        Long companyId;
        Long oAuth2ApplicationId = (Long)attributes.get("oAuth2ApplicationId");
        if (oAuth2ApplicationId != null) {
            this.setOAuth2ApplicationId(oAuth2ApplicationId);
        }
        if ((companyId = (Long)attributes.get("companyId")) != null) {
            this.setCompanyId(companyId);
        }
        if ((userId = (Long)attributes.get("userId")) != null) {
            this.setUserId(userId);
        }
        if ((userName = (String)attributes.get("userName")) != null) {
            this.setUserName(userName);
        }
        if ((createDate = (Date)attributes.get("createDate")) != null) {
            this.setCreateDate(createDate);
        }
        if ((modifiedDate = (Date)attributes.get("modifiedDate")) != null) {
            this.setModifiedDate(modifiedDate);
        }
        if ((oAuth2ApplicationScopeAliasesId = (Long)attributes.get("oAuth2ApplicationScopeAliasesId")) != null) {
            this.setOAuth2ApplicationScopeAliasesId(oAuth2ApplicationScopeAliasesId);
        }
        if ((allowedGrantTypes = (String)attributes.get("allowedGrantTypes")) != null) {
            this.setAllowedGrantTypes(allowedGrantTypes);
        }
        if ((clientId = (String)attributes.get("clientId")) != null) {
            this.setClientId(clientId);
        }
        if ((clientProfile = (Integer)attributes.get("clientProfile")) != null) {
            this.setClientProfile(clientProfile);
        }
        if ((clientSecret = (String)attributes.get("clientSecret")) != null) {
            this.setClientSecret(clientSecret);
        }
        if ((description = (String)attributes.get("description")) != null) {
            this.setDescription(description);
        }
        if ((features = (String)attributes.get("features")) != null) {
            this.setFeatures(features);
        }
        if ((homePageURL = (String)attributes.get("homePageURL")) != null) {
            this.setHomePageURL(homePageURL);
        }
        if ((iconFileEntryId = (Long)attributes.get("iconFileEntryId")) != null) {
            this.setIconFileEntryId(iconFileEntryId);
        }
        if ((name = (String)attributes.get("name")) != null) {
            this.setName(name);
        }
        if ((privacyPolicyURL = (String)attributes.get("privacyPolicyURL")) != null) {
            this.setPrivacyPolicyURL(privacyPolicyURL);
        }
        if ((redirectURIs = (String)attributes.get("redirectURIs")) != null) {
            this.setRedirectURIs(redirectURIs);
        }
    }

    @JSON
    public long getOAuth2ApplicationId() {
        return this._oAuth2ApplicationId;
    }

    public void setOAuth2ApplicationId(long oAuth2ApplicationId) {
        this._oAuth2ApplicationId = oAuth2ApplicationId;
    }

    @JSON
    public long getCompanyId() {
        return this._companyId;
    }

    public void setCompanyId(long companyId) {
        this._columnBitmask |= 2L;
        if (!this._setOriginalCompanyId) {
            this._setOriginalCompanyId = true;
            this._originalCompanyId = this._companyId;
        }
        this._companyId = companyId;
    }

    public long getOriginalCompanyId() {
        return this._originalCompanyId;
    }

    @JSON
    public long getUserId() {
        return this._userId;
    }

    public void setUserId(long userId) {
        this._userId = userId;
    }

    public String getUserUuid() {
        try {
            User user = UserLocalServiceUtil.getUserById((long)this.getUserId());
            return user.getUuid();
        }
        catch (PortalException pe) {
            return "";
        }
    }

    public void setUserUuid(String userUuid) {
    }

    @JSON
    public String getUserName() {
        if (this._userName == null) {
            return "";
        }
        return this._userName;
    }

    public void setUserName(String userName) {
        this._userName = userName;
    }

    @JSON
    public Date getCreateDate() {
        return this._createDate;
    }

    public void setCreateDate(Date createDate) {
        this._createDate = createDate;
    }

    @JSON
    public Date getModifiedDate() {
        return this._modifiedDate;
    }

    public boolean hasSetModifiedDate() {
        return this._setModifiedDate;
    }

    public void setModifiedDate(Date modifiedDate) {
        this._setModifiedDate = true;
        this._modifiedDate = modifiedDate;
    }

    @JSON
    public long getOAuth2ApplicationScopeAliasesId() {
        return this._oAuth2ApplicationScopeAliasesId;
    }

    public void setOAuth2ApplicationScopeAliasesId(long oAuth2ApplicationScopeAliasesId) {
        this._oAuth2ApplicationScopeAliasesId = oAuth2ApplicationScopeAliasesId;
    }

    @JSON
    public String getAllowedGrantTypes() {
        if (this._allowedGrantTypes == null) {
            return "";
        }
        return this._allowedGrantTypes;
    }

    public void setAllowedGrantTypes(String allowedGrantTypes) {
        this._allowedGrantTypes = allowedGrantTypes;
    }

    @JSON
    public String getClientId() {
        if (this._clientId == null) {
            return "";
        }
        return this._clientId;
    }

    public void setClientId(String clientId) {
        this._columnBitmask |= 1L;
        if (this._originalClientId == null) {
            this._originalClientId = this._clientId;
        }
        this._clientId = clientId;
    }

    public String getOriginalClientId() {
        return GetterUtil.getString((String)this._originalClientId);
    }

    @JSON
    public int getClientProfile() {
        return this._clientProfile;
    }

    public void setClientProfile(int clientProfile) {
        this._clientProfile = clientProfile;
    }

    @JSON
    public String getClientSecret() {
        if (this._clientSecret == null) {
            return "";
        }
        return this._clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this._clientSecret = clientSecret;
    }

    @JSON
    public String getDescription() {
        if (this._description == null) {
            return "";
        }
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    @JSON
    public String getFeatures() {
        if (this._features == null) {
            return "";
        }
        return this._features;
    }

    public void setFeatures(String features) {
        this._features = features;
    }

    @JSON
    public String getHomePageURL() {
        if (this._homePageURL == null) {
            return "";
        }
        return this._homePageURL;
    }

    public void setHomePageURL(String homePageURL) {
        this._homePageURL = homePageURL;
    }

    @JSON
    public long getIconFileEntryId() {
        return this._iconFileEntryId;
    }

    public void setIconFileEntryId(long iconFileEntryId) {
        this._iconFileEntryId = iconFileEntryId;
    }

    @JSON
    public String getName() {
        if (this._name == null) {
            return "";
        }
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    @JSON
    public String getPrivacyPolicyURL() {
        if (this._privacyPolicyURL == null) {
            return "";
        }
        return this._privacyPolicyURL;
    }

    public void setPrivacyPolicyURL(String privacyPolicyURL) {
        this._privacyPolicyURL = privacyPolicyURL;
    }

    @JSON
    public String getRedirectURIs() {
        if (this._redirectURIs == null) {
            return "";
        }
        return this._redirectURIs;
    }

    public void setRedirectURIs(String redirectURIs) {
        this._redirectURIs = redirectURIs;
    }

    public long getColumnBitmask() {
        return this._columnBitmask;
    }

    public ExpandoBridge getExpandoBridge() {
        return ExpandoBridgeFactoryUtil.getExpandoBridge((long)this.getCompanyId(), (String)OAuth2Application.class.getName(), (long)this.getPrimaryKey());
    }

    public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
        ExpandoBridge expandoBridge = this.getExpandoBridge();
        expandoBridge.setAttributes(serviceContext);
    }

    public OAuth2Application toEscapedModel() {
        if (this._escapedModel == null) {
            this._escapedModel = (OAuth2Application)ProxyUtil.newProxyInstance((ClassLoader)_classLoader, (Class[])_escapedModelInterfaces, (InvocationHandler)new AutoEscapeBeanHandler((Object)this));
        }
        return this._escapedModel;
    }

    public Object clone() {
        OAuth2ApplicationImpl oAuth2ApplicationImpl = new OAuth2ApplicationImpl();
        oAuth2ApplicationImpl.setOAuth2ApplicationId(this.getOAuth2ApplicationId());
        oAuth2ApplicationImpl.setCompanyId(this.getCompanyId());
        oAuth2ApplicationImpl.setUserId(this.getUserId());
        oAuth2ApplicationImpl.setUserName(this.getUserName());
        oAuth2ApplicationImpl.setCreateDate(this.getCreateDate());
        oAuth2ApplicationImpl.setModifiedDate(this.getModifiedDate());
        oAuth2ApplicationImpl.setOAuth2ApplicationScopeAliasesId(this.getOAuth2ApplicationScopeAliasesId());
        oAuth2ApplicationImpl.setAllowedGrantTypes(this.getAllowedGrantTypes());
        oAuth2ApplicationImpl.setClientId(this.getClientId());
        oAuth2ApplicationImpl.setClientProfile(this.getClientProfile());
        oAuth2ApplicationImpl.setClientSecret(this.getClientSecret());
        oAuth2ApplicationImpl.setDescription(this.getDescription());
        oAuth2ApplicationImpl.setFeatures(this.getFeatures());
        oAuth2ApplicationImpl.setHomePageURL(this.getHomePageURL());
        oAuth2ApplicationImpl.setIconFileEntryId(this.getIconFileEntryId());
        oAuth2ApplicationImpl.setName(this.getName());
        oAuth2ApplicationImpl.setPrivacyPolicyURL(this.getPrivacyPolicyURL());
        oAuth2ApplicationImpl.setRedirectURIs(this.getRedirectURIs());
        oAuth2ApplicationImpl.resetOriginalValues();
        return oAuth2ApplicationImpl;
    }

    public int compareTo(OAuth2Application oAuth2Application) {
        long primaryKey = oAuth2Application.getPrimaryKey();
        if (this.getPrimaryKey() < primaryKey) {
            return -1;
        }
        if (this.getPrimaryKey() > primaryKey) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OAuth2Application)) {
            return false;
        }
        OAuth2Application oAuth2Application = (OAuth2Application)obj;
        long primaryKey = oAuth2Application.getPrimaryKey();
        return this.getPrimaryKey() == primaryKey;
    }

    public int hashCode() {
        return (int)this.getPrimaryKey();
    }

    public boolean isEntityCacheEnabled() {
        return ENTITY_CACHE_ENABLED;
    }

    public boolean isFinderCacheEnabled() {
        return FINDER_CACHE_ENABLED;
    }

    public void resetOriginalValues() {
        OAuth2ApplicationModelImpl oAuth2ApplicationModelImpl = this;
        oAuth2ApplicationModelImpl._originalCompanyId = oAuth2ApplicationModelImpl._companyId;
        oAuth2ApplicationModelImpl._setOriginalCompanyId = false;
        oAuth2ApplicationModelImpl._setModifiedDate = false;
        oAuth2ApplicationModelImpl._originalClientId = oAuth2ApplicationModelImpl._clientId;
        oAuth2ApplicationModelImpl._columnBitmask = 0L;
    }

    public CacheModel<OAuth2Application> toCacheModel() {
        String redirectURIs;
        String privacyPolicyURL;
        String homePageURL;
        String features;
        String description;
        String clientId;
        Date createDate;
        OAuth2ApplicationCacheModel oAuth2ApplicationCacheModel = new OAuth2ApplicationCacheModel();
        oAuth2ApplicationCacheModel.oAuth2ApplicationId = this.getOAuth2ApplicationId();
        oAuth2ApplicationCacheModel.companyId = this.getCompanyId();
        oAuth2ApplicationCacheModel.userId = this.getUserId();
        oAuth2ApplicationCacheModel.userName = this.getUserName();
        String userName = oAuth2ApplicationCacheModel.userName;
        if (userName != null && userName.length() == 0) {
            oAuth2ApplicationCacheModel.userName = null;
        }
        oAuth2ApplicationCacheModel.createDate = (createDate = this.getCreateDate()) != null ? createDate.getTime() : Long.MIN_VALUE;
        Date modifiedDate = this.getModifiedDate();
        oAuth2ApplicationCacheModel.modifiedDate = modifiedDate != null ? modifiedDate.getTime() : Long.MIN_VALUE;
        oAuth2ApplicationCacheModel.oAuth2ApplicationScopeAliasesId = this.getOAuth2ApplicationScopeAliasesId();
        oAuth2ApplicationCacheModel.allowedGrantTypes = this.getAllowedGrantTypes();
        String allowedGrantTypes = oAuth2ApplicationCacheModel.allowedGrantTypes;
        if (allowedGrantTypes != null && allowedGrantTypes.length() == 0) {
            oAuth2ApplicationCacheModel.allowedGrantTypes = null;
        }
        if ((clientId = (oAuth2ApplicationCacheModel.clientId = this.getClientId())) != null && clientId.length() == 0) {
            oAuth2ApplicationCacheModel.clientId = null;
        }
        oAuth2ApplicationCacheModel.clientProfile = this.getClientProfile();
        oAuth2ApplicationCacheModel.clientSecret = this.getClientSecret();
        String clientSecret = oAuth2ApplicationCacheModel.clientSecret;
        if (clientSecret != null && clientSecret.length() == 0) {
            oAuth2ApplicationCacheModel.clientSecret = null;
        }
        if ((description = (oAuth2ApplicationCacheModel.description = this.getDescription())) != null && description.length() == 0) {
            oAuth2ApplicationCacheModel.description = null;
        }
        if ((features = (oAuth2ApplicationCacheModel.features = this.getFeatures())) != null && features.length() == 0) {
            oAuth2ApplicationCacheModel.features = null;
        }
        if ((homePageURL = (oAuth2ApplicationCacheModel.homePageURL = this.getHomePageURL())) != null && homePageURL.length() == 0) {
            oAuth2ApplicationCacheModel.homePageURL = null;
        }
        oAuth2ApplicationCacheModel.iconFileEntryId = this.getIconFileEntryId();
        oAuth2ApplicationCacheModel.name = this.getName();
        String name = oAuth2ApplicationCacheModel.name;
        if (name != null && name.length() == 0) {
            oAuth2ApplicationCacheModel.name = null;
        }
        if ((privacyPolicyURL = (oAuth2ApplicationCacheModel.privacyPolicyURL = this.getPrivacyPolicyURL())) != null && privacyPolicyURL.length() == 0) {
            oAuth2ApplicationCacheModel.privacyPolicyURL = null;
        }
        if ((redirectURIs = (oAuth2ApplicationCacheModel.redirectURIs = this.getRedirectURIs())) != null && redirectURIs.length() == 0) {
            oAuth2ApplicationCacheModel.redirectURIs = null;
        }
        return oAuth2ApplicationCacheModel;
    }

    public String toString() {
        StringBundler sb = new StringBundler(37);
        sb.append("{oAuth2ApplicationId=");
        sb.append(this.getOAuth2ApplicationId());
        sb.append(", companyId=");
        sb.append(this.getCompanyId());
        sb.append(", userId=");
        sb.append(this.getUserId());
        sb.append(", userName=");
        sb.append(this.getUserName());
        sb.append(", createDate=");
        sb.append((Object)this.getCreateDate());
        sb.append(", modifiedDate=");
        sb.append((Object)this.getModifiedDate());
        sb.append(", oAuth2ApplicationScopeAliasesId=");
        sb.append(this.getOAuth2ApplicationScopeAliasesId());
        sb.append(", allowedGrantTypes=");
        sb.append(this.getAllowedGrantTypes());
        sb.append(", clientId=");
        sb.append(this.getClientId());
        sb.append(", clientProfile=");
        sb.append(this.getClientProfile());
        sb.append(", clientSecret=");
        sb.append(this.getClientSecret());
        sb.append(", description=");
        sb.append(this.getDescription());
        sb.append(", features=");
        sb.append(this.getFeatures());
        sb.append(", homePageURL=");
        sb.append(this.getHomePageURL());
        sb.append(", iconFileEntryId=");
        sb.append(this.getIconFileEntryId());
        sb.append(", name=");
        sb.append(this.getName());
        sb.append(", privacyPolicyURL=");
        sb.append(this.getPrivacyPolicyURL());
        sb.append(", redirectURIs=");
        sb.append(this.getRedirectURIs());
        sb.append("}");
        return sb.toString();
    }

    public String toXmlString() {
        StringBundler sb = new StringBundler(58);
        sb.append("<model><model-name>");
        sb.append("com.liferay.oauth2.provider.model.OAuth2Application");
        sb.append("</model-name>");
        sb.append("<column><column-name>oAuth2ApplicationId</column-name><column-value><![CDATA[");
        sb.append(this.getOAuth2ApplicationId());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>companyId</column-name><column-value><![CDATA[");
        sb.append(this.getCompanyId());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>userId</column-name><column-value><![CDATA[");
        sb.append(this.getUserId());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>userName</column-name><column-value><![CDATA[");
        sb.append(this.getUserName());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>createDate</column-name><column-value><![CDATA[");
        sb.append((Object)this.getCreateDate());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>modifiedDate</column-name><column-value><![CDATA[");
        sb.append((Object)this.getModifiedDate());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>oAuth2ApplicationScopeAliasesId</column-name><column-value><![CDATA[");
        sb.append(this.getOAuth2ApplicationScopeAliasesId());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>allowedGrantTypes</column-name><column-value><![CDATA[");
        sb.append(this.getAllowedGrantTypes());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>clientId</column-name><column-value><![CDATA[");
        sb.append(this.getClientId());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>clientProfile</column-name><column-value><![CDATA[");
        sb.append(this.getClientProfile());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>clientSecret</column-name><column-value><![CDATA[");
        sb.append(this.getClientSecret());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>description</column-name><column-value><![CDATA[");
        sb.append(this.getDescription());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>features</column-name><column-value><![CDATA[");
        sb.append(this.getFeatures());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>homePageURL</column-name><column-value><![CDATA[");
        sb.append(this.getHomePageURL());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>iconFileEntryId</column-name><column-value><![CDATA[");
        sb.append(this.getIconFileEntryId());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>name</column-name><column-value><![CDATA[");
        sb.append(this.getName());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>privacyPolicyURL</column-name><column-value><![CDATA[");
        sb.append(this.getPrivacyPolicyURL());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>redirectURIs</column-name><column-value><![CDATA[");
        sb.append(this.getRedirectURIs());
        sb.append("]]></column-value></column>");
        sb.append("</model>");
        return sb.toString();
    }

    static {
        TABLE_COLUMNS_MAP.put("oAuth2ApplicationId", -5);
        TABLE_COLUMNS_MAP.put("companyId", -5);
        TABLE_COLUMNS_MAP.put("userId", -5);
        TABLE_COLUMNS_MAP.put("userName", 12);
        TABLE_COLUMNS_MAP.put("createDate", 93);
        TABLE_COLUMNS_MAP.put("modifiedDate", 93);
        TABLE_COLUMNS_MAP.put("oA2AScopeAliasesId", -5);
        TABLE_COLUMNS_MAP.put("allowedGrantTypes", 12);
        TABLE_COLUMNS_MAP.put("clientId", 12);
        TABLE_COLUMNS_MAP.put("clientProfile", 4);
        TABLE_COLUMNS_MAP.put("clientSecret", 12);
        TABLE_COLUMNS_MAP.put("description", 12);
        TABLE_COLUMNS_MAP.put("features", 12);
        TABLE_COLUMNS_MAP.put("homePageURL", 12);
        TABLE_COLUMNS_MAP.put("iconFileEntryId", -5);
        TABLE_COLUMNS_MAP.put("name", 12);
        TABLE_COLUMNS_MAP.put("privacyPolicyURL", 12);
        TABLE_COLUMNS_MAP.put("redirectURIs", 12);
        ENTITY_CACHE_ENABLED = GetterUtil.getBoolean((String)ServiceProps.get("value.object.entity.cache.enabled.com.liferay.oauth2.provider.model.OAuth2Application"), (boolean)true);
        FINDER_CACHE_ENABLED = GetterUtil.getBoolean((String)ServiceProps.get("value.object.finder.cache.enabled.com.liferay.oauth2.provider.model.OAuth2Application"), (boolean)true);
        COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean((String)ServiceProps.get("value.object.column.bitmask.enabled.com.liferay.oauth2.provider.model.OAuth2Application"), (boolean)true);
        LOCK_EXPIRATION_TIME = GetterUtil.getLong((String)ServiceProps.get("lock.expiration.time.com.liferay.oauth2.provider.model.OAuth2Application"));
        _classLoader = OAuth2Application.class.getClassLoader();
        _escapedModelInterfaces = new Class[]{OAuth2Application.class, ModelWrapper.class};
    }
}

