/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.scope.internal.spi.prefix.handler;

import com.liferay.oauth2.provider.scope.internal.configuration.BundlePrefixHandlerFactoryConfiguration;
import com.liferay.oauth2.provider.scope.spi.prefix.handler.PrefixHandler;
import com.liferay.oauth2.provider.scope.spi.prefix.handler.PrefixHandlerFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@Component(configurationPid={"com.liferay.oauth2.provider.scope.internal.configuration.BundlePrefixHandlerFactoryConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, service={PrefixHandlerFactory.class})
public class PrefixHandlerFactoryImpl
implements PrefixHandlerFactory {
    private static final Log _log = LogFactoryUtil.getLog(PrefixHandlerFactoryImpl.class);
    private BundleContext _bundleContext;
    private final Map<String, String> _defaults = new HashMap<String, String>();
    private String _delimiter = "/";
    private List<String> _excludedInputs;
    private boolean _includeBundleSymbolicName;
    private final Collection<String> _serviceProperties = new ArrayList<String>();

    public PrefixHandler create(Function<String, Object> propertyAccessorFunction) {
        ArrayList<String> strings = new ArrayList<String>(this._serviceProperties.size() + 1);
        if (this._includeBundleSymbolicName) {
            Bundle bundle = this.getBundle(propertyAccessorFunction);
            if (bundle != null) {
                strings.add(bundle.getSymbolicName());
            } else if (_log.isDebugEnabled()) {
                _log.debug((Object)("bundle.id in " + this._serviceProperties + " is not valid"));
            }
        }
        for (String serviceProperty : this._serviceProperties) {
            Object value = propertyAccessorFunction.apply(serviceProperty);
            if (Validator.isNotNull((Object)value)) {
                strings.add(value.toString());
                continue;
            }
            String defaultValue = this._defaults.get(serviceProperty);
            if (!Validator.isNotNull((String)defaultValue)) continue;
            strings.add(defaultValue);
        }
        String prefix = StringUtil.merge(strings, (String)this._delimiter);
        return input -> {
            if (this._excludedInputs.contains(input)) {
                return input;
            }
            return StringBundler.concat((String[])new String[]{prefix, this._delimiter, input});
        };
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this._bundleContext = bundleContext;
        BundlePrefixHandlerFactoryConfiguration bundlePrefixHandlerFactoryConfiguration = (BundlePrefixHandlerFactoryConfiguration)ConfigurableUtil.createConfigurable(BundlePrefixHandlerFactoryConfiguration.class, properties);
        this._delimiter = bundlePrefixHandlerFactoryConfiguration.delimiter();
        Stream<String> stream = Arrays.stream(bundlePrefixHandlerFactoryConfiguration.excludedScopes());
        this._excludedInputs = stream.filter(e -> !Validator.isBlank((String)e)).collect(Collectors.toList());
        this._includeBundleSymbolicName = bundlePrefixHandlerFactoryConfiguration.includeBundleSymbolicName();
        for (String serviceProperty : bundlePrefixHandlerFactoryConfiguration.serviceProperties()) {
            this._serviceProperties.add(this.initializeServiceProperty(serviceProperty));
        }
    }

    protected Bundle getBundle(Function<String, Object> propertyAccessorFunction) {
        long bundleId = GetterUtil.getLong((Object)propertyAccessorFunction.apply("original.service.bundleid"), (long)GetterUtil.getLong((Object)propertyAccessorFunction.apply("service.bundleid"), (long)-1L));
        if (bundleId == -1L) {
            return null;
        }
        return this._bundleContext.getBundle(bundleId);
    }

    protected String initializeServiceProperty(String serviceProperty) {
        int indexOfSpace = serviceProperty.indexOf(" ");
        if (indexOfSpace == -1) {
            return serviceProperty;
        }
        String defaultsKey = serviceProperty.substring(0, indexOfSpace);
        Properties modifiers = new Properties();
        try {
            modifiers.load(new StringReader(serviceProperty.substring(indexOfSpace)));
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(ioe);
        }
        this._defaults.put(defaultsKey, GetterUtil.getString((String)modifiers.getProperty("default")));
        return defaultsKey;
    }
}

