/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.scope.internal.liferay;

import com.liferay.oauth2.provider.scope.internal.configuration.ScopeLocatorConfiguration;
import com.liferay.oauth2.provider.scope.internal.liferay.LiferayOAuth2ScopeImpl;
import com.liferay.oauth2.provider.scope.liferay.LiferayOAuth2Scope;
import com.liferay.oauth2.provider.scope.liferay.ScopeLocator;
import com.liferay.oauth2.provider.scope.liferay.ScopedServiceTrackerMap;
import com.liferay.oauth2.provider.scope.liferay.ScopedServiceTrackerMapFactory;
import com.liferay.oauth2.provider.scope.spi.prefix.handler.PrefixHandler;
import com.liferay.oauth2.provider.scope.spi.prefix.handler.PrefixHandlerFactory;
import com.liferay.oauth2.provider.scope.spi.scope.finder.ScopeFinder;
import com.liferay.oauth2.provider.scope.spi.scope.mapper.ScopeMapper;
import com.liferay.oauth2.provider.scope.spi.scope.matcher.ScopeMatcher;
import com.liferay.oauth2.provider.scope.spi.scope.matcher.ScopeMatcherFactory;
import com.liferay.osgi.service.tracker.collections.ServiceReferenceServiceTuple;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.osgi.annotation.versioning.ProviderType;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(immediate=true, service={ScopeLocator.class})
public class ScopeLocatorImpl
implements ScopeLocator {
    private BundleContext _bundleContext;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(osgi.jaxrs.name=Default)")
    private volatile PrefixHandlerFactory _defaultPrefixHandlerFactory;
    private final ScopeLocatorConfiguration _defaultScopeLocatorConfiguration = (ScopeLocatorConfiguration)ConfigurableUtil.createConfigurable(ScopeLocatorConfiguration.class, Collections.emptyMap());
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(osgi.jaxrs.name=Default)")
    private volatile ScopeLocatorConfigurationProvider _defaultScopeLocatorConfigurationProvider;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(osgi.jaxrs.name=Default)")
    private volatile ScopeMapper _defaultScopeMapper;
    private ScopeMatcherFactory _defaultScopeMatcherFactory;
    private ScopedServiceTrackerMap<PrefixHandlerFactory> _prefixHandlerFactoriesScopedServiceTrackerMap;
    private ScopedServiceTrackerMapFactory _scopedServiceTrackerMapFactory;
    private ServiceTrackerMap<String, ServiceReferenceServiceTuple<?, ScopeFinder>> _scopeFinderByNameServiceTrackerMap;
    private ScopedServiceTrackerMap<ScopeFinder> _scopeFindersScopedServiceTrackerMap;
    private ScopedServiceTrackerMap<ScopeLocatorConfigurationProvider> _scopeLocatorConfigurationProvidersScopedServiceTrackerMap;
    private ScopedServiceTrackerMap<ScopeMapper> _scopeMappersScopedServiceTrackerMap;
    private ServiceTrackerMap<String, ScopeMatcherFactory> _scopeMatcherFactoriesServiceTrackerMap;

    public LiferayOAuth2Scope getLiferayOAuth2Scope(long companyId, String applicationName, String scope) {
        ServiceReferenceServiceTuple serviceReferenceServiceTuple = (ServiceReferenceServiceTuple)this._scopeFinderByNameServiceTrackerMap.getService((Object)applicationName);
        if (serviceReferenceServiceTuple == null) {
            return null;
        }
        Bundle bundle = this.getBundle(serviceReferenceServiceTuple.getServiceReference());
        return new LiferayOAuth2ScopeImpl(applicationName, bundle, scope);
    }

    public Collection<LiferayOAuth2Scope> getLiferayOAuth2Scopes(long companyId, String scopesAlias) {
        Set names = this._scopeFinderByNameServiceTrackerMap.keySet();
        ArrayList<LiferayOAuth2Scope> liferayOAuth2Scopes = new ArrayList<LiferayOAuth2Scope>();
        for (String name : names) {
            liferayOAuth2Scopes.addAll(this.getLiferayOAuth2Scopes(companyId, scopesAlias, name));
        }
        return liferayOAuth2Scopes;
    }

    public Collection<LiferayOAuth2Scope> getLiferayOAuth2Scopes(long companyId, String scopesAlias, String applicationName) {
        ScopeFinder scopeFinder = (ScopeFinder)this._scopeFindersScopedServiceTrackerMap.getService(companyId, applicationName);
        Collection scopes = scopeFinder.findScopes();
        if (scopes.isEmpty()) {
            return Collections.emptyList();
        }
        ServiceReferenceServiceTuple serviceReferenceServiceTuple = (ServiceReferenceServiceTuple)this._scopeFinderByNameServiceTrackerMap.getService((Object)applicationName);
        PrefixHandlerFactory prefixHandlerFactory = (PrefixHandlerFactory)this._prefixHandlerFactoriesScopedServiceTrackerMap.getService(companyId, applicationName);
        ServiceReference serviceReference = serviceReferenceServiceTuple.getServiceReference();
        Bundle bundle = this.getBundle(serviceReference);
        HashSet<LiferayOAuth2Scope> locatedScopes = new HashSet<LiferayOAuth2Scope>(scopes.size());
        HashMap<String, Set> mappedScopeToUnmappedScopes = new HashMap<String, Set>();
        HashMap<String, Boolean> matchCache = new HashMap<String, Boolean>();
        PrefixHandler prefixHandler = prefixHandlerFactory.create(arg_0 -> ((ServiceReference)serviceReference).getProperty(arg_0));
        LinkedList<String> queue = new LinkedList<String>();
        ScopeMapper scopeMapper = (ScopeMapper)this._scopeMappersScopedServiceTrackerMap.getService(companyId, applicationName);
        ScopeMatcherFactory scopeMatcherFactory = this.getScopeMatcherFactory(companyId);
        for (String scope : scopes) {
            for (String mappedScope2 : scopeMapper.map(scope)) {
                boolean matched = matchCache.computeIfAbsent(mappedScope2, key -> this.scopeMatchesScopesAlias((String)key, scopeMatcherFactory, prefixHandler, scopesAlias));
                if (matched) {
                    queue.add(scope);
                }
                Set unmappedScopes2 = mappedScopeToUnmappedScopes.computeIfAbsent(mappedScope2, key -> new HashSet());
                unmappedScopes2.add(scope);
            }
        }
        ScopeLocatorConfigurationProvider scopeLocatorConfigurationProvider = (ScopeLocatorConfigurationProvider)this._scopeLocatorConfigurationProvidersScopedServiceTrackerMap.getService(companyId, applicationName);
        ScopeLocatorConfiguration scopeLocatorConfiguration = scopeLocatorConfigurationProvider.getScopeLocatorConfiguration();
        HashSet<String> processedScopes = new HashSet<String>(queue.size());
        String scope = (String)queue.poll();
        while (scope != null) {
            processedScopes.add(scope);
            locatedScopes.add(new LiferayOAuth2ScopeImpl(applicationName, bundle, scope));
            if (scopeLocatorConfiguration.includeScopesImpliedBeforeScopeMapping()) {
                ScopeMatcher scopeMatcher = scopeMatcherFactory.create(scope);
                mappedScopeToUnmappedScopes.forEach((mappedScope, unmappedScopes) -> {
                    boolean matched = matchCache.compute((String)mappedScope, (key, matches) -> {
                        if (!matches.booleanValue()) {
                            return scopeMatcher.match(mappedScope);
                        }
                        return matches;
                    });
                    if (!matched) {
                        return;
                    }
                    for (String unmappedScope : unmappedScopes) {
                        if (processedScopes.contains(unmappedScope)) continue;
                        queue.add(unmappedScope);
                    }
                });
            }
            scope = (String)queue.poll();
        }
        return locatedScopes;
    }

    public Collection<String> getScopeAliases(long companyId) {
        HashSet<String> scopesAliases = new HashSet<String>();
        Set applicationNames = this._scopeFinderByNameServiceTrackerMap.keySet();
        for (String applicationName : applicationNames) {
            scopesAliases.addAll(this.getScopeAliases(companyId, applicationName));
        }
        return scopesAliases;
    }

    public Collection<String> getScopeAliases(long companyId, String applicationName) {
        ServiceReferenceServiceTuple serviceReferenceServiceTuple = (ServiceReferenceServiceTuple)this._scopeFinderByNameServiceTrackerMap.getService((Object)applicationName);
        PrefixHandlerFactory prefixHandlerFactory = (PrefixHandlerFactory)this._prefixHandlerFactoriesScopedServiceTrackerMap.getService(companyId, applicationName);
        ServiceReference serviceReference = serviceReferenceServiceTuple.getServiceReference();
        PrefixHandler prefixHandler = prefixHandlerFactory.create(arg_0 -> ((ServiceReference)serviceReference).getProperty(arg_0));
        ScopeFinder scopeFinder = (ScopeFinder)this._scopeFindersScopedServiceTrackerMap.getService(companyId, applicationName);
        ScopeMapper scopeMapper = (ScopeMapper)this._scopeMappersScopedServiceTrackerMap.getService(companyId, applicationName);
        Collection scopes = scopeFinder.findScopes();
        ArrayList<String> scopesAliases = new ArrayList<String>();
        for (String scope : scopes) {
            Set mappedScopes = scopeMapper.map(scope);
            for (String mappedScope : mappedScopes) {
                String externalAlias = prefixHandler.addPrefix(mappedScope);
                scopesAliases.add(externalAlias);
            }
        }
        return scopesAliases;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this.setPrefixHandlerFactoriesScopedServiceTrackerMap((ScopedServiceTrackerMap<PrefixHandlerFactory>)this._scopedServiceTrackerMapFactory.create(bundleContext, PrefixHandlerFactory.class, "osgi.jaxrs.name", () -> {
            PrefixHandlerFactory prefixHandlerFactory = this._defaultPrefixHandlerFactory;
            if (prefixHandlerFactory != null) {
                return prefixHandlerFactory;
            }
            return propertyAccessor -> PrefixHandler.PASS_THROUGH_PREFIX_HANDLER;
        }));
        this.setScopeFindersScopedServiceTrackerMap((ScopedServiceTrackerMap<ScopeFinder>)this._scopedServiceTrackerMapFactory.create(bundleContext, ScopeFinder.class, "osgi.jaxrs.name", () -> Collections::emptySet));
        this.setScopeLocatorConfigurationProvidersScopedServiceTrackerMap((ScopedServiceTrackerMap<ScopeLocatorConfigurationProvider>)this._scopedServiceTrackerMapFactory.create(bundleContext, ScopeLocatorConfigurationProvider.class, "osgi.jaxrs.name", () -> {
            if (this._defaultScopeLocatorConfigurationProvider != null) {
                return this._defaultScopeLocatorConfigurationProvider;
            }
            return () -> this._defaultScopeLocatorConfiguration;
        }));
        this.setScopeMappersScopedServiceTrackerMap((ScopedServiceTrackerMap<ScopeMapper>)this._scopedServiceTrackerMapFactory.create(bundleContext, ScopeMapper.class, "osgi.jaxrs.name", () -> {
            ScopeMapper scopeMapper = this._defaultScopeMapper;
            if (scopeMapper != null) {
                return scopeMapper;
            }
            return ScopeMapper.PASS_THROUGH_SCOPE_MAPPER;
        }));
        this.setScopeMatcherFactoriesServiceTrackerMap((ServiceTrackerMap<String, ScopeMatcherFactory>)ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, ScopeMatcherFactory.class, (String)"company.id"));
        this.setScopeFinderByNameServiceTrackerMap(ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, ScopeFinder.class, (String)"osgi.jaxrs.name", (ServiceTrackerCustomizer)new ScopeFinderServiceTupleServiceTrackerCustomizer(bundleContext)));
    }

    @Deactivate
    protected void deactivate() {
        this._scopeFinderByNameServiceTrackerMap.close();
        this._prefixHandlerFactoriesScopedServiceTrackerMap.close();
        this._scopeFindersScopedServiceTrackerMap.close();
        this._scopeLocatorConfigurationProvidersScopedServiceTrackerMap.close();
        this._scopeMappersScopedServiceTrackerMap.close();
        this._scopeMatcherFactoriesServiceTrackerMap.close();
    }

    protected Bundle getBundle(ServiceReference<?> serviceReference) {
        Object property = serviceReference.getProperty("original.service.bundleid");
        if (property == null) {
            return serviceReference.getBundle();
        }
        long bundleId = GetterUtil.getLong((Object)property, (long)-1L);
        if (bundleId == -1L) {
            return serviceReference.getBundle();
        }
        Bundle bundle = this._bundleContext.getBundle(bundleId);
        if (bundle == null) {
            return serviceReference.getBundle();
        }
        return bundle;
    }

    protected ScopeMatcherFactory getScopeMatcherFactory(long companyId) {
        ScopeMatcherFactory scopeMatcherFactory = (ScopeMatcherFactory)this._scopeMatcherFactoriesServiceTrackerMap.getService((Object)String.valueOf(companyId));
        if (scopeMatcherFactory == null) {
            return this._defaultScopeMatcherFactory;
        }
        return scopeMatcherFactory;
    }

    protected boolean scopeMatchesScopesAlias(String scope, ScopeMatcherFactory scopeMatcherFactory, PrefixHandler prefixHandler, String scopesAlias) {
        String prefixedScope = prefixHandler.addPrefix(scope);
        if (scope.length() > prefixedScope.length()) {
            return false;
        }
        String prefix = prefixedScope.substring(0, prefixedScope.length() - scope.length());
        if (!scopesAlias.startsWith(prefix)) {
            return false;
        }
        ScopeMatcher scopeMatcher = scopeMatcherFactory.create(scopesAlias.substring(prefix.length()));
        return scopeMatcher.match(scope);
    }

    @Reference(name="default", unbind="-")
    protected void setDefaultScopeMatcherFactory(ScopeMatcherFactory defaultScopeMatcherFactory) {
        this._defaultScopeMatcherFactory = defaultScopeMatcherFactory;
    }

    protected void setPrefixHandlerFactoriesScopedServiceTrackerMap(ScopedServiceTrackerMap<PrefixHandlerFactory> prefixHandlerFactoriesScopedServiceTrackerMap) {
        this._prefixHandlerFactoriesScopedServiceTrackerMap = prefixHandlerFactoriesScopedServiceTrackerMap;
    }

    @Reference(unbind="-")
    protected void setScopedServiceTrackerMapFactory(ScopedServiceTrackerMapFactory scopedServiceTrackerMapFactory) {
        this._scopedServiceTrackerMapFactory = scopedServiceTrackerMapFactory;
    }

    protected void setScopeFinderByNameServiceTrackerMap(ServiceTrackerMap<String, ServiceReferenceServiceTuple<?, ScopeFinder>> scopeFinderByNameServiceTrackerMap) {
        this._scopeFinderByNameServiceTrackerMap = scopeFinderByNameServiceTrackerMap;
    }

    protected void setScopeFindersScopedServiceTrackerMap(ScopedServiceTrackerMap<ScopeFinder> scopeFindersScopedServiceTrackerMap) {
        this._scopeFindersScopedServiceTrackerMap = scopeFindersScopedServiceTrackerMap;
    }

    protected void setScopeLocatorConfigurationProvidersScopedServiceTrackerMap(ScopedServiceTrackerMap<ScopeLocatorConfigurationProvider> scopeLocatorConfigurationProvidersScopedServiceTrackerMap) {
        this._scopeLocatorConfigurationProvidersScopedServiceTrackerMap = scopeLocatorConfigurationProvidersScopedServiceTrackerMap;
    }

    protected void setScopeMappersScopedServiceTrackerMap(ScopedServiceTrackerMap<ScopeMapper> scopeMappersScopedServiceTrackerMap) {
        this._scopeMappersScopedServiceTrackerMap = scopeMappersScopedServiceTrackerMap;
    }

    protected void setScopeMatcherFactoriesServiceTrackerMap(ServiceTrackerMap<String, ScopeMatcherFactory> scopeMatcherFactoriesServiceTrackerMap) {
        this._scopeMatcherFactoriesServiceTrackerMap = scopeMatcherFactoriesServiceTrackerMap;
    }

    private static class ScopeFinderServiceTupleServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<ScopeFinder, ServiceReferenceServiceTuple<?, ScopeFinder>> {
        private final BundleContext _bundleContext;

        public ScopeFinderServiceTupleServiceTrackerCustomizer(BundleContext bundleContext) {
            this._bundleContext = bundleContext;
        }

        public ServiceReferenceServiceTuple<?, ScopeFinder> addingService(ServiceReference<ScopeFinder> serviceReference) {
            ScopeFinder scopeFinder = (ScopeFinder)this._bundleContext.getService(serviceReference);
            return new ServiceReferenceServiceTuple(serviceReference, (Object)scopeFinder);
        }

        public void modifiedService(ServiceReference<ScopeFinder> serviceReference, ServiceReferenceServiceTuple<?, ScopeFinder> serviceReferenceServiceTuple) {
        }

        public void removedService(ServiceReference<ScopeFinder> serviceReference, ServiceReferenceServiceTuple<?, ScopeFinder> serviceReferenceServiceTuple) {
            this._bundleContext.ungetService(serviceReference);
        }
    }

    @ProviderType
    public static interface ScopeLocatorConfigurationProvider {
        public ScopeLocatorConfiguration getScopeLocatorConfiguration();
    }
}

